/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.bean;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.bean.BeanImplementationType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;
import org.switchyard.tools.ui.wizards.NewBeanServiceWizard;

public class BeanImplementationComposite
extends AbstractModelComposite<Component> {
    private Composite _panel;
    private BeanImplementationType _implementation = null;
    private Link _newBeanLink;
    private Text _beanClassText;
    private Button _browseBeanButton;
    private IJavaProject _project;
    private boolean _updating;

    public BeanImplementationComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormToolkit factory = this.getWidgetFactory();
        this._panel = this;
        this.setLayout((Layout)new GridLayout(3, false));
        this._newBeanLink = new Link(this._panel, 0);
        factory.adapt((Control)this._newBeanLink, true, true);
        this._newBeanLink.setText(Messages.link_beanClass);
        this._newBeanLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BeanImplementationComposite.this.openNewBeanWizard();
            }
        });
        this._beanClassText = factory.createText(this._panel, "", 2056);
        this._beanClassText.setLayoutData((Object)new GridData(768));
        this._beanClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!BeanImplementationComposite.this._updating) {
                    BeanImplementationComposite.this.handleModify((Control)event.getSource());
                }
            }
        });
        this._browseBeanButton = factory.createButton(this._panel, Messages.button_browse, 8);
        this._browseBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BeanImplementationComposite.this.handleBrowse();
            }
        });
    }

    @Override
    public void refresh() {
        this._implementation = null;
        this._project = null;
        Component bo = (Component)this.getTargetObject();
        if (bo != null) {
            this._implementation = (BeanImplementationType)bo.getImplementation();
        }
        this._updating = true;
        try {
            IFile file;
            if (this._implementation.getClass_() != null) {
                this._beanClassText.setText(this._implementation.getClass_());
            } else {
                this._beanClassText.setText("");
            }
            boolean enabled = !MergedModelUtil.isReadOnly((EObject)this._implementation);
            this._browseBeanButton.setEnabled(enabled);
            this._newBeanLink.setEnabled(enabled);
            Resource resource = MergedModelUtil.getSwitchYard((EObject)this._implementation).eResource();
            if (resource.getURI().isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)))) != null) {
                this._project = JavaCore.create((IProject)file.getProject());
            }
        }
        finally {
            this._updating = false;
        }
    }

    private void handleModify(Control control) {
        final String implementationClassText = this._beanClassText.getText().trim();
        if (!implementationClassText.equals(this._implementation.getClass_()) || this._implementation.getClass_() == null && !implementationClassText.isEmpty()) {
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    BeanImplementationComposite.this._implementation.setClass(implementationClassText);
                }
            });
        }
    }

    private void handleBrowse() {
        IJavaSearchScope scope = null;
        scope = this._project == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this._project});
        try {
            Object[] result;
            String filter = this._beanClassText.getText();
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getCurrent().getActiveShell(), null, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(filter.isEmpty() ? "* " : filter));
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                this._beanClassText.setText(((IType)result[0]).getFullyQualifiedName());
                this.handleModify((Control)this._beanClassText);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void openNewBeanWizard() {
        IType type;
        ICompilationUnit icu;
        NewBeanServiceWizard wizard = new NewBeanServiceWizard(false, false);
        SwitchyardSCAEditor editor = SwitchyardSCAEditor.getEditor((EObject)this._implementation);
        StructuredSelection selection = this._project == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)JavaUtil.getInitialPackageForProject((IJavaProject)this._project));
        IWorkbench workbench = editor == null ? PlatformUI.getWorkbench() : editor.getEditorSite().getWorkbenchWindow().getWorkbench();
        EList services = ((Component)this._implementation.eContainer()).getService();
        wizard.init(workbench, (IStructuredSelection)selection);
        wizard.forceServiceInterfaceType(services.isEmpty() || !(((ComponentService)services.get(0)).getInterface() instanceof JavaInterface) ? null : (ComponentService)services.get(0));
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (icu = JavaCore.createCompilationUnitFrom((IFile)wizard.getNewClassFile())) != null && (type = icu.findPrimaryType()) != null) {
            this._beanClassText.setText(type.getFullyQualifiedName());
            this.handleModify((Control)this._beanClassText);
        }
    }
}

