/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.cxf;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.cxf.CamelCxfBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.cxf.CxfPackage;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.CompoundValidator;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.NullElement;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.databinding.URLValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class CamelCxfProducerComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelCxfBindingType _binding = null;
    private Text _nameText;
    private Text _feedURIText;
    private Text _cxfClientUserNameText;
    private Button _relayHeadersCheckbox;
    private Button _wrappedCheckbox;
    private WritableValue _bindingValue;
    private Text _wsdlURLText;
    private Button _browseWSDLButton;
    private ComboViewer _dataFormatComboViewer;
    private Text _serviceClassText;
    private Button _browseServiceClassButton;
    private Text _serviceNameText;
    private Text _portNameText;
    private Text _cxfClientPasswordText;
    private ComboViewer _wrappedStyleComboViewer;
    private IObservableValue _wrappedStyleDetail;
    private Text _defaultOpNameText;
    private Text _defaultOpNamespaceText;

    CamelCxfProducerComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return "CXF Binding";
    }

    @Override
    public String getDescription() {
        return "CXF Binding";
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelCxfBindingType) {
            this._binding = (CamelCxfBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
            if (!this._binding.isSetWrappedStyle()) {
                this._wrappedStyleComboViewer.getCombo().setText("");
            } else {
                this._wrappedStyleComboViewer.setSelection((ISelection)new StructuredSelection((Object)this._binding.isWrappedStyle()));
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getProducerTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getProducerTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name, 2);
        this._feedURIText = this.createLabelAndText(composite, "CXF URI*", 2);
        this._wsdlURLText = this.createLabelAndText(composite, "WSDL URL");
        this._browseWSDLButton = this.getToolkit().createButton(composite, "...", 8);
        this._browseWSDLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = CamelCxfProducerComposite.this.selectResourceFromWorkspace(CamelCxfProducerComposite.this._panel.getShell(), "wsdl");
                if (result != null) {
                    CamelCxfProducerComposite.this.setTextValueAndNotify(CamelCxfProducerComposite.this._wsdlURLText, result, false);
                }
            }
        });
        this._dataFormatComboViewer = this.createLabelAndComboViewer(composite, "Data Format", true, 2);
        this._dataFormatComboViewer.add((Object[])new String[]{"POJO", "PAYLOAD", "MESSAGE"});
        this._serviceClassText = this.createLabelAndText(composite, "Service Class");
        this._browseServiceClassButton = this.getToolkit().createButton(composite, "...", 8);
        this._browseServiceClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = CamelCxfProducerComposite.this.handleBrowse(CamelCxfProducerComposite.this._serviceClassText.getText());
                if (result != null) {
                    CamelCxfProducerComposite.this.setTextValueAndNotify(CamelCxfProducerComposite.this._serviceClassText, result, false);
                }
            }
        });
        this._serviceNameText = this.createLabelAndText(composite, "Service Name", 2);
        this._portNameText = this.createLabelAndText(composite, "Port Name", 2);
        this._relayHeadersCheckbox = this.createCheckbox(composite, "Relay Headers", 3);
        this._wrappedCheckbox = this.createCheckbox(composite, "Wrapped", 3);
        this._wrappedStyleComboViewer = this.createLabelAndComboViewer(composite, "Wrapped Style", true, 2);
        this._wrappedStyleComboViewer.add(new Object[]{NullElement.getInstance(), Boolean.TRUE, Boolean.FALSE});
        this._wrappedStyleComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                CamelCxfProducerComposite.this.updateWrappedStyleCombo(ssel.getFirstElement());
            }
        });
        Group clientAuthGroup = new Group(composite, 0);
        clientAuthGroup.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        clientAuthGroup.setLayout((Layout)new GridLayout(2, false));
        clientAuthGroup.setText("CXF Client Authentication");
        this._cxfClientUserNameText = this.createLabelAndText((Composite)clientAuthGroup, "User Name");
        this._cxfClientPasswordText = this.createLabelAndText((Composite)clientAuthGroup, "Password");
        this._cxfClientPasswordText.setEchoChar('*');
        Group defaultOperationGroup = new Group(composite, 0);
        defaultOperationGroup.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        defaultOperationGroup.setLayout((Layout)new GridLayout(2, false));
        defaultOperationGroup.setText("Default Operation");
        this._defaultOpNameText = this.createLabelAndText((Composite)defaultOperationGroup, "Name");
        this._defaultOpNamespaceText = this.createLabelAndText((Composite)defaultOperationGroup, "Namespace");
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelCxfBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("CXF binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("CXF binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        CompoundValidator uriValidator = new CompoundValidator(new StringEmptyValidator("CXF URI may not be empty."), new URLValidator("Potential problem with CXF URI"));
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._feedURIText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__CXF_URI), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(uriValidator), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._wsdlURLText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__WSDL_URL), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        IObservableValue dataFormatModelValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__DATA_FORMAT);
        binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._dataFormatComboViewer), dataFormatModelValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        final IObservableValue relayHeaders = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__RELAY_HEADERS);
        dataFormatModelValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Object value = event.getObservableValue().getValue();
                if (value != null && value instanceof String) {
                    String strValue = (String)value;
                    boolean isPojo = strValue.equalsIgnoreCase("POJO");
                    CamelCxfProducerComposite.this._relayHeadersCheckbox.setEnabled(isPojo);
                    if (isPojo) {
                        relayHeaders.setValue((Object)Boolean.TRUE);
                    } else {
                        CamelCxfProducerComposite.this.wrapOperation(new Runnable(){

                            @Override
                            public void run() {
                                CamelCxfProducerComposite.this._binding.unsetRelayHeaders();
                            }
                        });
                    }
                }
            }
        });
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._serviceClassText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__SERVICE_CLASS), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._serviceNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__SERVICE_NAME), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._portNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__PORT_NAME), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._relayHeadersCheckbox), relayHeaders, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._wrappedCheckbox), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__WRAPPED), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        this._wrappedStyleDetail = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__WRAPPED_STYLE);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._cxfClientPasswordText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__PASSWORD), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._cxfClientUserNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__USERNAME), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._defaultOpNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__DEFAULT_OPERATION_NAME), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._defaultOpNamespaceText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CxfPackage.Literals.CAMEL_CXF_BINDING_TYPE__DEFAULT_OPERATION_NAMESPACE), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }

    private String selectResourceFromWorkspace(Shell shell, String extension) {
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        IJavaProject javaProject = null;
        if (modelFile != null && modelFile.getProject() != null) {
            javaProject = JavaCore.create((IProject)modelFile.getProject());
        }
        ClasspathResourceSelectionDialog dialog = null;
        dialog = javaProject == null ? new ClasspathResourceSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), extension) : new ClasspathResourceSelectionDialog(shell, (IContainer)javaProject.getProject(), extension);
        dialog.setTitle("Select WSDL from Project");
        dialog.setInitialPattern("*." + extension);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return null;
        }
        return JavaUtil.getJavaPathForResource((IResource)((IResource)result[0])).toString();
    }

    private String handleBrowse(String initialSelection) {
        IJavaSearchScope scope = null;
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        IJavaProject javaProject = null;
        if (modelFile != null && modelFile.getProject() != null) {
            javaProject = JavaCore.create((IProject)modelFile.getProject());
        }
        scope = javaProject == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        try {
            Object[] result;
            String filter = initialSelection;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getCurrent().getActiveShell(), null, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(filter.isEmpty() ? "* " : filter));
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                return ((IType)result[0]).getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void updateWrappedStyleCombo(Object value) {
        if (value instanceof NullElement) {
            this._binding.unsetWrappedStyle();
        } else if (value instanceof Boolean) {
            this._wrappedStyleDetail.setValue(value);
        }
    }
}

