/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.quartz;

import java.util.Arrays;
import java.util.TimeZone;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.quartz.CamelQuartzBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.quartz.QuartzPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyLongValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.binding.OperationSelectorComposite;

public class CamelQuartzComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelQuartzBindingType _binding = null;
    private Text _nameText;
    private Text _cronText;
    private Text _startTimeText;
    private Text _endTimeText;
    private Text _repeatCountText;
    private Text _repeatIntervalText;
    private Combo _quartzTypeCombo;
    private ComboViewer _timezoneViewer;
    private OperationSelectorComposite _opSelectorComposite;
    private WritableValue _bindingValue;
    private org.eclipse.core.databinding.Binding _cronBinding;
    private IObservableValue _cronValue;
    private org.eclipse.core.databinding.Binding _repeatIntervalBinding;
    private IObservableValue _repeatIntervalValue;
    private org.eclipse.core.databinding.Binding _repeatCountBinding;
    private IObservableValue _repeatCountValue;

    CamelQuartzComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_schedulingBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_schedulingBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelQuartzBindingType) {
            this._binding = (CamelQuartzBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed() && this.getTargetObject() != null) {
                this._opSelectorComposite.setTargetObject(this.getTargetObject());
            }
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed() && this._binding != null) {
                this._opSelectorComposite.setBinding((Binding)this._binding);
            }
            if (this._binding != null) {
                boolean repeatIntervalSet;
                boolean cronSet = this._binding.getCron() != null;
                boolean repeatCountSet = this._binding.getTriggerRepeatCount() != null;
                boolean bl = repeatIntervalSet = this._binding.getTriggerRepeatInterval() != null;
                if (cronSet) {
                    this._quartzTypeCombo.select(0);
                } else if (repeatCountSet || repeatIntervalSet) {
                    this._quartzTypeCombo.select(1);
                } else if (!(cronSet || repeatCountSet || repeatIntervalSet)) {
                    this._quartzTypeCombo.select(0);
                }
                this.handleScheduleTypeSelection();
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(target);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getSchedulerTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getSchedulerTabControl(Composite tabFolder) {
        Composite composite = this.getToolkit().createComposite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_nameStar);
        this._quartzTypeCombo = this.createLabelAndCombo(composite, "Scheduling Type", true);
        this._quartzTypeCombo.add("cron");
        this._quartzTypeCombo.add("trigger");
        this._quartzTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CamelQuartzComposite.this.handleScheduleTypeSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._quartzTypeCombo.select(0);
        this._cronText = this.createLabelAndText(composite, Messages.label_cronStar, 1, "The cron field is only mandatory when the Scheduling Type is set to 'cron'.");
        this._repeatCountText = this.createLabelAndText(composite, "Repeat Count");
        this._repeatIntervalText = this.createLabelAndText(composite, "Repeat Interval");
        this._startTimeText = this.createLabelAndText(composite, Messages.label_startTime);
        this._endTimeText = this.createLabelAndText(composite, Messages.label_endTime);
        this._timezoneViewer = this.createLabelAndComboViewer(composite, Messages.label_timeZone, true);
        this._timezoneViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._timezoneViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String[] timezones = TimeZone.getAvailableIDs();
        Object[] tzPlusBlank = Arrays.copyOf(timezones, timezones.length + 1);
        tzPlusBlank[timezones.length] = "";
        Arrays.sort(tzPlusBlank);
        this._timezoneViewer.setInput((Object)tzPlusBlank);
        this._opSelectorComposite = new OperationSelectorComposite(composite, 0, this);
        this._opSelectorComposite.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        this._opSelectorComposite.setLayout((Layout)new GridLayout(2, false));
        this._opSelectorComposite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CamelQuartzComposite.this.handleModify((Control)CamelQuartzComposite.this._opSelectorComposite);
            }
        });
        return composite;
    }

    private void handleScheduleTypeSelection() {
        boolean cronEnabled = this._quartzTypeCombo.getSelectionIndex() == 0;
        this._cronText.setEnabled(cronEnabled);
        this._repeatCountText.setEnabled(!cronEnabled);
        this._repeatIntervalText.setEnabled(!cronEnabled);
        if (!cronEnabled) {
            this._cronValue.setValue(null);
        } else {
            this._repeatCountValue.setValue(null);
            this._repeatIntervalValue.setValue(null);
        }
        this._cronBinding.validateTargetToModel();
        this._repeatCountBinding.validateTargetToModel();
        this._repeatIntervalBinding.validateTargetToModel();
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        if (control.equals((Object)this._opSelectorComposite)) {
            this.fireChangedEvent((Object)this._opSelectorComposite);
        }
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelQuartzBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__CAMEL_BINDING_NAME), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Schedule binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__CAMEL_BINDING_NAME), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Schedule binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        this._cronValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__CRON);
        this._cronBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._cronText, (int[])new int[]{24}), this._cronValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidatorControlAware(Messages.CamelQuartzComposite_Validation_CRON_Empty, (Control)this._cronText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._cronBinding), (int)16512);
        EMFUpdateValueStrategyNullForEmptyString startTimeStrategy = new EMFUpdateValueStrategyNullForEmptyString(Messages.CamelQuartzComposite_Validation_Start_Time_Format, UpdateValueStrategy.POLICY_CONVERT);
        ISWTObservableValue delayed1 = this.createDelayedObservableText(this._startTimeText);
        binding = context.bindValue((IObservableValue)delayed1, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__TRIGGER_START_TIME), (UpdateValueStrategy)startTimeStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        EMFUpdateValueStrategyNullForEmptyString endTimeStrategy = new EMFUpdateValueStrategyNullForEmptyString(Messages.CamelQuartzComposite_Validation_End_Time_Format, UpdateValueStrategy.POLICY_CONVERT);
        ISWTObservableValue delayed2 = this.createDelayedObservableText(this._endTimeText);
        binding = context.bindValue((IObservableValue)delayed2, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__TRIGGER_END_TIME), (UpdateValueStrategy)endTimeStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._timezoneViewer), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__TRIGGER_TIME_ZONE), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        this._repeatCountValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__TRIGGER_REPEAT_COUNT);
        this._repeatCountBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._repeatCountText, (int[])new int[]{24}), this._repeatCountValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidatorControlAware("Repeat Count must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').", (Control)this._repeatCountText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._repeatCountBinding), (int)16512);
        this._repeatIntervalValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)QuartzPackage.Literals.CAMEL_QUARTZ_BINDING_TYPE__TRIGGER_REPEAT_INTERVAL);
        this._repeatIntervalBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._repeatIntervalText, (int[])new int[]{24}), this._repeatIntervalValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyLongValidatorControlAware("Repeat Interval must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').", (Control)this._repeatIntervalText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._repeatIntervalBinding), (int)16512);
        this._opSelectorComposite.bindControls(domain, context);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }

    private class EscapedPropertyIntegerValidatorControlAware
    extends EscapedPropertyIntegerValidator {
        private Control _control;

        public EscapedPropertyIntegerValidatorControlAware(String message, Control control) {
            super(message);
            this._control = null;
            this._control = control;
        }

        @Override
        public IStatus validate(Object value) {
            if (this._control != null && !this._control.isEnabled()) {
                return Status.OK_STATUS;
            }
            return super.validate(value);
        }
    }

    private class EscapedPropertyLongValidatorControlAware
    extends EscapedPropertyLongValidator {
        private Control _control;

        public EscapedPropertyLongValidatorControlAware(String message, Control control) {
            super(message);
            this._control = null;
            this._control = control;
        }

        @Override
        public IStatus validate(Object value) {
            if (this._control != null && !this._control.isEnabled()) {
                return Status.OK_STATUS;
            }
            return super.validate(value);
        }
    }

    private class StringEmptyValidatorControlAware
    extends StringEmptyValidator {
        private Control _control;

        public StringEmptyValidatorControlAware(String message, Control control) {
            super(message);
            this._control = null;
            this._control = control;
        }

        @Override
        public IStatus validate(Object value) {
            if (this._control != null && !this._control.isEnabled()) {
                return Status.OK_STATUS;
            }
            return super.validate(value);
        }
    }
}

