/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.resteasy;

import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class DelimitedStringList
extends Composite {
    private static final String DELIMITER = ",";
    private Button _mAddButton;
    private Button _mClearAllButton;
    private Button _mRemoveButton;
    private Button _mDownButton;
    private Button _mUpButton;
    private List _mPropsList;
    private Text _mAddText;
    private Text _mHiddenText;
    private boolean _isReadOnly = false;
    private String _mDelimiter = ",";
    private String _mWarning = null;
    private ListenerList _changeListeners;

    protected Text getHiddenText() {
        return this._mHiddenText;
    }

    public DelimitedStringList(Composite parent, int style) {
        this(parent, style, false);
    }

    public DelimitedStringList(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this._mPropsList = new List((Composite)this, 2048);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.verticalSpan = 5;
        this._mPropsList.setLayoutData((Object)gridData);
        this._mPropsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.updatePropertyButtons();
            }
        });
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(256));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IType selected = DelimitedStringList.this.selectType(DelimitedStringList.this.getShell(), null, null);
                    if (selected != null) {
                        DelimitedStringList.this.addStringToList(selected.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
                DelimitedStringList.this.fireChangedEvent(e.getSource());
            }
        });
        this._mUpButton = new Button((Composite)this, 0);
        this._mUpButton.setLayoutData((Object)new GridData(256));
        this._mUpButton.setText(Messages.button_up);
        this._mUpButton.setEnabled(false);
        this._mUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.moveUpInList();
            }
        });
        this._mDownButton = new Button((Composite)this, 0);
        this._mDownButton.setLayoutData((Object)new GridData(256));
        this._mDownButton.setText(Messages.button_down);
        this._mDownButton.setEnabled(false);
        this._mDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.moveDownInList();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(256));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.removeFromList();
            }
        });
        this._mClearAllButton = new Button((Composite)this, 0);
        this._mClearAllButton.setEnabled(false);
        this._mClearAllButton.setLayoutData((Object)new GridData(256));
        this._mClearAllButton.setText(Messages.button_clearAll);
        this._mClearAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this._mPropsList.removeAll();
                DelimitedStringList.this._mHiddenText.setText(DelimitedStringList.this.getSelection().trim());
                DelimitedStringList.this.notifyListeners();
                DelimitedStringList.this.updatePropertyButtons();
            }
        });
        this._mHiddenText = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this._mHiddenText.setLayoutData((Object)gridData);
        this._mHiddenText.setVisible(false);
        this.updatePropertyButtons();
    }

    public void addModifyListener(ModifyListener listener) {
        this._mHiddenText.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this._mHiddenText.removeModifyListener(listener);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void notifyListeners() {
        this._mHiddenText.notifyListeners(24, null);
        this._mHiddenText.notifyListeners(14, null);
    }

    private void addStringToList(String text) {
        if (text.length() > 0) {
            this._mPropsList.add(text.trim());
            if (!this._isReadOnly) {
                this._mClearAllButton.setEnabled(true);
            }
            String selected = this.getSelection();
            this._mHiddenText.setText(selected.trim());
            this.notifyListeners();
        }
    }

    private void removeFromList() {
        if (this._mPropsList.getSelectionCount() == 1) {
            int index = this._mPropsList.getSelectionIndex();
            this._mPropsList.remove(index);
            String selected = this.getSelection();
            this._mHiddenText.setText(selected.trim());
            this.notifyListeners();
            try {
                if (this._mPropsList.getItem(index) != null) {
                    this._mPropsList.select(index);
                }
            }
            catch (IllegalArgumentException e) {
                e.fillInStackTrace();
            }
        }
        this._mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    private void moveUpInList() {
        if (this._mPropsList.getSelectionCount() == 1) {
            int selection = this._mPropsList.getSelectionIndex();
            int destination = -1;
            if (selection > 0) {
                destination = selection - 1;
                String value_a = this._mPropsList.getItem(destination);
                String value_b = this._mPropsList.getItem(selection);
                String[] items = this._mPropsList.getItems();
                this._mPropsList.removeAll();
                int counter = 0;
                while (counter < items.length) {
                    if (counter == destination) {
                        this._mPropsList.add(value_b);
                        this._mPropsList.add(value_a);
                        counter += 2;
                        continue;
                    }
                    this._mPropsList.add(items[counter]);
                    ++counter;
                }
                String selected = this.getSelection();
                this._mHiddenText.setText(selected.trim());
                this.notifyListeners();
                this._mPropsList.setSelection(destination);
            }
        }
        this._mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    private void moveDownInList() {
        if (this._mPropsList.getSelectionCount() == 1) {
            int selection = this._mPropsList.getSelectionIndex();
            int destination = -1;
            if (selection < this._mPropsList.getItemCount() - 1) {
                destination = selection + 1;
                String value_a = this._mPropsList.getItem(destination);
                String value_b = this._mPropsList.getItem(selection);
                String[] items = this._mPropsList.getItems();
                this._mPropsList.removeAll();
                int counter = 0;
                while (counter < items.length) {
                    if (counter == selection) {
                        this._mPropsList.add(value_a);
                        this._mPropsList.add(value_b);
                    } else if (counter == destination) {
                        System.out.println("");
                    } else {
                        this._mPropsList.add(items[counter]);
                    }
                    ++counter;
                }
                String selected = this.getSelection();
                this._mHiddenText.setText(selected.trim());
                this.notifyListeners();
                this._mPropsList.setSelection(destination);
            }
        }
        this._mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    public String getSelection() {
        String selectString = "";
        int i = 0;
        while (i < this._mPropsList.getItems().length) {
            String testitem = this._mPropsList.getItem(i).trim();
            selectString = String.valueOf(selectString) + testitem;
            if (i < this._mPropsList.getItems().length - 1) {
                selectString = String.valueOf(selectString) + this._mDelimiter;
            }
            ++i;
        }
        return selectString;
    }

    public void updatePropertyButtons() {
        if (!this._isReadOnly) {
            this._mDownButton.setEnabled(false);
            this._mUpButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
            this._mClearAllButton.setEnabled(false);
            if (this._mPropsList.getItemCount() > 0) {
                this._mClearAllButton.setEnabled(true);
                if (this._mPropsList.getSelectionCount() == 1) {
                    int selection = this._mPropsList.getSelectionIndex();
                    this._mRemoveButton.setEnabled(true);
                    if (selection - 1 >= 0) {
                        this._mUpButton.setEnabled(true);
                    }
                    if (selection + 1 < this._mPropsList.getItemCount()) {
                        this._mDownButton.setEnabled(true);
                    }
                }
            }
        }
    }

    public boolean setFocus() {
        if (this._mAddText != null) {
            return this._mAddText.setFocus();
        }
        return false;
    }

    public void setSelection(String str_list) {
        String[] str_array = this.parseString(str_list);
        this._mPropsList.setItems(str_array);
        this.updatePropertyButtons();
    }

    private String[] parseString(String str_list) {
        StringTokenizer tk = new StringTokenizer(str_list, this._mDelimiter);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public void setDelimiter(String delimiter) {
        this._mDelimiter = delimiter;
    }

    public String getDelimiter() {
        return this._mDelimiter;
    }

    public String getWarning() {
        return this._mWarning;
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaSearchScope searchScope = null;
        if (project == null) {
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            }
        }
        if (superTypeName != null && !superTypeName.equals("java.lang.Object")) {
            IJavaProject javaProject;
            IType superType;
            if (project == null) {
                project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
            }
            if ((superType = (javaProject = JavaCore.create((IProject)project)).findType(superTypeName)) != null) {
                searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)false, null);
            }
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)512, (boolean)false);
        dialog.setTitle(Messages.title_selectEntries);
        dialog.setMessage(Messages.description_matchingItems);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }
}

