/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.rules.ContainerType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.util.PropTypeUtil;

public class KIEContainerDetailsComposite
extends Composite {
    private static final Pattern GAV_PATTERN = Pattern.compile("([^: ]*)(:([^: ]*)(:([^: ]*))?)?");
    private ContainerType _container = RulesFactory.eINSTANCE.createContainerType();
    private boolean _updating;
    private Text _sessionNameText;
    private Text _baseNameText;
    private Text _groupIdText;
    private Text _artifactIdText;
    private Text _versionText;
    private Button _scanCheckbox;
    private Text _scanIntervalText;

    public KIEContainerDetailsComposite(Composite parent, FormToolkit factory) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(3, false));
        factory.createLabel((Composite)this, Messages.label_sessionName);
        this._sessionNameText = factory.createText((Composite)this, "", 2048);
        this._sessionNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._sessionNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue;
                String string = newValue = KIEContainerDetailsComposite.this._sessionNameText.getText().length() == 0 ? null : KIEContainerDetailsComposite.this._sessionNameText.getText();
                if (!KIEContainerDetailsComposite.this._updating && (newValue == null && KIEContainerDetailsComposite.this.getContainer().getSessionName() != null || newValue != null && !newValue.equals(KIEContainerDetailsComposite.this.getContainer().getSessionName()))) {
                    KIEContainerDetailsComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            KIEContainerDetailsComposite.this.getContainer().setSessionName(newValue);
                        }
                    });
                }
            }
        });
        Group releaseGroup = new Group((Composite)this, 0);
        releaseGroup.setText(Messages.label_releaseId);
        releaseGroup.setLayout((Layout)new GridLayout(2, false));
        releaseGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 4));
        releaseGroup.setToolTipText(Messages.tooltip_releaseId);
        ModifyListener releaseIdListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue;
                if (KIEContainerDetailsComposite.this._updating) {
                    return;
                }
                String artifactId = KIEContainerDetailsComposite.this._artifactIdText.getText();
                String groupId = KIEContainerDetailsComposite.this._groupIdText.getText();
                String version = KIEContainerDetailsComposite.this._versionText.getText();
                if (artifactId.length() == 0 && groupId.length() == 0 && version.length() == 0) {
                    newValue = null;
                } else {
                    StringBuffer buf = new StringBuffer();
                    if (groupId.length() > 0) {
                        buf.append(groupId);
                    }
                    buf.append(":");
                    if (artifactId.length() > 0) {
                        buf.append(artifactId);
                    }
                    if (version.length() > 0) {
                        buf.append(":").append(version);
                    }
                    newValue = buf.toString();
                }
                if (newValue == null && KIEContainerDetailsComposite.this._container.getReleaseId() != null || newValue != null && !newValue.equals(KIEContainerDetailsComposite.this._container.getReleaseId())) {
                    KIEContainerDetailsComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            KIEContainerDetailsComposite.this._container.setReleaseId(newValue);
                        }
                    });
                }
            }
        };
        factory.createLabel((Composite)releaseGroup, Messages.label_groupId);
        this._groupIdText = factory.createText((Composite)releaseGroup, "", 2048);
        this._groupIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._groupIdText.addModifyListener(releaseIdListener);
        factory.createLabel((Composite)releaseGroup, Messages.label_artifactId);
        this._artifactIdText = factory.createText((Composite)releaseGroup, "", 2048);
        this._artifactIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._artifactIdText.addModifyListener(releaseIdListener);
        factory.createLabel((Composite)releaseGroup, Messages.label_version);
        this._versionText = factory.createText((Composite)releaseGroup, "", 2048);
        this._versionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._versionText.addModifyListener(releaseIdListener);
        factory.createLabel((Composite)this, Messages.label_baseName);
        this._baseNameText = factory.createText((Composite)this, "", 2048);
        this._baseNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._baseNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue;
                String string = newValue = KIEContainerDetailsComposite.this._baseNameText.getText().length() == 0 ? null : KIEContainerDetailsComposite.this._baseNameText.getText();
                if (!KIEContainerDetailsComposite.this._updating && (newValue == null && KIEContainerDetailsComposite.this._container.getBaseName() != null || newValue != null && !newValue.equals(KIEContainerDetailsComposite.this._container.getBaseName()))) {
                    KIEContainerDetailsComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            KIEContainerDetailsComposite.this._container.setBaseName(newValue);
                        }
                    });
                }
            }
        });
        this._scanCheckbox = factory.createButton((Composite)this, Messages.label_scanForUpdates, 32);
        this._scanCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._scanCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                final boolean scan = KIEContainerDetailsComposite.this._scanCheckbox.getSelection();
                KIEContainerDetailsComposite.this._scanIntervalText.setEnabled(scan);
                if (!KIEContainerDetailsComposite.this._updating && scan != KIEContainerDetailsComposite.this._container.isScan()) {
                    KIEContainerDetailsComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            KIEContainerDetailsComposite.this._container.setScan(scan);
                        }
                    });
                }
            }
        });
        Label label = factory.createLabel((Composite)this, Messages.label_scanInterval);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        this._scanIntervalText = factory.createText((Composite)this, "", 2048);
        this._scanIntervalText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._scanIntervalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    final long newValue = KIEContainerDetailsComposite.this._scanIntervalText.getText().length() == 0 ? 0L : Long.valueOf(KIEContainerDetailsComposite.this._scanIntervalText.getText());
                    long oldValue = -1L;
                    try {
                        oldValue = Long.parseLong(PropTypeUtil.getPropValueString(KIEContainerDetailsComposite.this._container.getScanInterval()));
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                    if (!KIEContainerDetailsComposite.this._updating && newValue != oldValue) {
                        KIEContainerDetailsComposite.this.wrapOperation(new Runnable(){

                            @Override
                            public void run() {
                                KIEContainerDetailsComposite.this._container.setScanInterval((Object)newValue);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
        });
    }

    public void setContainer(ContainerType container) {
        if (container == null) {
            container = RulesFactory.eINSTANCE.createContainerType();
        }
        this._container = container;
        this._sessionNameText.setText(this._container.getSessionName() == null ? "" : this._container.getSessionName());
        this._baseNameText.setText(this._container.getBaseName() == null ? "" : this._container.getBaseName());
        this._scanCheckbox.setSelection(this._container.isScan());
        this._scanIntervalText.setEnabled(this._container.isScan());
        this._scanIntervalText.setText(PropTypeUtil.getPropValueString(this._container.getScanInterval()));
        if (this._container.getReleaseId() == null) {
            this._groupIdText.setText("");
            this._artifactIdText.setText("");
            this._versionText.setText("");
        } else {
            String version;
            String artifactId;
            String groupId;
            Matcher matcher = GAV_PATTERN.matcher(this._container.getReleaseId());
            if (matcher.matches()) {
                groupId = matcher.group(1);
                artifactId = matcher.group(3);
                version = matcher.group(5);
            } else {
                groupId = "";
                artifactId = "";
                version = "";
            }
            this._groupIdText.setText(groupId == null ? "" : groupId);
            this._artifactIdText.setText(artifactId == null ? "" : artifactId);
            this._versionText.setText(version == null ? "" : version);
        }
    }

    public ContainerType getContainer() {
        return this._container;
    }

    private void wrapOperation(final Runnable runner) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this._container);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        runner.run();
                    }
                    catch (Exception e) {
                        Activator.logError(e);
                    }
                }
            });
        } else {
            try {
                runner.run();
            }
            catch (Exception e) {
                Activator.logError(e);
            }
        }
    }
}

