/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import java.math.BigInteger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.rules.LoggerType;
import org.switchyard.tools.models.switchyard1_0.rules.LoggerType1;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.models.switchyard1_0.rules.RulesImplementationType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class RulesLoggerTable
extends Composite
implements ICellModifier {
    private TableViewer _propertyTreeTable;
    private static final String LOG_COLUMN = "log";
    private static final String TYPE_COLUMN = "type";
    private static final String INTERVAL_COLUMN = "interval";
    private static final String[] TREE_COLUMNS = new String[]{"type", "log", "interval"};
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;

    public RulesLoggerTable(Composite parent, int style) {
        this(parent, style, false);
    }

    public RulesLoggerTable(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, false, 1, 2);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableColumn typeColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        typeColumn.setText(Messages.label_type);
        tableLayout.setColumnData((Widget)typeColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn logColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        logColumn.setText(Messages.label_log);
        tableLayout.setColumnData((Widget)logColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn intervalColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        intervalColumn.setText(Messages.label_interval);
        tableLayout.setColumnData((Widget)intervalColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this._propertyTreeTable.setCellModifier((ICellModifier)this);
        this._propertyTreeTable.setCellEditors(new CellEditor[]{new ComboBoxCellEditor((Composite)this._propertyTreeTable.getTable(), new String[]{LoggerType.CONSOLE.getLiteral(), LoggerType.FILE.getLiteral(), LoggerType.THREADEDFILE.getLiteral()}), new TextCellEditor((Composite)this._propertyTreeTable.getTable()), new PropertyDescriptor.EDataTypeCellEditor(RulesPackage.eINSTANCE.getLoggerType1_Interval().getEAttributeType(), (Composite)this._propertyTreeTable.getTable())});
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesLoggerTable.this.addPropertyToList();
                if (RulesLoggerTable.this._propertyTreeTable.getInput() == null) {
                    RulesLoggerTable.this._propertyTreeTable.setInput((Object)RulesLoggerTable.this._targetObj);
                }
                RulesLoggerTable.this._propertyTreeTable.refresh();
                RulesLoggerTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesLoggerTable.this.updatePropertyButtons();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesLoggerTable.this.removeFromList();
                RulesLoggerTable.this._propertyTreeTable.refresh();
                RulesLoggerTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void addPropertyToList() {
        if (this.getTargetObject() instanceof RulesImplementationType) {
            final RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
            final LoggerType1 newLogger = RulesFactory.eINSTANCE.createLoggerType1();
            newLogger.setLog("NewLogger");
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        if (impl.getLoggers() == null) {
                            impl.setLoggers(RulesFactory.eINSTANCE.createLoggersType());
                        }
                        impl.getLoggers().getLogger().add((Object)newLogger);
                        RulesLoggerTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                if (impl.getLoggers() == null) {
                    impl.setLoggers(RulesFactory.eINSTANCE.createLoggersType());
                }
                impl.getLoggers().getLogger().add((Object)newLogger);
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected void removeFromList() {
        if (this.getTargetObject() instanceof RulesImplementationType) {
            final RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
            final LoggerType1 actionToRemove = this.getTableSelection();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        impl.getLoggers().getLogger().remove((Object)actionToRemove);
                        if (impl.getLoggers().getLogger().isEmpty()) {
                            impl.setLoggers(null);
                        }
                        RulesLoggerTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                impl.getLoggers().getLogger().remove((Object)actionToRemove);
                if (impl.getLoggers().getLogger().isEmpty()) {
                    impl.setLoggers(null);
                }
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected LoggerType1 getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof LoggerType1) {
            return (LoggerType1)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getTableSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._propertyTreeTable.setInput((Object)target);
        this.updatePropertyButtons();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    public boolean canModify(Object element, String property) {
        if (element instanceof LoggerType1) {
            LoggerType1 logger = (LoggerType1)element;
            if (property.equalsIgnoreCase(LOG_COLUMN) && (logger.getType().equals((Object)LoggerType.THREADEDFILE) || logger.getType().equals((Object)LoggerType.FILE))) {
                return true;
            }
            if (property.equalsIgnoreCase(INTERVAL_COLUMN) && logger.getType().equals((Object)LoggerType.THREADEDFILE)) {
                return true;
            }
            return property.equalsIgnoreCase(TYPE_COLUMN);
        }
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof LoggerType1 && property.equalsIgnoreCase(LOG_COLUMN)) {
            if (((LoggerType1)element).getLog() != null) {
                return ((LoggerType1)element).getLog();
            }
            return "";
        }
        if (element instanceof LoggerType1 && property.equalsIgnoreCase(TYPE_COLUMN)) {
            return new Integer(((LoggerType1)element).getType().getValue());
        }
        if (element instanceof LoggerType1 && property.equalsIgnoreCase(INTERVAL_COLUMN)) {
            return ((LoggerType1)element).getInterval();
        }
        return null;
    }

    public void modify(Object element, String property, final Object value) {
        if (element instanceof TableItem && property.equalsIgnoreCase(LOG_COLUMN)) {
            TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesImplementationType) {
                RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
                final LoggerType1 parm = (LoggerType1)ti.getData();
                if (value == null && parm.getLog() == null || value != null && value.equals(parm.getLog())) {
                    return;
                }
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            parm.setLog((String)value);
                            RulesLoggerTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    parm.setLog((String)value);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(TYPE_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesImplementationType) {
                RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            LoggerType1 parm = (LoggerType1)ti.getData();
                            LoggerType atype = LoggerType.get((int)((Integer)value));
                            parm.setType(atype);
                            if (atype.equals((Object)LoggerType.FILE)) {
                                parm.setInterval(null);
                            } else if (!atype.equals((Object)LoggerType.THREADEDFILE)) {
                                parm.setLog(null);
                                parm.setInterval(null);
                            }
                            RulesLoggerTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    LoggerType1 parm = (LoggerType1)ti.getData();
                    LoggerType atype = LoggerType.get((int)((Integer)value));
                    parm.setType(atype);
                    if (atype.equals((Object)LoggerType.FILE)) {
                        parm.setInterval(null);
                    } else if (!atype.equals((Object)LoggerType.THREADEDFILE)) {
                        parm.setLog(null);
                        parm.setInterval(null);
                    }
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(INTERVAL_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesImplementationType) {
                RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            LoggerType1 parm = (LoggerType1)ti.getData();
                            parm.setInterval((Object)((BigInteger)value));
                            RulesLoggerTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    LoggerType1 parm = (LoggerType1)ti.getData();
                    parm.setInterval((Object)((BigInteger)value));
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected TableViewer getTableViewer() {
        return this._propertyTreeTable;
    }

    private class PropertyTreeContentProvider
    implements IStructuredContentProvider {
        private PropertyTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            RulesImplementationType bpmImpl;
            if (inputElement instanceof RulesImplementationType && (bpmImpl = (RulesImplementationType)inputElement).getLoggers() != null) {
                return bpmImpl.getLoggers().getLogger().toArray();
            }
            return new Object[0];
        }
    }

    private class PropertyTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof LoggerType1 && property.equalsIgnoreCase(RulesLoggerTable.LOG_COLUMN)) {
                return true;
            }
            return element instanceof LoggerType1 && property.equalsIgnoreCase(RulesLoggerTable.TYPE_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof LoggerType1 && columnIndex == 1) {
                if (((LoggerType1)element).getLog() != null) {
                    return ((LoggerType1)element).getLog();
                }
                return "";
            }
            if (element instanceof LoggerType1 && columnIndex == 0) {
                return ((LoggerType1)element).getType().getLiteral();
            }
            if (element instanceof LoggerType1 && columnIndex == 2) {
                if (((LoggerType1)element).getInterval() != null) {
                    return ((LoggerType1)element).getInterval().toString();
                }
                return "";
            }
            return null;
        }
    }
}

