/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.binding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.AccessibleClassValidator;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.RegexListValidator;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.IBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class MessageComposerComposite
extends AbstractSYBindingComposite
implements IBindingComposite {
    private Composite _panel;
    private Text _composerClassText;
    private Button _browseComposerClassBtn;
    private Text _mapperClassText;
    private Button _browseMapperClassBtn;
    private Text _includesText;
    private Text _includesNSText;
    private Text _excludesText;
    private Text _excludesNSText;
    private Hyperlink _newComposerClassLink;
    private Hyperlink _newMapperClassLink;
    private final EClass _messageComposerType;
    private final EStructuralFeature _messageComposerFeature;
    private final EClass _contextMapperType;
    private final EStructuralFeature _contextMapperFeature;
    private IObservableValue _bindingValue;

    public MessageComposerComposite(FormToolkit toolkit, EStructuralFeature messageComposerFeature, EStructuralFeature contextMapperFeature) {
        this(toolkit, SwitchyardPackage.Literals.MESSAGE_COMPOSER_TYPE, messageComposerFeature, SwitchyardPackage.Literals.CONTEXT_MAPPER_TYPE, contextMapperFeature);
    }

    public MessageComposerComposite(FormToolkit toolkit, EClass messageComposerType, EStructuralFeature messageComposerFeature, EClass contextMapperType, EStructuralFeature contextMapperFeature) {
        super(toolkit);
        this._messageComposerType = messageComposerType;
        this._messageComposerFeature = messageComposerFeature;
        this._contextMapperType = contextMapperType;
        this._contextMapperFeature = contextMapperFeature;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public String getTitle() {
        return Messages.title_messageComposer;
    }

    @Override
    public String getDescription() {
        return Messages.description_messageComposer;
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = this.getToolkit().createComposite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        this._panel.setLayout((Layout)gl);
        this._newComposerClassLink = this.getToolkit().createHyperlink(this._panel, Messages.link_customMessageComposerClass, 0);
        this._newComposerClassLink.setEnabled(this.canEdit());
        this._newComposerClassLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MessageComposerComposite.this.handleClassLink(MessageComposerComposite.this._composerClassText, MessageComposerComposite.this._newComposerClassLink, "org.switchyard.component.common.composer.MessageComposer<T>");
            }
        });
        this._composerClassText = this.createLabelAndText(this._panel, null);
        this._composerClassText.setEnabled(this.canEdit());
        this._composerClassText.setData((Object)"class");
        this._browseComposerClassBtn = this.getToolkit().createButton(this._panel, Messages.button_browse, 8);
        this._browseComposerClassBtn.setEnabled(this.canEdit());
        GridData btnGD = new GridData();
        this._browseComposerClassBtn.setLayoutData((Object)btnGD);
        this._browseComposerClassBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageComposerComposite.this.handleClassBrowse(MessageComposerComposite.this._browseComposerClassBtn, MessageComposerComposite.this._composerClassText, "org.switchyard.component.common.composer.MessageComposer");
            }
        });
        this._newMapperClassLink = this.getToolkit().createHyperlink(this._panel, Messages.link_customContextMapperClass, 0);
        this._newMapperClassLink.setEnabled(this.canEdit());
        this._newMapperClassLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MessageComposerComposite.this.handleClassLink(MessageComposerComposite.this._mapperClassText, MessageComposerComposite.this._newMapperClassLink, "org.switchyard.component.common.composer.ContextMapper<T>");
            }
        });
        this._mapperClassText = this.createLabelAndText(this._panel, null);
        this._mapperClassText.setEnabled(this.canEdit());
        this._mapperClassText.setData((Object)"class");
        this._browseMapperClassBtn = this.getToolkit().createButton(this._panel, Messages.button_browse, 8);
        this._browseMapperClassBtn.setEnabled(this.canEdit());
        GridData btnGD2 = new GridData();
        this._browseMapperClassBtn.setLayoutData((Object)btnGD2);
        this._browseMapperClassBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageComposerComposite.this.handleClassBrowse(MessageComposerComposite.this._browseMapperClassBtn, MessageComposerComposite.this._mapperClassText, "org.switchyard.component.common.composer.ContextMapper");
            }
        });
        Group regExGroup = new Group(this._panel, 0);
        regExGroup.setText(Messages.label_regularExpressions);
        regExGroup.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        regExGroup.setLayout((Layout)new GridLayout(2, false));
        this._includesText = this.createLabelAndText((Composite)regExGroup, Messages.label_includes);
        this._includesText.setEnabled(this.canEdit());
        this._includesText.setData((Object)"includes");
        this._excludesText = this.createLabelAndText((Composite)regExGroup, Messages.label_excludes);
        this._excludesText.setEnabled(this.canEdit());
        this._excludesText.setData((Object)"excludes");
        this._includesNSText = this.createLabelAndText((Composite)regExGroup, Messages.label_includeNamespaces);
        this._includesNSText.setEnabled(this.canEdit());
        this._includesNSText.setData((Object)"includeNamespaces");
        this._excludesNSText = this.createLabelAndText((Composite)regExGroup, Messages.label_excludeNamespaces);
        this._excludesNSText.setEnabled(this.canEdit());
        this._excludesNSText.setData((Object)"excludeNamespaces");
        this.bindControls(context);
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._panel.getDisplay());
        this._bindingValue = new WritableValue(realm, null, Binding.class);
        FeaturePath messageComposerClassFeature = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._messageComposerFeature, SwitchyardPackage.Literals.MESSAGE_COMPOSER_TYPE__CLASS});
        IObservableValue composerClassValue = EMFProperties.value((FeaturePath)messageComposerClassFeature).observeDetail(this._bindingValue);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._composerClassText, (int[])new int[]{24}), composerClassValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, this._bindingValue, messageComposerClassFeature, true).setAfterConvertValidator(new AccessibleClassValidator(BeanProperties.value((String)"targetObject").observe((Object)this))), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath contextMapperClassFeature = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._contextMapperFeature, SwitchyardPackage.Literals.CONTEXT_MAPPER_TYPE__CLASS});
        ISWTObservableValue mapperClassTextValue = SWTObservables.observeText((Control)this._mapperClassText, (int[])new int[]{24});
        IObservableValue mapperClassValue = EMFProperties.value((FeaturePath)contextMapperClassFeature).observeDetail(this._bindingValue);
        final org.eclipse.core.databinding.Binding mapperClassBinding = context.bindValue((IObservableValue)mapperClassTextValue, mapperClassValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, this._bindingValue, contextMapperClassFeature, true).setAfterConvertValidator(new AccessibleClassValidator(BeanProperties.value((String)"targetObject").observe((Object)this))), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(mapperClassBinding), (int)16512);
        FeaturePath contextMapperIncludesFeature = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._contextMapperFeature, SwitchyardPackage.Literals.CONTEXT_MAPPER_TYPE__INCLUDES});
        ISWTObservableValue includesTextValue = SWTObservables.observeText((Control)this._includesText, (int[])new int[]{24});
        IObservableValue includesValue = EMFProperties.value((FeaturePath)contextMapperIncludesFeature).observeDetail(this._bindingValue);
        binding = context.bindValue((IObservableValue)includesTextValue, includesValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, this._bindingValue, contextMapperIncludesFeature, true).setAfterConvertValidator(new RegexListValidator()), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath contextMapperExcludesFeature = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._contextMapperFeature, SwitchyardPackage.Literals.CONTEXT_MAPPER_TYPE__EXCLUDES});
        ISWTObservableValue excludesTextValue = SWTObservables.observeText((Control)this._excludesText, (int[])new int[]{24});
        IObservableValue excludesValue = EMFProperties.value((FeaturePath)contextMapperExcludesFeature).observeDetail(this._bindingValue);
        binding = context.bindValue((IObservableValue)excludesTextValue, excludesValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, this._bindingValue, contextMapperExcludesFeature, true).setAfterConvertValidator(new RegexListValidator()), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath contextMapperIncludesNSFeature = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._contextMapperFeature, SwitchyardPackage.Literals.CONTEXT_MAPPER_TYPE__INCLUDE_NAMESPACES});
        ISWTObservableValue includesNSTextValue = SWTObservables.observeText((Control)this._includesNSText, (int[])new int[]{24});
        IObservableValue includesNSValue = EMFProperties.value((FeaturePath)contextMapperIncludesNSFeature).observeDetail(this._bindingValue);
        binding = context.bindValue((IObservableValue)includesNSTextValue, includesNSValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, this._bindingValue, contextMapperIncludesNSFeature, true).setAfterConvertValidator(new RegexListValidator()), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath contextMapperExcludesNSFeature = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._contextMapperFeature, SwitchyardPackage.Literals.CONTEXT_MAPPER_TYPE__EXCLUDE_NAMESPACES});
        ISWTObservableValue excludesNSTextValue = SWTObservables.observeText((Control)this._excludesNSText, (int[])new int[]{24});
        IObservableValue excludesNSValue = EMFProperties.value((FeaturePath)contextMapperExcludesNSFeature).observeDetail(this._bindingValue);
        binding = context.bindValue((IObservableValue)excludesNSTextValue, excludesNSValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, this._bindingValue, contextMapperExcludesNSFeature, true).setAfterConvertValidator(new RegexListValidator()), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        context.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator((IObservableValue)mapperClassTextValue, (IObservableValue)includesTextValue, (IObservableValue)excludesTextValue, (IObservableValue)includesNSTextValue, (IObservableValue)excludesNSTextValue){
            private final /* synthetic */ IObservableValue val$mapperClassTextValue;
            private final /* synthetic */ IObservableValue val$includesTextValue;
            private final /* synthetic */ IObservableValue val$excludesTextValue;
            private final /* synthetic */ IObservableValue val$includesNSTextValue;
            private final /* synthetic */ IObservableValue val$excludesNSTextValue;
            {
                this.val$mapperClassTextValue = iObservableValue;
                this.val$includesTextValue = iObservableValue2;
                this.val$excludesTextValue = iObservableValue3;
                this.val$includesNSTextValue = iObservableValue4;
                this.val$excludesNSTextValue = iObservableValue5;
            }

            protected IStatus validate() {
                IStatus mapperClassStatus;
                ObservableTracker.setIgnore((boolean)true);
                try {
                    mapperClassStatus = (IStatus)mapperClassBinding.getValidationStatus().getValue();
                }
                finally {
                    ObservableTracker.setIgnore((boolean)false);
                }
                String mapperClass = (String)this.val$mapperClassTextValue.getValue();
                String includes = (String)this.val$includesTextValue.getValue();
                String excludes = (String)this.val$excludesTextValue.getValue();
                String includesNS = (String)this.val$includesNSTextValue.getValue();
                String excludesNS = (String)this.val$excludesNSTextValue.getValue();
                if (mapperClassStatus != null && !mapperClassStatus.isOK() || MessageComposerComposite.this.cmClassSupportsRegEx(mapperClass)) {
                    return Status.OK_STATUS;
                }
                if (MessageComposerComposite.this.isNullOrEmpty(mapperClass) || MessageComposerComposite.this.isNullOrEmpty(includes) && MessageComposerComposite.this.isNullOrEmpty(excludes) && MessageComposerComposite.this.isNullOrEmpty(includesNS) && MessageComposerComposite.this.isNullOrEmpty(excludesNS)) {
                    return Status.OK_STATUS;
                }
                return new Status(2, "org.switchyard.tools.ui.editor", "Selected context mapper class does not support regular expressions.");
            }
        });
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private void handleClassBrowse(Button classBrowseBtn, Text classText, String interfaceName) {
        try {
            IType selected;
            IFile modelFile;
            IProject project = null;
            if (this.getBinding() != null && (modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile()) != null) {
                project = modelFile.getProject();
            }
            if ((selected = this.selectType(this.getPanel().getShell(), interfaceName, project)) != null) {
                classText.setText(selected.getFullyQualifiedName());
                classText.notifyListeners(24, null);
                classText.notifyListeners(14, null);
                classText.setFocus();
            }
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
    }

    private void handleClassLink(Text classText, Hyperlink classLink, String interfaceName) {
        if (classText != null && !classText.isDisposed()) {
            String classname = classText.getText();
            try {
                IType foundClass = this.canFindClass(classname);
                if (foundClass == null) {
                    String className = this.handleCreateJavaClass(classname, interfaceName);
                    if (className != null) {
                        classText.setText(className);
                        classText.notifyListeners(24, null);
                        classText.notifyListeners(14, null);
                        classText.setFocus();
                    }
                    return;
                }
                this.handleOpenJavaClass(foundClass);
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void setBinding(Binding switchYardBindingType) {
        super.setBinding(switchYardBindingType);
        this._bindingValue.setValue((Object)switchYardBindingType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cmClassSupportsRegEx(String classname) {
        try {
            IType cmClassType = this.canFindClass(classname);
            if (cmClassType == null) return false;
            ITypeHierarchy hierarchy = cmClassType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            if (hierarchy == null) return false;
            IType[] iTypeArray = hierarchy.getAllInterfaces();
            int n = iTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType intf = iTypeArray[n2];
                if ("RegexContextMapper".equals(intf.getElementName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.fillInStackTrace();
        }
        return false;
    }

    private IType canFindClass(String classname) throws JavaModelException {
        IJavaProject javaProject;
        IType superType;
        IProject project = null;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
            if (selectionToPass.getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            } else if (selectionToPass.getFirstElement() instanceof AbstractGraphicalEditPart) {
                project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
            }
        }
        if (selectionToPass == StructuredSelection.EMPTY) {
            project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
        }
        if (project != null && classname != null && (superType = (javaProject = JavaCore.create((IProject)project)).findType(classname)) != null) {
            return superType;
        }
        return null;
    }

    private void handleOpenJavaClass(IType classToOpen) {
        if (classToOpen != null) {
            try {
                JavaUI.openInEditor((IJavaElement)classToOpen);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private String handleCreateJavaClass(String className, String interfaceName) throws JavaModelException {
        IType stype;
        String name;
        IProject project = null;
        IJavaProject javaProject = null;
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (modelFile != null) {
            selectionToPass = new StructuredSelection((Object)modelFile);
            project = ((IFile)selectionToPass.getFirstElement()).getProject();
        }
        NewClassWizardPage page = new NewClassWizardPage();
        ArrayList<String> interfaces = new ArrayList<String>();
        if (interfaceName != null && interfaceName.trim().length() > 0) {
            interfaces.add(interfaceName);
            page.setSuperInterfaces(interfaces, true);
        }
        IPackageFragmentRoot packRoot = null;
        if (project != null) {
            IPackageFragment[] packages;
            javaProject = JavaCore.create((IProject)project);
            if (!className.isEmpty()) {
                if (className.contains(".")) {
                    className = className.substring(className.lastIndexOf(46) + 1);
                }
                page.setTypeName(className, true);
            }
            IPackageFragment[] iPackageFragmentArray = packages = javaProject.getPackageFragments();
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment mypackage = iPackageFragmentArray[n2];
                if (mypackage.getKind() == 1) {
                    selectionToPass = new StructuredSelection((Object)mypackage);
                    packRoot = (IPackageFragmentRoot)mypackage.getParent();
                    break;
                }
                ++n2;
            }
            page.setPackageFragmentRoot(packRoot, true);
        }
        action.setSelection((IStructuredSelection)selectionToPass);
        if (javaProject != null) {
            IJavaElement[] roots = packRoot.getChildren();
            PackageFragment stashFrag = null;
            int i = 0;
            while (i < roots.length) {
                PackageFragment frag = (PackageFragment)roots[i];
                if (!frag.isDefaultPackage() && !frag.hasSubpackages()) {
                    stashFrag = frag;
                    break;
                }
                ++i;
            }
            if (stashFrag != null) {
                page.setPackageFragment(stashFrag, true);
            }
        }
        action.setConfiguredWizardPage(page);
        action.setOpenEditorOnFinish(false);
        action.run();
        IJavaElement createdElement = action.getCreatedElement();
        if (createdElement != null && createdElement instanceof IType && (name = (stype = (IType)createdElement).getFullyQualifiedName()) != null) {
            return name;
        }
        return null;
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaProject javaProject;
        IJavaSearchScope searchScope = null;
        if (project != null && superTypeName != null && !superTypeName.equals("java.lang.Object")) {
            javaProject = JavaCore.create((IProject)project);
            IType superType = javaProject.findType(superTypeName);
            if (superType != null) {
                searchScope = SearchEngine.createHierarchyScope((IType)superType);
            }
        } else if (project != null) {
            javaProject = JavaCore.create((IProject)project);
            searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProject.getJavaModel().getChildren());
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)512, (boolean)false);
        dialog.setTitle(Messages.title_selectEntries);
        dialog.setMessage(Messages.description_matchingItems);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }

    @Override
    protected void wrapOperation(List<ModelOperation> ops) {
        this.wrapOperation((EObject)this.getBinding(), ops);
    }

    protected Text getComposerClassText() {
        return this._composerClassText;
    }

    protected Text getMapperClassText() {
        return this._mapperClassText;
    }

    protected Text getIncludesText() {
        return this._includesText;
    }

    protected Text getIncludesNSText() {
        return this._includesNSText;
    }

    protected Text getExcludesText() {
        return this._excludesText;
    }

    protected Text getExcludesNSText() {
        return this._excludesNSText;
    }

    public class BasicOperation
    extends ModelOperation {
        private String _localObjectPath;
        private String _localFeature;
        private Object _localValue;

        public BasicOperation(String objectpath, String featureId, Object value) {
            this._localObjectPath = objectpath;
            this._localFeature = featureId;
            this._localValue = value;
        }

        @Override
        public void run() throws Exception {
            String[] path = MessageComposerComposite.this.parseString(this._localObjectPath, "/");
            Binding object = MessageComposerComposite.this.getBinding();
            int i = 0;
            while (i < path.length) {
                object = (EObject)MessageComposerComposite.this.getFeatureValue((EObject)object, path[i]);
                ++i;
            }
            if (object != null) {
                if (this._localValue instanceof String && ((String)this._localValue).length() == 0) {
                    MessageComposerComposite.this.setFeatureValue((EObject)object, this._localFeature, null);
                } else {
                    MessageComposerComposite.this.setFeatureValue((EObject)object, this._localFeature, this._localValue);
                }
            } else {
                throw new Exception();
            }
        }
    }
}

