/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.component;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class SCADiagramResizeComponentFeature
extends DefaultResizeShapeFeature {
    public SCADiagramResizeComponentFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        GraphicsAlgorithm textGa;
        Shape shape = context.getShape();
        int x = context.getX();
        int y = context.getY();
        int width = context.getWidth();
        int height = context.getHeight();
        int edging = 30;
        GraphicsAlgorithm shapeGa = shape.getGraphicsAlgorithm();
        if (shapeGa != null) {
            Graphiti.getGaService().setLocationAndSize(shapeGa, x - 15, y - 15, width + edging, height + edging);
            if (!shapeGa.getGraphicsAlgorithmChildren().isEmpty()) {
                EList children = shapeGa.getGraphicsAlgorithmChildren();
                for (GraphicsAlgorithm graphicsAlgorithm : children) {
                    if (!(graphicsAlgorithm instanceof RoundedRectangle)) continue;
                    RoundedRectangle rrect = (RoundedRectangle)graphicsAlgorithm;
                    Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)rrect, 15, 0, width - edging, height - edging);
                }
            }
        }
        if ((textGa = this.findChildGA(shapeGa, Text.class)) != null) {
            IGaService gaService = Graphiti.getGaService();
            Text text = (Text)textGa;
            text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            gaService.setLocationAndSize((GraphicsAlgorithm)text, 15, 15, width - edging, height - edging);
        }
    }

    private GraphicsAlgorithm findChildGA(GraphicsAlgorithm parent, Class<?> gaSearchType) {
        EList childGAs = parent.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithm : childGAs) {
            if (graphicsAlgorithm.getClass().getCanonicalName().contentEquals(gaSearchType.getCanonicalName())) {
                return graphicsAlgorithm;
            }
            if (graphicsAlgorithm.getClass() != gaSearchType && gaSearchType.isAssignableFrom(graphicsAlgorithm.getClass())) {
                return graphicsAlgorithm;
            }
            if (graphicsAlgorithm.getGraphicsAlgorithmChildren().size() <= 0) continue;
            return this.findChildGA(graphicsAlgorithm, gaSearchType);
        }
        return null;
    }
}

