/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.componentreference;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.Multiplicity;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformsType;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.composite.SCADiagramAddCompositeFeature;
import org.switchyard.tools.ui.editor.diagram.compositereference.PromoteReferenceWizard;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class SCADiagramCustomPromoteReferenceFeature
extends AbstractCustomFeature {
    private boolean _hasDoneChanges = false;

    public SCADiagramCustomPromoteReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ComponentReference) {
            ComponentReference componentReference = (ComponentReference)bo;
            Reference newReference = null;
            PromoteReferenceWizard wizard = new PromoteReferenceWizard();
            wizard.init(componentReference);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            WizardDialog wizDialog = new WizardDialog(shell, (IWizard)wizard);
            boolean doNotAddNewShape = false;
            int rtn_code = wizDialog.open();
            if (rtn_code == 0) {
                newReference = (Reference)wizard.getContract();
                newReference.setMultiplicity(Multiplicity._01);
                Component parentComponent = (Component)componentReference.eContainer();
                Composite parentComposite = (Composite)parentComponent.eContainer();
                EList refs = parentComposite.getReference();
                for (Reference ref : refs) {
                    boolean nameMatch = false;
                    boolean foundDupe = false;
                    if (ref.getName().equals(newReference.getName())) {
                        nameMatch = true;
                        if (ref.getInterface().eClass().getName().equals(newReference.getInterface().eClass().getName())) {
                            JavaInterface newRefIntfc;
                            JavaInterface refIntfc;
                            if (ref.getInterface() instanceof JavaInterface) {
                                refIntfc = (JavaInterface)ref.getInterface();
                                newRefIntfc = (JavaInterface)newReference.getInterface();
                                if (refIntfc.getInterface().equals(newRefIntfc.getInterface())) {
                                    foundDupe = true;
                                }
                            } else if (ref.getInterface() instanceof EsbInterface) {
                                refIntfc = (EsbInterface)ref.getInterface();
                                newRefIntfc = (EsbInterface)newReference.getInterface();
                                boolean inputMatch = false;
                                if (refIntfc.getInputType() != null && refIntfc.getInputType().equals(newRefIntfc.getInputType())) {
                                    inputMatch = true;
                                } else if (refIntfc.getInputType() == null && newRefIntfc.getInputType() == null) {
                                    inputMatch = true;
                                }
                                boolean outputMatch = false;
                                if (refIntfc.getOutputType() != null && refIntfc.getOutputType().equals(newRefIntfc.getOutputType())) {
                                    outputMatch = true;
                                } else if (refIntfc.getOutputType() == null && newRefIntfc.getOutputType() == null) {
                                    outputMatch = true;
                                }
                                boolean faultMatch = false;
                                if (refIntfc.getFaultType() != null && refIntfc.getFaultType().equals(newRefIntfc.getFaultType())) {
                                    faultMatch = true;
                                } else if (refIntfc.getFaultType() == null && newRefIntfc.getFaultType() == null) {
                                    faultMatch = true;
                                }
                                if (inputMatch && outputMatch && faultMatch) {
                                    foundDupe = true;
                                }
                            } else if (ref.getInterface() instanceof WSDLPortType) {
                                refIntfc = (WSDLPortType)ref.getInterface();
                                newRefIntfc = (WSDLPortType)newReference.getInterface();
                                if (refIntfc.getInterface().equals(newRefIntfc.getInterface())) {
                                    foundDupe = true;
                                }
                            }
                        }
                    }
                    if (foundDupe && nameMatch) {
                        newReference = ref;
                        doNotAddNewShape = true;
                        break;
                    }
                    if (foundDupe || !nameMatch) continue;
                    this._hasDoneChanges = false;
                    MessageDialog dialog = new MessageDialog(shell, Messages.title_invalidReferencePromotion, null, MessageFormat.format(Messages.error_compositeReferenceAlreadyExists, newReference.getName()), 0, new String[]{Messages.label_ok}, 0);
                    dialog.open();
                    return;
                }
            } else {
                this._hasDoneChanges = false;
                return;
            }
            newReference.getPromote().add((Object)componentReference);
            SwitchYardType switchYardRoot = MergedModelUtil.getSwitchYard((EObject)componentReference);
            Composite composite = switchYardRoot.getComposite();
            composite.getReference().add((Object)newReference);
            Collection<TransformType> newTransforms = wizard.getCreatedTransforms();
            if (newTransforms != null && newTransforms.size() > 0) {
                TransformsType transforms = switchYardRoot.getTransforms();
                if (transforms == null) {
                    switchYardRoot.setTransforms(SwitchyardFactory.eINSTANCE.createTransformsType());
                    transforms = switchYardRoot.getTransforms();
                }
                EList transformsList = transforms.getTransform();
                for (TransformType newTransform : newTransforms) {
                    transformsList.add(newTransform);
                }
            }
            if (!doNotAddNewShape) {
                ContainerShape compositeShape = (ContainerShape)this.getFeatureProvider().getPictogramElementForBusinessObject((Object)composite);
                AddContext addRefContext = SCADiagramAddCompositeFeature.createReferenceAddContext(this.getFeatureProvider(), compositeShape);
                addRefContext.setNewObject((Object)newReference);
                Shape referenceShape = (Shape)this.addGraphicalRepresentation((IAreaContext)addRefContext, newReference);
                if (referenceShape != null) {
                    this.layoutPictogramElement((PictogramElement)compositeShape);
                }
            }
            this._hasDoneChanges = true;
        }
    }

    public String getDescription() {
        return Messages.featureDescription_promoteReference;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            return this.getBusinessObjectForPictogramElement(pes[0]) instanceof ComponentReference;
        }
        return false;
    }

    public String getName() {
        return Messages.featureName_promoteReference;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_PROMOTE;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }
}

