/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.componentservice;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.model.merge.CompositeMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.ContractMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class UpdateComponentServiceFeature
extends AbstractUpdateFeature {
    private boolean _hasDoneChanges;

    public UpdateComponentServiceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return this.getBusinessObjectForPictogramElement(context.getPictogramElement()) instanceof ComponentService && context.getPictogramElement() instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        ComponentService service = (ComponentService)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)service)) {
            return Reason.createTrueReason((String)String.format(Messages.updateReason_serviceRemoved, service.getName()));
        }
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)container);
        ContractMergedModelAdapter mergeAdapter = MergedModelUtil.getAdapter((EObject)service, ContractMergedModelAdapter.class);
        CompositeMergedModelAdapter composite = MergedModelUtil.getAdapter((EObject)mergeAdapter.getSwitchYard().getComposite(), CompositeMergedModelAdapter.class);
        for (Service compositeService : composite.getServices()) {
            if (compositeService.getPromote() != service || existingConnections.remove(compositeService)) continue;
            return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
        }
        if (service.getName() != null && service.getName().length() > 0) {
            for (Component other : composite.getComponents()) {
                if (other == service.eContainer()) continue;
                for (ComponentReference reference : other.getReference()) {
                    if (!service.getName().equals(reference.getName()) || existingConnections.remove(reference)) continue;
                    return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
                }
            }
        }
        return existingConnections.isEmpty() && container.getAnchors().size() == 2 ? Reason.createFalseReason() : Reason.createTrueReason((String)Messages.updateReason_updateConnections);
    }

    public boolean update(IUpdateContext context) {
        FixPointAnchor anchor;
        this._hasDoneChanges = false;
        ComponentService service = (ComponentService)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)service)) {
            RemoveContext removeContext = new RemoveContext(context.getPictogramElement());
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (removeFeature != null && removeFeature.canRemove((IRemoveContext)removeContext)) {
                removeFeature.remove((IRemoveContext)removeContext);
                this._hasDoneChanges = removeFeature.hasDoneChanges();
                return true;
            }
        }
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)container);
        ContractMergedModelAdapter mergeAdapter = MergedModelUtil.getAdapter((EObject)service, ContractMergedModelAdapter.class);
        CompositeMergedModelAdapter composite = MergedModelUtil.getAdapter((EObject)mergeAdapter.getSwitchYard().getComposite(), CompositeMergedModelAdapter.class);
        if (container.getAnchors().size() != 2) {
            anchor = Graphiti.getPeCreateService().createFixPointAnchor((AnchorContainer)container);
            Ellipse anchorGa = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)anchor);
            anchorGa.setFilled(Boolean.valueOf(false));
            anchorGa.setLineVisible(Boolean.valueOf(false));
            Graphiti.getGaLayoutService().setLocationAndSize((GraphicsAlgorithm)anchorGa, -1, -9, 10, 20);
            anchor.setLocation(Graphiti.getGaCreateService().createPoint(1, 9));
            anchor.setUseAnchorLocationAsConnectionEndpoint(true);
            this.link((PictogramElement)anchor, service);
            container.getAnchors().move(0, (Object)anchor);
            for (Connection connection : new ArrayList(((Anchor)container.getAnchors().get(1)).getIncomingConnections())) {
                connection.setEnd((Anchor)anchor);
            }
        }
        anchor = (Anchor)container.getAnchors().get(0);
        block1: for (Service compositeService : composite.getServices()) {
            if (compositeService.getPromote() != service || existingConnections.remove(compositeService)) continue;
            PictogramElement[] pictogramElementArray = this.getFeatureProvider().getAllPictogramElementsForBusinessObject((Object)compositeService);
            int n = pictogramElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                if (pe instanceof Anchor) {
                    AddConnectionContext addContext = new AddConnectionContext((Anchor)pe, (Anchor)anchor);
                    addContext.setNewObject((Object)service);
                    this.updatePictogramElement(this.getFeatureProvider().addIfPossible((IAddContext)addContext));
                    this._hasDoneChanges = true;
                    continue block1;
                }
                ++n2;
            }
        }
        if (service.getName() != null && service.getName().length() > 0) {
            block3: for (Component other : composite.getComponents()) {
                if (other == service.eContainer()) continue;
                for (ComponentReference reference : other.getReference()) {
                    if (!service.getName().equals(reference.getName()) || existingConnections.remove(reference)) continue;
                    PictogramElement[] pictogramElementArray = this.getFeatureProvider().getAllPictogramElementsForBusinessObject((Object)reference);
                    int n = pictogramElementArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PictogramElement pe = pictogramElementArray[n3];
                        if (pe instanceof Anchor) {
                            AddConnectionContext addContext = new AddConnectionContext((Anchor)pe, (Anchor)anchor);
                            addContext.setNewObject((Object)reference);
                            this.updatePictogramElement(this.getFeatureProvider().addIfPossible((IAddContext)addContext));
                            this._hasDoneChanges = true;
                            continue block3;
                        }
                        ++n3;
                    }
                }
            }
        }
        for (Connection connection : new ArrayList(anchor.getIncomingConnections())) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getStart());
            if (bo != null && !existingConnections.remove(bo)) continue;
            RemoveContext removeContext = new RemoveContext((PictogramElement)connection);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (!removeFeature.canExecute((IContext)removeContext)) continue;
            removeFeature.execute((IContext)removeContext);
            boolean bl = this._hasDoneChanges = this._hasDoneChanges || removeFeature.hasDoneChanges();
        }
        return this._hasDoneChanges;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    private Set<Contract> getExistingConnections(AnchorContainer container) {
        LinkedHashSet<Contract> existingConnections = new LinkedHashSet<Contract>();
        for (Anchor anchor : container.getAnchors()) {
            for (Connection connection : anchor.getIncomingConnections()) {
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getStart());
                if (!(bo instanceof Contract) && bo != null) continue;
                existingConnections.add((Contract)bo);
            }
        }
        return existingConnections;
    }
}

