/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.compositereference;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;

public class SCADiagramLayoutCompositeReferenceFeature
extends AbstractLayoutFeature {
    private static final int MIN_HEIGHT = 50;
    private static final int MIN_WIDTH = 100;

    public SCADiagramLayoutCompositeReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        EList businessObjects = pe.getLink().getBusinessObjects();
        return businessObjects.size() == 1 && businessObjects.get(0) instanceof Reference;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        if (containerGa.getHeight() < 50) {
            containerGa.setHeight(50);
            anythingChanged = true;
        }
        if (containerGa.getWidth() < 100) {
            containerGa.setWidth(100);
            anythingChanged = true;
        }
        for (Anchor anchor : containerShape.getAnchors()) {
            if (!(anchor instanceof FixPointAnchor)) continue;
            ((FixPointAnchor)anchor).setLocation(Graphiti.getGaService().createPoint((int)(14.0 * (double)containerGa.getWidth() / 100.0), containerGa.getHeight() / 2));
        }
        return anythingChanged;
    }
}

