/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.connections;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformsType;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;
import org.switchyard.tools.ui.editor.transform.TransformDetails;

public class CustomAddTransformFeature
extends AbstractCustomFeature {
    private boolean _hasDoneChanges = false;

    public CustomAddTransformFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        TransformDetails details;
        SwitchYardType switchYardRoot;
        this._hasDoneChanges = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes == null || pes.length != 1) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            if (pes[0] instanceof Connection) {
                Connection connection = (Connection)pes[0];
                Object startbo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getStart().getParent());
                Object endbo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getEnd().getParent());
                if (!(startbo instanceof Contract) || !(endbo instanceof Contract)) {
                    return;
                }
                switchYardRoot = MergedModelUtil.getSwitchYard((EObject)startbo);
                details = new TransformDetails(switchYardRoot, (Contract)startbo, (Contract)endbo);
            } else {
                Object bo = this.getBusinessObjectForPictogramElement(pes[0]);
                if (!(bo instanceof EObject)) {
                    return;
                }
                switchYardRoot = MergedModelUtil.getSwitchYard((EObject)bo);
                details = new TransformDetails(switchYardRoot);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)Messages.title_errorResolvingTransformers, (String)(String.valueOf(Messages.description_errorResolvingTransformers) + e.getMessage()));
            return;
        }
        if (details.getDeclaredTransforms().containsAll(details.getRequiredTransforms())) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.title_noTransformersRequired, (String)Messages.description_noTransformersRequired);
            return;
        }
        NewTransformWizard wizard = new NewTransformWizard();
        wizard.init(details);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() != 0) {
            return;
        }
        Collection<TransformType> newTransforms = wizard.getCreatedTransforms();
        if (newTransforms == null || newTransforms.isEmpty()) {
            return;
        }
        TransformsType transforms = switchYardRoot.getTransforms();
        if (transforms == null) {
            switchYardRoot.setTransforms(SwitchyardFactory.eINSTANCE.createTransformsType());
            transforms = switchYardRoot.getTransforms();
        }
        EList transformsList = transforms.getTransform();
        for (TransformType newTransform : newTransforms) {
            transformsList.add(newTransform);
        }
        this._hasDoneChanges = true;
    }

    public String getDescription() {
        return Messages.featureDescription_createRequiredTransformers;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            return pes[0] instanceof Connection || this.getBusinessObjectForPictogramElement(pes[0]) instanceof Composite;
        }
        return false;
    }

    public String getName() {
        return Messages.featureName_createRequiredTransformers;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_PLUS;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }
}

