/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.implementation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.widgets.Shell;
import org.switchyard.tools.ui.editor.ComponentTypeExtensionManager;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.implementation.IImplementationTypeFactory;
import org.switchyard.tools.ui.editor.diagram.shared.CreateTypeFeature;

public class CreateImplementationFeature
extends CreateTypeFeature<Implementation, Component> {
    private String _imageId = ImageProvider.IMG_16_IMPLEMENTATION_TYPE;

    public CreateImplementationFeature(IFeatureProvider fp, IImplementationTypeFactory factory, String name, String description) {
        super(fp, factory, Component.class, name, description);
    }

    public CreateImplementationFeature(IFeatureProvider fp, IImplementationTypeFactory factory, String name, String description, String imageId) {
        super(fp, factory, Component.class, name, description);
        this._imageId = imageId;
    }

    @Override
    public Object[] create(ICreateContext context) {
        if (((Component)this.getContainerObject(context)).getImplementation() != null && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.title_replaceCurrentImplementation, (String)Messages.description_replaceCurrentImplementation)) {
            return null;
        }
        return super.create(context);
    }

    @Override
    protected Object[] updateContainer(ICreateContext context, Implementation newObject) {
        List<ComponentReference> references;
        ComponentService service;
        ArrayList<Object> added = new ArrayList<Object>(3);
        Component component = (Component)this.getContainerObject(context);
        component.setImplementation(newObject);
        added.add(newObject);
        IImplementationTypeFactory factory = (IImplementationTypeFactory)this.getFactory();
        if (component.getService().size() == 0 && (service = factory.getImplementedService()) != null) {
            component.getService().add((Object)service);
            added.add(service);
        }
        if (component.getReference().size() == 0 && (references = factory.getImplementationReferences()) != null) {
            for (ComponentReference reference : references) {
                component.getReference().add((Object)reference);
                added.add(reference);
            }
        }
        return added.toArray();
    }

    public String getCreateImageId() {
        return this._imageId;
    }

    @Override
    protected Collection<String> getRequiredCapabilities(Implementation newObject) {
        return ComponentTypeExtensionManager.instance().getExtensionFor(newObject.getClass()).getRequiredCapabilities(newObject);
    }
}

