/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.service;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.NewContractWizardPage;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;
import org.switchyard.tools.ui.editor.transform.TransformDetails;

public class PromoteServiceWizardPage
extends NewContractWizardPage {
    private Contract _targetContract;
    private SwitchYardType _switchYard;
    private IProject _project;
    private TransformDetails _details;
    private IResource _targetResource;
    private IResource _sourceResource;
    private Button _createTransformersCheck;
    private NewTransformWizard _transformWizard = new NewTransformWizard();
    private boolean _creatingTransformers;

    public PromoteServiceWizardPage() {
        super(PromoteServiceWizardPage.class.getCanonicalName(), Messages.title_promoteComponentService, Messages.description_promoteComponentService, ScaPackage.eINSTANCE.getService());
    }

    @Override
    public void init(Contract contract, Contract related) {
        super.init(contract, related);
        this._targetContract = related;
        this._switchYard = MergedModelUtil.getSwitchYard((EObject)this._targetContract);
        this._project = PlatformResourceAdapterFactory.getContainingProject((Object)this._switchYard);
        this._targetResource = PlatformResourceAdapterFactory.getFileForObject((Object)this._targetContract, (IProject)this._project);
    }

    public Collection<TransformType> getCreatedTransforms() {
        if (this._creatingTransformers) {
            return this._transformWizard.getCreatedTransforms();
        }
        return Collections.emptyList();
    }

    @Override
    protected void createAdditionalControls(Composite content, int nColumns) {
        if (nColumns > 1) {
            new Label(content, 0);
        }
        this._createTransformersCheck = new Button(content, 32);
        this._createTransformersCheck.setText(Messages.label_createRequiredTransformers);
        this._createTransformersCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, nColumns - 1, 1));
        this._createTransformersCheck.setSelection(true);
        this._createTransformersCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PromoteServiceWizardPage.this.validate();
            }
        });
        if (nColumns > 1) {
            new Label(content, 0);
        }
        this._transformWizard.addPages();
    }

    @Override
    protected void validate() {
        block6: {
            IFile newSourceResource = PlatformResourceAdapterFactory.getFileForObject((Object)this.getContract(), (IProject)this._project);
            if (newSourceResource != null && this._targetResource != null && !newSourceResource.equals((Object)this._targetResource) && newSourceResource.exists() && this._targetResource.exists()) {
                if (!newSourceResource.equals((Object)this._sourceResource)) {
                    this._sourceResource = newSourceResource;
                    try {
                        this.getWizard().getContainer().run(false, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                                try {
                                    PromoteServiceWizardPage.this._details = new TransformDetails(PromoteServiceWizardPage.this._switchYard, PromoteServiceWizardPage.this.getContract(), PromoteServiceWizardPage.this._targetContract);
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                        if (!this._details.getDeclaredTransforms().containsAll(this._details.getRequiredTransforms())) {
                            this._transformWizard.init(this._details);
                            this._createTransformersCheck.setEnabled(true);
                            break block6;
                        }
                        this._createTransformersCheck.setEnabled(false);
                    }
                    catch (Exception exception) {
                        this._createTransformersCheck.setEnabled(false);
                    }
                }
            } else {
                this._createTransformersCheck.setEnabled(false);
                this._sourceResource = newSourceResource;
            }
        }
        this._creatingTransformers = this._createTransformersCheck.isEnabled() && this._createTransformersCheck.getSelection();
        super.validate();
    }

    protected IWizard getNextWizard() {
        if (this._createTransformersCheck.isEnabled() && this._createTransformersCheck.getSelection()) {
            return this._transformWizard;
        }
        return null;
    }
}

