/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;

class FindResourceDialog
extends FilteredResourcesSelectionDialog {
    private IJavaModel _fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    public FindResourceDialog(Shell parentShell, IContainer container) {
        super(parentShell, false, container, 7);
        this.setTitle(Messages.title_findWorkspaceFile);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FindResourceFilter();
    }

    private class FindResourceFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        private FindResourceFilter() {
            super((FilteredResourcesSelectionDialog)FindResourceDialog.this);
        }

        public boolean matchItem(Object item) {
            IResource resource = (IResource)item;
            return super.matchItem(item) && this.select(resource);
        }

        private boolean isParentOnClassPath(IJavaProject javaProject, IResource resource) {
            boolean flag = false;
            while (!flag && resource.getParent() != null) {
                flag = javaProject.isOnClasspath(resource);
                if (!flag) {
                    resource = resource.getParent();
                    continue;
                }
                return flag;
            }
            return flag;
        }

        private boolean select(IResource resource) {
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null && !this.isParentOnClassPath(javaProject, resource)) {
                return false;
            }
            try {
                if (project.getNature("org.eclipse.jdt.core.javanature") != null) {
                    return FindResourceDialog.this._fJavaModel.contains(resource);
                }
            }
            catch (CoreException e) {
                e.fillInStackTrace();
            }
            return true;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            return filter instanceof FindResourceFilter;
        }
    }
}

