/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewInterfaceWizardAction;
import org.eclipse.jdt.ui.wizards.NewInterfaceWizardPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.AbstractSwitchyardComposite;
import org.switchyard.tools.ui.editor.diagram.shared.IInterfaceComposite;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class JavaInterfaceSelectionComposite
extends AbstractSwitchyardComposite
implements IInterfaceComposite {
    private Composite _panel;
    private Interface _interface = null;
    private Hyperlink _newClassLink;
    private Text _mClassText;
    private Button _browseClassBtn;

    public JavaInterfaceSelectionComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = this.getToolkit().createComposite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        this._panel.setLayout((Layout)gl);
        if (this.getRootGridData() != null) {
            this._panel.setLayoutData((Object)this.getRootGridData());
        }
        this._newClassLink = this.getToolkit().createHyperlink(this._panel, Messages.link_javaInterface, 0);
        this._newClassLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                if (JavaInterfaceSelectionComposite.this._mClassText != null && !JavaInterfaceSelectionComposite.this._mClassText.isDisposed()) {
                    String classname = JavaInterfaceSelectionComposite.this._mClassText.getText();
                    try {
                        IType foundClass = JavaInterfaceSelectionComposite.this.canFindClass(classname);
                        if (foundClass == null) {
                            String className = JavaInterfaceSelectionComposite.this.handleCreateJavaClass();
                            if (className != null) {
                                JavaInterfaceSelectionComposite.this._mClassText.setText(className);
                                JavaInterfaceSelectionComposite.this.handleModify((Control)JavaInterfaceSelectionComposite.this._mClassText);
                                JavaInterfaceSelectionComposite.this.fireChangedEvent(JavaInterfaceSelectionComposite.this._newClassLink);
                            }
                            return;
                        }
                        JavaInterfaceSelectionComposite.this.handleOpenJavaClass(foundClass);
                    }
                    catch (JavaModelException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this._mClassText = this.getToolkit().createText(this._panel, null, 2048);
        this._mClassText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!JavaInterfaceSelectionComposite.this.inUpdate()) {
                    JavaInterfaceSelectionComposite.this.handleModify((Control)JavaInterfaceSelectionComposite.this._mClassText);
                    JavaInterfaceSelectionComposite.this.fireChangedEvent(JavaInterfaceSelectionComposite.this._mClassText);
                }
            }
        });
        GridData uriGD = new GridData(768);
        this._mClassText.setLayoutData((Object)uriGD);
        this._browseClassBtn = this.getToolkit().createButton(this._panel, Messages.button_browse, 8);
        GridData btnGD = new GridData();
        this._browseClassBtn.setLayoutData((Object)btnGD);
        this._browseClassBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IType selected = JavaInterfaceSelectionComposite.this.selectType(JavaInterfaceSelectionComposite.this._panel.getShell(), null, null);
                    if (selected != null) {
                        JavaInterfaceSelectionComposite.this._mClassText.setText(selected.getFullyQualifiedName());
                        JavaInterfaceSelectionComposite.this.handleModify((Control)JavaInterfaceSelectionComposite.this._mClassText);
                        JavaInterfaceSelectionComposite.this.fireChangedEvent(JavaInterfaceSelectionComposite.this._browseClassBtn);
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaProject javaProject;
        IJavaSearchScope searchScope = null;
        if (project == null) {
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            }
        }
        if (project != null && superTypeName != null && !superTypeName.equals("java.lang.Object")) {
            javaProject = JavaCore.create((IProject)project);
            IType superType = javaProject.findType(superTypeName);
            if (superType != null) {
                searchScope = SearchEngine.createHierarchyScope((IType)superType);
            }
        } else if (project != null) {
            javaProject = JavaCore.create((IProject)project);
            searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProject.getJavaModel().getChildren());
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)4, (boolean)false);
        dialog.setTitle(Messages.title_selectEntries);
        dialog.setMessage(Messages.description_matchingItems);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }

    private IType canFindClass(String classname) throws JavaModelException {
        IJavaProject javaProject;
        IType superType;
        IProject project = null;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
            project = ((IFile)selectionToPass.getFirstElement()).getProject();
        }
        if (selectionToPass == StructuredSelection.EMPTY) {
            project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
        }
        if (project != null && classname != null && (superType = (javaProject = JavaCore.create((IProject)project)).findType(classname)) != null) {
            return superType;
        }
        return null;
    }

    private void handleOpenJavaClass(IType classToOpen) {
        if (classToOpen != null) {
            try {
                JavaUI.openInEditor((IJavaElement)classToOpen);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private String handleCreateJavaClass() throws JavaModelException {
        IType stype;
        String name;
        IProject project = null;
        IJavaProject javaProject = null;
        OpenNewInterfaceWizardAction action = new OpenNewInterfaceWizardAction();
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (modelFile != null) {
            selectionToPass = new StructuredSelection((Object)modelFile);
            project = ((IFile)selectionToPass.getFirstElement()).getProject();
        }
        String className = this._mClassText.getText().trim();
        NewInterfaceWizardPage page = new NewInterfaceWizardPage();
        IPackageFragmentRoot packRoot = null;
        if (project != null) {
            IPackageFragment[] packages;
            javaProject = JavaCore.create((IProject)project);
            if (!className.isEmpty()) {
                if (className.contains(".")) {
                    className = className.substring(className.lastIndexOf(46) + 1);
                }
                page.setTypeName(className, true);
            }
            IPackageFragment[] iPackageFragmentArray = packages = javaProject.getPackageFragments();
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment mypackage = iPackageFragmentArray[n2];
                if (mypackage.getKind() == 1) {
                    selectionToPass = new StructuredSelection((Object)mypackage);
                    packRoot = (IPackageFragmentRoot)mypackage.getParent();
                    break;
                }
                ++n2;
            }
            page.setPackageFragmentRoot(packRoot, true);
        }
        action.setSelection((IStructuredSelection)selectionToPass);
        if (javaProject != null) {
            IJavaElement[] roots = packRoot.getChildren();
            PackageFragment stashFrag = null;
            int i = 0;
            while (i < roots.length) {
                PackageFragment frag = (PackageFragment)roots[i];
                if (!frag.isDefaultPackage() && !frag.hasSubpackages()) {
                    stashFrag = frag;
                    break;
                }
                ++i;
            }
            if (stashFrag != null) {
                page.setPackageFragment(stashFrag, true);
            }
        }
        action.setConfiguredWizardPage(page);
        action.setOpenEditorOnFinish(false);
        action.run();
        IJavaElement createdElement = action.getCreatedElement();
        if (createdElement != null && createdElement instanceof IType && (name = (stype = (IType)createdElement).getFullyQualifiedName()) != null) {
            return name;
        }
        return null;
    }

    @Override
    protected void handleModify(Control control) {
        final String interfaceClassName = this._mClassText.getText().trim();
        this.validate();
        if (this._interface instanceof JavaInterface && this._mClassText != null && !this._mClassText.isDisposed() && this._mClassText.isEnabled()) {
            if (this._interface.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        ((JavaInterface)JavaInterfaceSelectionComposite.this._interface).setInterface(interfaceClassName);
                    }
                });
            } else {
                ((JavaInterface)this._interface).setInterface(interfaceClassName);
            }
        }
    }

    @Override
    protected boolean validate() {
        this.setErrorMessage(null);
        String className = this._mClassText.getText();
        if (className == null || className.trim().length() == 0) {
            this.setErrorMessage(Messages.error_noClassSpecified);
        } else if (className.trim().length() < className.length()) {
            this.setErrorMessage(Messages.error_spacesInClassName);
        }
        return this.getErrorMessage() == null;
    }

    @Override
    public Interface getInterface() {
        return this._interface;
    }

    @Override
    public void setInterface(Interface cInterface) {
        this._interface = cInterface;
        if (this._interface != null && this._interface instanceof JavaInterface) {
            JavaInterface javaIntfc = (JavaInterface)this._interface;
            this.setInUpdate(true);
            if (javaIntfc.getInterface() != null && !this._mClassText.isDisposed()) {
                this._mClassText.setText(javaIntfc.getInterface());
            } else if (javaIntfc.getInterface() == null && !this._mClassText.isDisposed()) {
                this._mClassText.setText("org.example.IServiceInterface");
            }
            this.setInUpdate(false);
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setCanEdit(boolean canEdit) {
        super.setCanEdit(canEdit);
        if (this._mClassText != null && !this._mClassText.isDisposed()) {
            this._mClassText.setEnabled(this.canEdit());
        }
        if (this._newClassLink != null && !this._newClassLink.isDisposed()) {
            this._newClassLink.setEnabled(this.canEdit());
        }
        if (this._browseClassBtn != null && !this._browseClassBtn.isDisposed()) {
            this._browseClassBtn.setEnabled(this.canEdit());
        }
    }
}

