/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.impl;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.ErrorUtils;
import org.switchyard.tools.ui.editor.impl.FileService;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCADiagramEditorInput;

public class SwitchyardSCADiagramCreator {
    private static final String TEMPFILE_EXTENSION = "switchyard";
    private IFolder _diagramFolder;
    private IFile _diagramFile;
    private URI _uri;

    public void createDiagram() throws CoreException {
        this.createDiagram(true);
    }

    public SwitchyardSCADiagramEditorInput createDiagram(boolean openEditor) throws CoreException {
        if (this._diagramFolder != null && !this._diagramFolder.exists()) {
            this._diagramFolder.create(false, true, null);
        }
        Diagram diagram = Graphiti.getPeCreateService().createDiagram("org.switchyard.tools.ui.editor.diagram", this._diagramFile.getFullPath().removeFileExtension().lastSegment(), true);
        this._uri = URI.createPlatformResourceURI((String)this._diagramFile.getFullPath().toString(), (boolean)true);
        TransactionalEditingDomain domain = FileService.createEmfFileForDiagram(this._uri, diagram);
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        SwitchyardSCADiagramEditorInput editorInput = new SwitchyardSCADiagramEditorInput(EcoreUtil.getURI((EObject)diagram), domain, providerId);
        if (openEditor) {
            this.openEditor(editorInput);
        }
        return editorInput;
    }

    private void openEditor(final DiagramEditorInput editorInput) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.switchyard.tools.ui.editor.switchyard.editor");
                }
                catch (PartInitException e) {
                    String error = Messages.error_errorOpeningDiagramEditor;
                    Status status = new Status(4, "org.switchyard.tools.ui.editor", error, (Throwable)e);
                    ErrorUtils.showErrorWithLogging((IStatus)status);
                }
            }
        });
    }

    public IFolder getDiagramFolder() {
        return this._diagramFolder;
    }

    public void setDiagramFolder(IFolder diagramFolder) {
        this._diagramFolder = diagramFolder;
    }

    public IFile getDiagramFile() {
        return this._diagramFile;
    }

    public void setDiagramFile(IFile diagramFile) {
        this._diagramFile = diagramFile;
    }

    public URI getUri() {
        return this._uri;
    }

    public static IFolder getTempFolder(IPath fullPath) throws CoreException {
        IFolder folder;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String name = fullPath.getFileExtension();
        if (name == null || name.length() == 0) {
            name = "xml";
        }
        if (!(folder = root.getProject(fullPath.segment(0)).getFolder("." + name)).exists()) {
            folder.create(true, true, null);
        }
        String[] segments = fullPath.segments();
        int i = 1;
        while (i < segments.length - 1) {
            String segment = segments[i];
            if (!(folder = folder.getFolder(segment)).exists()) {
                folder.create(true, true, null);
            }
            ++i;
        }
        return folder;
    }

    public static IFile getTempFile(IPath fullPath, IFolder folder) {
        IPath path = fullPath.removeFileExtension().addFileExtension(TEMPFILE_EXTENSION);
        IFile tempFile = folder.getFile(path.lastSegment());
        if (tempFile.exists()) {
            try {
                tempFile.delete(true, null);
            }
            catch (CoreException e) {
                Activator.showErrorWithLogging((Exception)((Object)e));
            }
        }
        return tempFile;
    }

    public static IFile getModelFile(IPath fullPath) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath).getProject();
        int matchingSegments = project.getFullPath().matchingFirstSegments(fullPath);
        int totalSegments = fullPath.segmentCount();
        String ext = fullPath.getFileExtension();
        if (totalSegments <= matchingSegments) {
            return null;
        }
        String[] segments = fullPath.segments();
        IPath path = null;
        if (TEMPFILE_EXTENSION.equals(ext)) {
            ext = fullPath.segment(matchingSegments);
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            path = project.getFullPath();
            int i = matchingSegments + 1;
            while (i < segments.length) {
                path = path.append(segments[i]);
                ++i;
            }
            path = path.removeFileExtension().addFileExtension(ext);
        } else {
            path = fullPath.makeAbsolute();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public static void dispose(IFile file) {
        try {
            IContainer container = file.getParent();
            file.delete(true, null);
            while (SwitchyardSCADiagramCreator.isEmptyFolder(container)) {
                container.delete(true, null);
                container = container.getParent();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmptyFolder(IContainer container) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IResource res = iResourceArray[n2];
                int type = res.getType();
                if (type == 1) return false;
                if (type == 4) return false;
                if (type == 8) {
                    return false;
                }
                if (!SwitchyardSCADiagramCreator.isEmptyFolder((IContainer)res)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

