/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DefaultMarkerBehavior;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DefaultRefreshBehavior;
import org.eclipse.graphiti.ui.editor.DefaultUpdateBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.editor.DomainModelWorkspaceSynchronizerDelegate;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.jboss.tools.foundation.core.jobs.BarrierProgressWaitJob;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceFactoryImpl;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceImpl;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.PropertiesDialogFeature;
import org.switchyard.tools.ui.editor.diagram.SynchronizeGeneratedModelFeature;
import org.switchyard.tools.ui.editor.impl.ErrorUtils;
import org.switchyard.tools.ui.editor.model.merge.MergedModelAdapterFactory;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.validation.ValidationProblem;
import org.switchyard.tools.ui.validation.ValidationStatusAdapter;
import org.switchyard.tools.ui.validation.ValidationStatusAdapterFactory;

public class SwitchyardSCAEditor
extends DiagramEditor
implements IGotoMarker {
    public static final String EDITOR_ID = "org.switchyard.tools.ui.editor.switchyard.editor";
    public static final String CONTRIBUTOR_ID = "org.switchyard.tools.ui.editor.diagram.PropertyContributor";
    private URI _modelUri;
    private URI _diagramUri;
    private IFile _modelFile;
    private IFile _targetModelFile;
    private IFile _diagramFile;
    private IResourceChangeListener _workspaceListener;
    private IBreakpointsListener _breakpointsListener;
    private SwitchYardProjectManager.ISwitchYardProjectListener _switchYardProjectListener;
    private boolean _needsSynchronization;
    private static SwitchyardSCAEditor activeEditor;
    private SwitchyardSCAEditorAdapter _editorAdapter;

    public static SwitchyardSCAEditor getEditor(EObject object) {
        if (object != null && object.eResource() != null) {
            return SwitchyardSCAEditor.getEditor(object.eResource().getResourceSet());
        }
        return null;
    }

    public static SwitchyardSCAEditor getActiveEditor() {
        return activeEditor;
    }

    private void setActiveEditor(SwitchyardSCAEditor editor) {
        activeEditor = editor;
    }

    public static SwitchyardSCAEditor getEditor(ResourceSet resourceSet) {
        for (Object next : resourceSet.eAdapters()) {
            if (!(next instanceof SwitchyardSCAEditorAdapter)) continue;
            return ((SwitchyardSCAEditorAdapter)next).getSwitchyardEditor();
        }
        return null;
    }

    protected SwitchyardSCAEditorAdapter getEditorAdapter() {
        return this._editorAdapter;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setActiveEditor(this);
        super.init(site, input);
    }

    protected DiagramBehavior createDiagramBehavior() {
        SwitchYardDiagramBehavior diagramBehavior = new SwitchYardDiagramBehavior((IDiagramContainerUI)this);
        diagramBehavior.setParentPart((IWorkbenchPart)this);
        diagramBehavior.initDefaultBehaviors();
        return diagramBehavior;
    }

    protected void createActions() {
        super.createActions();
        this.getActionRegistry().registerAction((IAction)new PropertiesDialogAction((IWorkbenchPart)this));
    }

    private Set<EObject> loadValidationStatus(List<IMarker> markers) {
        if (markers == null) {
            return Collections.emptySet();
        }
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
        MergedModelAdapterFactory mergeAdapter = MergedModelUtil.getAdapterFactory(this.getResourceSet());
        LinkedHashSet<EObject> touched = new LinkedHashSet<EObject>();
        for (IMarker marker : markers) {
            ValidationStatusAdapter statusAdapter;
            EObject markedObject = this.getTargetObject(marker.getAttribute("uri", null), mergeAdapter);
            if (markedObject == null || (statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)markedObject, ValidationStatusAdapter.class)) == null) continue;
            statusAdapter.addValidationStatus(this.convertMarker(marker, markedObject, mergeAdapter));
            touched.add(markedObject);
        }
        return touched;
    }

    private Set<EObject> loadBreakpointStatus(IBreakpoint[] breakpoints) {
        IProject project;
        if (breakpoints == null) {
            return Collections.emptySet();
        }
        IProject iProject = project = this._modelFile == null ? null : this._modelFile.getProject();
        if (project == null) {
            return Collections.emptySet();
        }
        MergedModelAdapterFactory mergeAdapter = MergedModelUtil.getAdapterFactory(this.getResourceSet());
        LinkedHashSet<EObject> touched = new LinkedHashSet<EObject>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                if (breakpoint != null && project.equals((Object)breakpoint.getMarker().getResource().getProject())) {
                    ValidationStatusAdapter statusAdapter;
                    EObject markedObject;
                    IMarker marker = breakpoint.getMarker();
                    String uri = marker.getAttribute("switchYardServiceBreakpoint.consumer.uri", null);
                    if (uri == null) {
                        uri = marker.getAttribute("switchYardServiceBreakpoint.provider.uri", null);
                    }
                    if (uri == null) {
                        uri = "switchyard:generated#//@switchyard/@composite";
                    }
                    if ((markedObject = this.getTargetObject(uri, mergeAdapter)) != null && (statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)markedObject, ValidationStatusAdapter.class)) != null) {
                        statusAdapter.addBreakpoint(marker.getType());
                        touched.add(markedObject);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return touched;
    }

    private EObject getTargetObject(String uriString, MergedModelAdapterFactory mergeAdapter) {
        EObject source;
        URI uri;
        URI uRI = uri = uriString == null ? null : URI.createURI((String)uriString);
        if (uri == null) {
            return null;
        }
        EObject generated = this.getEditingDomain().getResourceSet().getEObject(uri, false);
        if (generated != null && mergeAdapter != null && (source = mergeAdapter.getSource(generated)) != null) {
            return source;
        }
        return generated;
    }

    private IStatus convertMarker(IMarker marker, EObject target, MergedModelAdapterFactory mergeAdapter) {
        int severity;
        String message = marker.getAttribute("message", "");
        String constraintId = marker.getAttribute("rule", null);
        IConstraintDescriptor icd = constraintId == null ? null : ConstraintRegistry.getInstance().getDescriptor(constraintId);
        IModelConstraint imc = icd == null ? null : ConstraintFactory.getInstance().newConstraint(icd);
        switch (marker.getAttribute("severity", -1)) {
            case 0: {
                severity = 1;
                break;
            }
            case 1: {
                severity = 2;
                break;
            }
            case 2: {
                severity = 4;
                break;
            }
            default: {
                severity = 0;
            }
        }
        int code = marker.getAttribute(ValidationProblem.PROBLEM_CODE, 0);
        if (imc == null) {
            return new Status(severity, "org.switchyard.tools.ui.editor", code, message, null);
        }
        List<EObject> locus = this.getTargetObjects(this.getEditingDomain(), marker);
        ListIterator<EObject> it = locus.listIterator();
        while (it.hasNext()) {
            EObject source;
            EObject item = it.next();
            EObject eObject = source = mergeAdapter == null ? null : mergeAdapter.getSource(item);
            if (source == null) continue;
            it.set(source);
        }
        return new ConstraintStatus(imc, target, severity, code, message, (Set)(locus == null ? null : new LinkedHashSet<EObject>(locus)));
    }

    private URI convertModelURIToDiagramURI(URI modelUri) {
        IPath diagramFilePath = this._modelFile.getProject().getFullPath().append(".xml").append(this._modelFile.getFullPath().removeFirstSegments(1)).addFileExtension("diagram");
        this._diagramFile = this._modelFile.getWorkspace().getRoot().getFile(diagramFilePath);
        return URI.createPlatformResourceURI((String)diagramFilePath.toString(), (boolean)true);
    }

    private List<EObject> getTargetObjects(Object object, IMarker marker) {
        String relatedURIsAttribute;
        ArrayList<EObject> result = new ArrayList<EObject>();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        String uriAttribute = marker.getAttribute("uri", null);
        if (uriAttribute != null) {
            URI uri = URI.createURI((String)uriAttribute);
            EObject eObject = editingDomain.getResourceSet().getEObject(uri, true);
            if (eObject != null) {
                result.add(eObject);
            }
        }
        if ((relatedURIsAttribute = marker.getAttribute("relatedURIs", null)) != null) {
            String[] stringArray = relatedURIsAttribute.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String relatedURI = stringArray[n2];
                URI uri = URI.createURI((String)URI.decode((String)relatedURI));
                EObject eObject = editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    result.add(eObject);
                }
                ++n2;
            }
        }
        return result;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this) {
            this.setActiveEditor(this);
        }
        super.selectionChanged(part, selection);
    }

    public void dispose() {
        IWorkbenchPage[] pages;
        int instances = 0;
        IWorkbenchPage[] iWorkbenchPageArray = pages = this.getEditorSite().getWorkbenchWindow().getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage p = iWorkbenchPageArray[n2];
            IEditorReference[] refs = p.getEditorReferences();
            instances += refs.length;
            ++n2;
        }
        if (instances == 0) {
            this.setActiveEditor(null);
        }
        this.removeWorkspaceListener();
        this.removeSwitchYardProjectListener();
        super.dispose();
    }

    public void gotoMarker(IMarker marker) {
        EObject target = this.getTargetObject(marker.getAttribute("uri", null), MergedModelUtil.getAdapterFactory(this.getResourceSet()));
        if (target == null) {
            return;
        }
        PictogramElement pe = this.getDiagramTypeProvider().getFeatureProvider().getPictogramElementForBusinessObject((Object)target);
        if (pe == null) {
            return;
        }
        IStatus status = this.convertMarker(marker, target, MergedModelUtil.getAdapterFactory(this.getResourceSet()));
        if (pe instanceof AnchorContainer && status instanceof IConstraintStatus && ValidationProblem.isConnectionProblem((int)((IConstraintStatus)status).getCode())) {
            for (EObject other : ((IConstraintStatus)status).getResultLocus()) {
                if (other == target) continue;
                for (Anchor anchor : ((AnchorContainer)pe).getAnchors()) {
                    for (Connection connection : anchor.getOutgoingConnections()) {
                        if (this.getDiagramTypeProvider().getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)connection.getEnd()) != other) continue;
                        this.selectPictogramElements(new PictogramElement[]{connection});
                        return;
                    }
                }
            }
        }
        this.selectPictogramElements(new PictogramElement[]{pe});
    }

    public IFile getModelFile() {
        return this._modelFile;
    }

    public IFile getTargetModelFile() {
        if (this._targetModelFile == null) {
            Path targetPath = new Path("target/classes/META-INF/switchyard.xml");
            try {
                this._modelFile.getProject().refreshLocal(2, null);
                IFile target = this._modelFile.getProject().getFile((IPath)targetPath);
                if (target != null) {
                    this._targetModelFile = target;
                }
            }
            catch (CoreException e) {
                e.fillInStackTrace();
            }
        }
        return this._targetModelFile;
    }

    public boolean needToSynchronizeGeneratedModel() {
        return this._needsSynchronization;
    }

    public boolean synchronizeGeneratedModel() {
        this._needsSynchronization = false;
        ResourceSet rs = this.getResourceSet();
        MergedModelAdapterFactory mergeAdapter = MergedModelUtil.getAdapterFactory(rs);
        if (mergeAdapter == null || this._modelFile == null || this._modelFile.getProject() == null) {
            return false;
        }
        ISwitchYardProject project = SwitchYardProjectManager.instance().getSwitchYardProject(this._modelFile.getProject());
        if (project == null) {
            return false;
        }
        boolean modified = false;
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        if (mergeAdapter.processUpdatesToGenerated(project.getOutputSwitchYardConfigurationFile())) {
            diagram.eResource().setModified(true);
            modified = true;
        }
        UpdateContext context = new UpdateContext((PictogramElement)diagram);
        IUpdateFeature feature = this.getDiagramTypeProvider().getFeatureProvider().getUpdateFeature((IUpdateContext)context);
        if (feature != null && feature.canExecute((IContext)context) && feature.updateNeeded((IUpdateContext)context).toBoolean()) {
            feature.update((IUpdateContext)context);
            modified = modified || feature.hasDoneChanges();
        }
        try {
            this.loadValidationStatus(Arrays.asList(this._modelFile.findMarkers("org.switchyard.tools.ui.problemMarker", true, 0)));
            this.getDiagramBehavior().refresh();
        }
        catch (CoreException e) {
            e.fillInStackTrace();
        }
        return modified;
    }

    private void addWorkspaceListener() {
        if (this._workspaceListener == null) {
            this._workspaceListener = new IResourceChangeListener(){

                public void resourceChanged(final IResourceChangeEvent event) {
                    SwitchyardSCAEditor.this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SwitchyardSCAEditor.this.getEditingDomain() == null) {
                                return;
                            }
                            try {
                                TransactionUtil.runExclusive((TransactionalEditingDomain)SwitchyardSCAEditor.this.getEditingDomain(), (RunnableWithResult)new RunnableWithResult.Impl<Object>(){

                                    public void run() {
                                        SwitchyardSCAEditor.this.processMarkerDeltas(event.getDelta().findMember(SwitchyardSCAEditor.this._modelFile.getFullPath()));
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                e.fillInStackTrace();
                            }
                        }
                    });
                }
            };
            this._breakpointsListener = new IBreakpointsListener(){

                public void breakpointsRemoved(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
                    SwitchyardSCAEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (breakpoints == null || SwitchyardSCAEditor.this.getGraphicalControl() == null || SwitchyardSCAEditor.this.getGraphicalControl().isDisposed()) {
                                return;
                            }
                            SwitchyardSCAEditor.this.removeBreakpoints(breakpoints);
                        }
                    });
                }

                public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
                }

                public void breakpointsAdded(final IBreakpoint[] breakpoints) {
                    SwitchyardSCAEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (breakpoints == null || SwitchyardSCAEditor.this.getGraphicalControl() == null || SwitchyardSCAEditor.this.getGraphicalControl().isDisposed()) {
                                return;
                            }
                            IFeatureProvider featureProvider = SwitchyardSCAEditor.this.getDiagramTypeProvider().getFeatureProvider();
                            for (EObject eobject : SwitchyardSCAEditor.this.loadBreakpointStatus(breakpoints)) {
                                PictogramElement pe = featureProvider.getPictogramElementForBusinessObject((Object)eobject);
                                if (pe == null) continue;
                                SwitchyardSCAEditor.this.getDiagramBehavior().getRefreshBehavior().refreshRenderingDecorators(pe);
                            }
                        }
                    });
                }
            };
        }
        this._modelFile.getWorkspace().addResourceChangeListener(this._workspaceListener, 16);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener(this._breakpointsListener);
    }

    private void removeWorkspaceListener() {
        if (this._workspaceListener != null) {
            this._modelFile.getWorkspace().removeResourceChangeListener(this._workspaceListener);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener(this._breakpointsListener);
        }
    }

    private void addSwitchYardProjectListener() {
        if (this._switchYardProjectListener == null) {
            this._switchYardProjectListener = new SwitchYardProjectManager.ISwitchYardProjectListener(){

                public void projectUpdated(ISwitchYardProject project, Set<SwitchYardProjectManager.ISwitchYardProjectListener.Type> types) {
                    if (SwitchyardSCAEditor.this.getGraphicalControl() != null && SwitchyardSCAEditor.this.getGraphicalControl().isDisposed() || !types.contains(SwitchYardProjectManager.ISwitchYardProjectListener.Type.CONFIG)) {
                        return;
                    }
                    if (SwitchyardSCAEditor.this._modelFile.equals((Object)project.getSwitchYardConfigurationFile())) {
                        SwitchyardSCAEditor.this._needsSynchronization = true;
                        if (SwitchyardSCAEditor.this.isDirty() || SwitchyardSCAEditor.this.getDiagramBehavior().isDirectEditingActive()) {
                            return;
                        }
                        SwitchyardSCAEditor.this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SwitchyardSCAEditor.this.getDiagramBehavior().executeFeature((IFeature)new SynchronizeGeneratedModelFeature(SwitchyardSCAEditor.this.getDiagramTypeProvider().getFeatureProvider(), true), (IContext)new CustomContext());
                            }
                        });
                    }
                }
            };
            SwitchYardProjectManager.instance().addListener(this._switchYardProjectListener);
        }
    }

    private void removeSwitchYardProjectListener() {
        if (this._switchYardProjectListener != null) {
            SwitchYardProjectManager.instance().removeListener(this._switchYardProjectListener);
            this._switchYardProjectListener = null;
        }
    }

    private void processMarkerDeltas(IResourceDelta modelFileDelta) {
        ValidationStatusAdapter adapter;
        if (modelFileDelta == null || this.getGraphicalControl() == null || this.getGraphicalControl().isDisposed()) {
            return;
        }
        IMarkerDelta[] markerDeltas = modelFileDelta.getMarkerDeltas();
        if (markerDeltas == null || markerDeltas.length == 0) {
            return;
        }
        ArrayList<IMarker> newMarkers = new ArrayList<IMarker>();
        HashSet<IMarker> deletedMarkers = new HashSet<IMarker>();
        boolean hasRemoved = false;
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            switch (markerDelta.getKind()) {
                case 1: {
                    newMarkers.add(markerDelta.getMarker());
                    break;
                }
                case 4: {
                    newMarkers.add(markerDelta.getMarker());
                    deletedMarkers.add(markerDelta.getMarker());
                    break;
                }
                case 2: {
                    hasRemoved = true;
                }
            }
            ++n2;
        }
        LinkedHashSet<EObject> updatedObjects = new LinkedHashSet<EObject>();
        MergedModelAdapterFactory mergeAdapter = MergedModelUtil.getAdapterFactory(this.getEditingDomain().getResourceSet());
        if (hasRemoved) {
            for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
                if (!"switchyard".equals(resource.getURI().scheme())) continue;
                TreeIterator it = resource.getAllContents();
                while (it.hasNext()) {
                    EObject touched;
                    EObject source;
                    EObject generated = (EObject)it.next();
                    EObject eObject = source = mergeAdapter == null ? null : mergeAdapter.getSource(generated);
                    if (source == null) {
                        adapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)generated, ValidationStatusAdapter.class);
                        touched = generated;
                    } else {
                        adapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)source, ValidationStatusAdapter.class);
                        touched = source;
                    }
                    if (adapter == null) continue;
                    adapter.clearValidationStatus();
                    updatedObjects.add(touched);
                }
            }
        } else {
            for (IMarker marker : deletedMarkers) {
                EObject eobject = this.getTargetObject(marker.getAttribute("uri", null), mergeAdapter);
                if (eobject == null || (adapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)eobject, ValidationStatusAdapter.class)) == null) continue;
                adapter.clearValidationStatus();
                updatedObjects.add(eobject);
            }
        }
        updatedObjects.addAll(this.loadValidationStatus(newMarkers));
        IFeatureProvider featureProvider = this.getDiagramTypeProvider().getFeatureProvider();
        for (EObject eobject : updatedObjects) {
            PictogramElement pe = featureProvider.getPictogramElementForBusinessObject((Object)eobject);
            if (pe == null) continue;
            this.getDiagramBehavior().getRefreshBehavior().refreshRenderingDecorators(pe);
        }
    }

    private void removeBreakpoints(IBreakpoint[] breakpoints) {
        if (breakpoints == null || this.getGraphicalControl().isDisposed()) {
            return;
        }
        LinkedHashSet<EObject> updatedObjects = new LinkedHashSet<EObject>();
        MergedModelAdapterFactory mergeAdapter = MergedModelUtil.getAdapterFactory(this.getEditingDomain().getResourceSet());
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IInteractionConfiguration config;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof DelegatingJavaBreakpoint && (config = ((DelegatingJavaBreakpoint)breakpoint).getInteractionConfiguration()) != null) {
                ValidationStatusAdapter adapter;
                EObject eobject;
                String uri = config.getConsumerUri();
                if (uri == null) {
                    uri = config.getProviderUri();
                }
                if (uri == null) {
                    uri = "switchyard:generated#//@switchyard/@composite";
                }
                if ((eobject = this.getTargetObject(uri, mergeAdapter)) != null && (adapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)eobject, ValidationStatusAdapter.class)) != null) {
                    adapter.removeBreakpoint(((DelegatingJavaBreakpoint)breakpoint).getMarkerId());
                    updatedObjects.add(eobject);
                }
            }
            ++n2;
        }
        IFeatureProvider featureProvider = this.getDiagramTypeProvider().getFeatureProvider();
        for (EObject eobject : updatedObjects) {
            PictogramElement pe = featureProvider.getPictogramElementForBusinessObject((Object)eobject);
            if (pe == null) continue;
            this.getDiagramBehavior().getRefreshBehavior().refreshRenderingDecorators(pe);
        }
    }

    private ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }

    protected void resourceMoved(IFile modelFile) {
    }

    private class PropertiesDialogAction
    extends SelectionAction {
        public PropertiesDialogAction(IWorkbenchPart part) {
            super(part);
            this.setId(ActionFactory.PROPERTIES.getId());
            this.setActionDefinitionId(ActionFactory.PROPERTIES.getCommandId());
            this.setText(WorkbenchMessages.Workbench_properties);
        }

        protected boolean calculateEnabled() {
            PropertiesDialogFeature feature = new PropertiesDialogFeature(SwitchyardSCAEditor.this.getDiagramTypeProvider().getFeatureProvider());
            CustomContext context = new CustomContext(SwitchyardSCAEditor.this.getSelectedPictogramElements());
            return feature.canExecute((ICustomContext)context);
        }

        public void run() {
            PropertiesDialogFeature feature = new PropertiesDialogFeature(SwitchyardSCAEditor.this.getDiagramTypeProvider().getFeatureProvider());
            CustomContext context = new CustomContext(SwitchyardSCAEditor.this.getSelectedPictogramElements());
            SwitchyardSCAEditor.this.getDiagramBehavior().executeFeature((IFeature)feature, (IContext)context);
        }
    }

    private static final class RuleTransferDelegatingRunnable
    implements IRunnableWithProgress,
    IThreadListener {
        private final IRunnableWithProgress _delegate;

        private RuleTransferDelegatingRunnable(IRunnableWithProgress delegate) {
            this._delegate = delegate;
        }

        public void threadChange(Thread thread) {
            ISchedulingRule rule = Job.getJobManager().currentRule();
            if (rule != null) {
                Job.getJobManager().transferRule(rule, thread);
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this._delegate.run(monitor);
        }
    }

    private final class SwitchYardDiagramBehavior
    extends DiagramBehavior {
        public SwitchYardDiagramBehavior(IDiagramContainerUI diagramContainer) {
            super(diagramContainer);
        }

        protected boolean isDirty() {
            return this.getPersistencyBehavior().isDirty();
        }

        protected void initDefaultBehaviors() {
            super.initDefaultBehaviors();
        }

        protected void setParentPart(IWorkbenchPart parentPart) {
            super.setParentPart(parentPart);
        }

        protected DefaultPersistencyBehavior createPersistencyBehavior() {
            return new SwitchYardPersistencyBehavior(this);
        }

        protected DefaultMarkerBehavior createMarkerBehavior() {
            return new DefaultMarkerBehavior(this){

                public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
                    return Diagnostic.OK_INSTANCE;
                }
            };
        }

        protected DefaultRefreshBehavior createRefreshBehavior() {
            return new DefaultRefreshBehavior(this){

                public void refreshRenderingDecorators(PictogramElement pe) {
                    super.refreshRenderingDecorators(pe);
                    if (pe instanceof AnchorContainer) {
                        for (Anchor anchor : ((AnchorContainer)pe).getAnchors()) {
                            for (Connection connection : anchor.getOutgoingConnections()) {
                                for (ConnectionDecorator decorator : connection.getConnectionDecorators()) {
                                    super.refreshRenderingDecorators((PictogramElement)decorator);
                                }
                            }
                        }
                    }
                }

                protected void autoUpdate() {
                    super.autoUpdate();
                    this.diagramBehavior.getEditingDomain().getCommandStack().flush();
                    this.diagramBehavior.getDiagramContainer().updateDirtyState();
                }
            };
        }

        protected DefaultUpdateBehavior createUpdateBehavior() {
            return new SwitchYardUpdateBehavior(this);
        }

        protected PictogramElement[] getPictogramElementsForSelection() {
            ArrayList<PictogramElement> visibleList = new ArrayList<PictogramElement>();
            PictogramElement[] pictogramElements = super.getPictogramElementsForSelection();
            if (pictogramElements == null) {
                return null;
            }
            PictogramElement[] pictogramElementArray = pictogramElements;
            int n = pictogramElements.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                if (pe.isVisible()) {
                    visibleList.add(pe);
                }
                ++n2;
            }
            return visibleList.toArray(new PictogramElement[visibleList.size()]);
        }
    }

    private final class SwitchYardPersistencyBehavior
    extends DefaultPersistencyBehavior {
        private MergedModelAdapterFactory _mergedModelAdapterFactory;

        private SwitchYardPersistencyBehavior(DiagramBehavior editor) {
            super(editor);
        }

        protected IRunnableWithProgress createOperation(Set<Resource> savedResources, Map<Resource, Map<?, ?>> saveOptions) {
            return new RuleTransferDelegatingRunnable(super.createOperation(savedResources, saveOptions));
        }

        public Diagram loadDiagram(URI modelUri) {
            if (modelUri == null) {
                return null;
            }
            SwitchyardSCAEditor.this._modelUri = modelUri;
            final SwitchyardResourceImpl switchYardResource = (SwitchyardResourceImpl)SwitchyardSCAEditor.this.getEditingDomain().getResourceSet().createResource(modelUri.trimFragment(), "org.switchyard.content-type.1.x");
            SwitchyardSCAEditor.this._modelFile = WorkspaceSynchronizer.getFile((Resource)switchYardResource);
            if (SwitchyardSCAEditor.this._modelFile == null || !SwitchyardSCAEditor.this._modelFile.exists()) {
                return null;
            }
            Resource r = this.loadGeneratedResource(SwitchyardSCAEditor.this._modelFile);
            if (r == null) {
                ErrorUtils.showErrorWithLogging((IStatus)new Status(4, "org.switchyard.tools.ui.editor", MessageFormat.format(Messages.error_errorLoadingFile, SwitchyardSCAEditor.this._modelFile.getName(), "Unable to load generated resource"), null));
                return null;
            }
            switchYardResource.setGeneratedResource(r);
            try {
                switchYardResource.load(SwitchyardSCAEditor.this.getEditingDomain().getResourceSet().getLoadOptions());
            }
            catch (IOException e) {
                ErrorUtils.showErrorWithLogging((IStatus)new Status(4, "org.switchyard.tools.ui.editor", MessageFormat.format(Messages.error_errorLoadingFile, SwitchyardSCAEditor.this._modelFile.getName(), e.getLocalizedMessage()), (Throwable)e));
            }
            if (this._mergedModelAdapterFactory != null) {
                SwitchyardSCAEditor.this.getEditingDomain().getResourceSet().getAdapterFactories().remove((Object)this._mergedModelAdapterFactory);
            }
            this._mergedModelAdapterFactory = new MergedModelAdapterFactory(switchYardResource);
            SwitchyardSCAEditor.this.getEditingDomain().getResourceSet().getAdapterFactories().add((Object)this._mergedModelAdapterFactory);
            try {
                SwitchyardSCAEditor.this.loadValidationStatus(Arrays.asList(SwitchyardSCAEditor.this._modelFile.findMarkers("org.switchyard.tools.ui.problemMarker", true, 0)));
                ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>();
                IMarker[] iMarkerArray = SwitchyardSCAEditor.this._modelFile.getProject().findMarkers("org.switchyard.tools.ui.debug.switchYardBreakpointMarker", true, 0);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    IBreakpoint breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
                    if (marker != null) {
                        breakpoints.add(breakpoint);
                    }
                    ++n2;
                }
                SwitchyardSCAEditor.this.loadBreakpointStatus(breakpoints.toArray(new IBreakpoint[breakpoints.size()]));
            }
            catch (CoreException e) {
                Activator.logStatus(e.getStatus());
            }
            SwitchyardSCAEditor.this._diagramUri = SwitchyardSCAEditor.this.convertModelURIToDiagramURI(modelUri);
            final Resource diagramResource = SwitchyardSCAEditor.this.getEditingDomain().getResourceSet().createResource(SwitchyardSCAEditor.this._diagramUri, "org.eclipse.graphiti.content.diagram");
            Diagram diagram = super.loadDiagram(GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(SwitchyardSCAEditor.this._diagramUri));
            if (diagram == null) {
                diagram = Graphiti.getPeCreateService().createDiagram("org.switchyard.tools.ui.editor.diagram", SwitchyardSCAEditor.this._modelFile.getName(), true);
                PictogramLink link = PictogramsFactory.eINSTANCE.createPictogramLink();
                link.setPictogramElement((PictogramElement)diagram);
                link.getBusinessObjects().addAll((Collection)switchYardResource.getContents());
                diagram.getPictogramLinks().add((Object)link);
                final Diagram newDiagram = diagram;
                SwitchyardSCAEditor.this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(SwitchyardSCAEditor.this.getEditingDomain()){

                    public String getLabel() {
                        return Messages.label_createDiagram;
                    }

                    protected void doExecute() {
                        switchYardResource.setTrackingModification(true);
                        diagramResource.getContents().add((Object)newDiagram);
                    }
                });
            } else {
                final Diagram finalDiagram = diagram;
                SwitchyardSCAEditor.this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(SwitchyardSCAEditor.this.getEditingDomain()){

                    public String getLabel() {
                        return Messages.label_removeDanglingReferences;
                    }

                    protected void doExecute() {
                        switchYardResource.setTrackingModification(true);
                        for (PictogramLink link : finalDiagram.getPictogramLinks()) {
                            for (EObject object : new ArrayList(link.getBusinessObjects())) {
                                if (object.eContainer() != null || object.eResource() != null) continue;
                                link.getBusinessObjects().remove((Object)object);
                            }
                        }
                        PictogramLink diagramLink = finalDiagram.getLink();
                        if (diagramLink == null) {
                            diagramLink = PictogramsFactory.eINSTANCE.createPictogramLink();
                            diagramLink.setPictogramElement((PictogramElement)finalDiagram);
                            finalDiagram.getPictogramLinks().add((Object)diagramLink);
                        }
                        diagramLink.getBusinessObjects().addAll((Collection)switchYardResource.getContents());
                    }
                });
            }
            SwitchyardSCAEditor.this.getEditingDomain().getCommandStack().flush();
            SwitchyardSCAEditor.this.addWorkspaceListener();
            return diagram;
        }

        private Resource loadGeneratedResource(IFile sourceFile) {
            IFile generatedFile;
            final ISwitchYardProject switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(sourceFile.getProject());
            if (switchYardProject.needsLoading()) {
                if (!Workbench.getInstance().getActiveWorkbenchWindow().getShell().isVisible()) {
                    switchYardProject.load((IProgressMonitor)new NullProgressMonitor());
                } else {
                    try {
                        IRunnableWithProgress op = new IRunnableWithProgress(){

                            public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
                                try {
                                    SwitchYardPersistencyBehavior.this.loadSwitchYardProject(switchYardProject, mon);
                                }
                                catch (CoreException ce) {
                                    throw new InvocationTargetException(ce);
                                }
                            }
                        };
                        new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, op);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return null;
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
            }
            if ((generatedFile = switchYardProject.getOutputSwitchYardConfigurationFile()) == null) {
                return null;
            }
            Resource generatedResource = SwitchyardSCAEditor.this.getEditingDomain().getResourceSet().createResource(URI.createPlatformResourceURI((String)generatedFile.getFullPath().toString(), (boolean)true), "org.switchyard.content-type.1.x");
            try {
                generatedResource.load(null);
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
            generatedResource.setURI(URI.createGenericURI((String)"switchyard", (String)"generated", null));
            generatedResource.setTrackingModification(true);
            if (SwitchyardSCAEditor.this.getEditingDomain() instanceof AdapterFactoryEditingDomain) {
                ((AdapterFactoryEditingDomain)SwitchyardSCAEditor.this.getEditingDomain()).getResourceToReadOnlyMap().put(generatedResource, true);
            }
            SwitchyardSCAEditor.this.addSwitchYardProjectListener();
            return generatedResource;
        }

        private void loadSwitchYardProject(final ISwitchYardProject project, IProgressMonitor monitor) throws CoreException {
            BarrierProgressWaitJob.IRunnableWithProgress barrierRunnable = new BarrierProgressWaitJob.IRunnableWithProgress(){

                public Object run(IProgressMonitor monitor) throws Exception {
                    project.load(monitor);
                    return Boolean.TRUE;
                }
            };
            BarrierProgressWaitJob j = new BarrierProgressWaitJob("Load SwitchYard Project", barrierRunnable);
            j.schedule();
            j.monitorSafeJoin(monitor);
            if (monitor.isCanceled()) {
                j.getThread().interrupt();
                throw new CoreException((IStatus)new Status(8, "org.switchyard.tools.ui.editor", "User canceled operation", j.getThrowable()));
            }
            if (j.getThrowable() != null) {
                if (j.getThrowable() instanceof CoreException) {
                    throw (CoreException)j.getThrowable();
                }
                throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", "Unable to load SwitchYard Project", j.getThrowable()));
            }
        }

        protected Set<Resource> save(TransactionalEditingDomain editingDomain, Map<Resource, Map<?, ?>> saveOptions, IProgressMonitor monitor) {
            for (Resource resource : saveOptions.keySet()) {
                if (!"switchyard".equals(resource.getURI().scheme())) continue;
                resource.eSetDeliver(false);
                resource.setModified(false);
                resource.eSetDeliver(true);
                break;
            }
            return super.save(editingDomain, saveOptions, monitor);
        }
    }

    private final class SwitchYardUpdateBehavior
    extends DefaultUpdateBehavior {
        private final ResourceSetListener _listener;

        private SwitchYardUpdateBehavior(DiagramBehavior diagramEditor) {
            super(diagramEditor);
            this._listener = new ResourceSetListenerImpl(){

                public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                    if (event.getNotifications() == null) {
                        return null;
                    }
                    EMap objectChanges = event.getTransaction().getChangeDescription().getObjectChanges();
                    for (Notification notification : event.getNotifications()) {
                        EObject notifier;
                        if (!(notification.getNotifier() instanceof EObject) || (notifier = (EObject)notification.getNotifier()).eResource() == null || !event.getEditingDomain().isReadOnly(notifier.eResource())) continue;
                        for (Map.Entry change : objectChanges) {
                            if (change.getKey() != notifier) continue;
                            throw new RollbackException((IStatus)new Status(8, "org.switchyard.tools.ui.editor", Messages.error_cannotModifyGeneratedConfiguration));
                        }
                    }
                    return null;
                }

                public boolean isPrecommitOnly() {
                    return true;
                }
            };
        }

        protected WorkspaceSynchronizer.Delegate createWorkspaceSynchronizerDelegate() {
            return new DomainModelWorkspaceSynchronizerDelegate(this.diagramBehavior){

                public boolean handleResourceMoved(Resource resource, URI newURI) {
                    IDiagramEditorInput editorInput = SwitchYardUpdateBehavior.this.diagramBehavior.getDiagramContainer().getDiagramEditorInput();
                    if (!resource.getURI().equals(editorInput.getUri().trimFragment())) {
                        resource.setURI(newURI);
                        return true;
                    }
                    resource.setURI(newURI);
                    SwitchyardSCAEditor.this._modelUri = newURI;
                    SwitchyardSCAEditor.this._modelFile = WorkspaceSynchronizer.getFile((Resource)resource);
                    SwitchyardSCAEditor.this.resourceMoved(SwitchyardSCAEditor.this._modelFile);
                    SwitchyardSCAEditor.this._diagramUri = SwitchyardSCAEditor.this.convertModelURIToDiagramURI(newURI);
                    super.handleResourceMoved(resource, newURI);
                    return true;
                }
            };
        }

        protected void initializeEditingDomain(TransactionalEditingDomain domain) {
            ResourceSet resourceSet = domain.getResourceSet();
            resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.switchyard.content-type.1.x", new SwitchyardResourceFactoryImpl());
            resourceSet.getAdapterFactories().add((Object)new ValidationStatusAdapterFactory());
            SwitchyardSCAEditor.this._editorAdapter = new SwitchyardSCAEditorAdapter();
            resourceSet.eAdapters().add((Object)SwitchyardSCAEditor.this._editorAdapter);
            if (domain instanceof AdapterFactoryEditingDomain && ((AdapterFactoryEditingDomain)domain).getResourceToReadOnlyMap() == null) {
                ((AdapterFactoryEditingDomain)domain).setResourceToReadOnlyMap(new HashMap());
            }
            domain.addResourceSetListener(this._listener);
            super.initializeEditingDomain(domain);
        }

        public void dispose() {
            this.getEditingDomain().getResourceSet().eAdapters().remove((Object)SwitchyardSCAEditor.this._editorAdapter);
            this.getEditingDomain().removeResourceSetListener(this._listener);
            super.dispose();
        }

        public TransactionalEditingDomain getEditingDomain() {
            if (super.getEditingDomain() == null) {
                this.createEditingDomain(SwitchyardSCAEditor.this.getDiagramEditorInput());
                this.initializeEditingDomain(this.getEditingDomain());
            }
            return super.getEditingDomain();
        }

        protected boolean isAdapterActive() {
            return false;
        }
    }

    public final class SwitchyardSCAEditorAdapter
    implements Adapter {
        private SwitchyardSCAEditorAdapter() {
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return type == SwitchyardSCAEditorAdapter.class;
        }

        public void notifyChanged(Notification notification) {
        }

        public SwitchyardSCAEditor getSwitchyardEditor() {
            return SwitchyardSCAEditor.this;
        }

        public IFile getModelFile() {
            return SwitchyardSCAEditor.this._modelFile;
        }
    }
}

