/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.impl.security;

import java.text.MessageFormat;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.PropertiesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.PropertyType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SecuritiesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SecurityType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.DomainPropertyInputDialog;
import org.switchyard.tools.ui.editor.diagram.shared.DomainPropertyTable;
import org.switchyard.tools.ui.editor.impl.DomainPropertyTextValueChangeListener;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.util.FormToolkitUtil;

public class NewSecurityTypeWizardPage
extends WizardPage {
    private SecurityType _securityType;
    private SecuritiesType _securitiesType;
    private DomainPropertyTable _securityProperties;
    private Text _callbackHandlerText;
    private String _callbackHandler;
    private Button _callbackHandlerBrowseBtn;
    private Text _moduleNameText;
    private String _moduleName;
    private Text _rolesAllowedText;
    private String _rolesAllowed;
    private Text _securityDomainText;
    private String _securityDomain;
    private Text _runAsText;
    private String _runAs;
    private boolean _editing = false;
    private String _oldModuleName;
    private ModuleNameTextValueChangeListener _moduleNameListener;
    private ISWTObservableValue _moduleNameFocusObserver;
    private RolesAllowedTextValueChangeListener _rolesAllowedListener;
    private ISWTObservableValue _rolesAllowedFocusObserver;
    private RunAsTextValueChangeListener _runAsListener;
    private ISWTObservableValue _runAsFocusObserver;
    private SecurityDomainTextValueChangeListener _securityDomainListener;
    private ISWTObservableValue _securityDomainFocusObserver;
    private FormToolkit _toolkit;

    protected NewSecurityTypeWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        if (this._toolkit == null) {
            this._toolkit = FormToolkitUtil.getFormToolkit();
        }
        Composite client3 = this._toolkit.createComposite(parent, 64);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginWidth = 2;
        layout3.marginHeight = 2;
        client3.setLayout((Layout)layout3);
        this._toolkit.createLabel(client3, Messages.label_nameOptional);
        this._moduleNameText = this._toolkit.createText(client3, "");
        this._moduleNameText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._toolkit.createLabel(client3, Messages.label_rolesAllowed);
        this._rolesAllowedText = this._toolkit.createText(client3, "");
        this._rolesAllowedText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._toolkit.createLabel(client3, Messages.label_runAs);
        this._runAsText = this._toolkit.createText(client3, "");
        this._runAsText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._toolkit.createLabel(client3, Messages.label_securityDomain);
        this._securityDomainText = this._toolkit.createText(client3, "");
        this._securityDomainText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._toolkit.createLabel(client3, Messages.label_callbackHandlerClass);
        this._callbackHandlerText = this._toolkit.createText(client3, "", 8);
        this._callbackHandlerText.setLayoutData((Object)new GridData(4, 1, true, false));
        this._callbackHandlerBrowseBtn = this._toolkit.createButton(client3, Messages.button_browse, 8);
        this._callbackHandlerBrowseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewSecurityTypeWizardPage.this.handleBrowse();
                NewSecurityTypeWizardPage.this.setPageComplete(NewSecurityTypeWizardPage.this.validate());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label separator = this._toolkit.createLabel(client3, null, 256);
        separator.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this._securityProperties = new DomainPropertyTable(client3, 0){

            @Override
            protected void removeFromList() {
                PropertyType toRemove = NewSecurityTypeWizardPage.this._securityProperties.getTableSelection();
                if (toRemove != null) {
                    NewSecurityTypeWizardPage.this.removeSecurityProperty(toRemove);
                }
            }

            @Override
            protected void addPropertyTypeToList() {
                DomainPropertyInputDialog dialog = new DomainPropertyInputDialog(Display.getCurrent().getActiveShell());
                int rtn_value = dialog.open();
                if (rtn_value == 0) {
                    String name = dialog.getPropertyName();
                    String value = dialog.getPropertyValue();
                    NewSecurityTypeWizardPage.this.addSecurityProperty(name, value);
                }
            }
        };
        this._securityProperties.setLayoutData(new GridData(4, 1, true, false, 3, 5));
        if (this._securityType != null) {
            this._securityProperties.setTargetObject((EObject)this._securityType);
            if (this._securityType.getProperties() != null) {
                this._securityProperties.setSelection((EList<PropertyType>)this._securityType.getProperties().getProperty());
            }
            if (this._securityType.getName() != null) {
                this._moduleNameText.setText(this._securityType.getName());
                this._oldModuleName = this._moduleName = this._securityType.getName();
            } else {
                this._moduleNameText.setText("default");
                this._moduleName = null;
                this._oldModuleName = null;
            }
            if (this._securityType.getCallbackHandler() != null) {
                this._callbackHandlerText.setText(this._securityType.getCallbackHandler());
                this._callbackHandler = this._securityType.getCallbackHandler();
            }
            if (this._securityType.getRolesAllowed() != null) {
                this._rolesAllowedText.setText(this._securityType.getRolesAllowed());
                this._rolesAllowed = this._securityType.getRolesAllowed();
            }
            if (this._securityType.getRunAs() != null) {
                this._runAsText.setText(this._securityType.getRunAs());
                this._runAs = this._securityType.getRunAs();
            }
            if (this._securityType.getSecurityDomain() != null) {
                this._securityDomainText.setText(this._securityType.getSecurityDomain());
                this._securityDomain = this._securityType.getSecurityDomain();
            }
        }
        this.addObservableListeners();
        this.setControl((Control)client3);
        this.setPageComplete(this.validate());
    }

    private void handleBrowse() {
        IJavaSearchScope scope = null;
        IProject project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            scope = SearchEngine.createWorkspaceScope();
        } else {
            try {
                IType superType = javaProject.findType("javax.security.auth.callback.CallbackHandler");
                scope = superType != null ? SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)false, null) : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getCurrent().getActiveShell(), null, (IJavaSearchScope)scope, (int)512, (boolean)false);
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                IType clazz = (IType)result[0];
                String className = clazz.getFullyQualifiedName();
                this._callbackHandlerText.setText(className);
                this._callbackHandler = className;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void addSecurityProperty(final String name, final String value) {
        TransactionalEditingDomainImpl editDomain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
        if (this._securityType != null) {
            final SecurityType finalSecurity = this._securityType;
            editDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)editDomain){

                protected void doExecute() {
                    PropertiesType properties = finalSecurity.getProperties();
                    if (properties == null) {
                        properties = SwitchyardFactory.eINSTANCE.createPropertiesType();
                        finalSecurity.setProperties(properties);
                    }
                    EList propertyList = properties.getProperty();
                    PropertyType newProperty = SwitchyardFactory.eINSTANCE.createPropertyType();
                    newProperty.setName(name);
                    newProperty.setValue(value);
                    propertyList.add((Object)newProperty);
                    NewSecurityTypeWizardPage.this._securityProperties.setSelection((EList<PropertyType>)NewSecurityTypeWizardPage.this._securityType.getProperties().getProperty());
                }
            });
        }
    }

    private void removeSecurityProperty(final PropertyType property) {
        TransactionalEditingDomainImpl editDomain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
        if (this._securityType != null) {
            final SecurityType finalSecurity = this._securityType;
            editDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)editDomain){

                protected void doExecute() {
                    PropertiesType properties = finalSecurity.getProperties();
                    properties.getProperty().remove((Object)property);
                }
            });
        }
    }

    private void addObservableListeners() {
        if (this._moduleNameListener == null) {
            this._moduleNameListener = new ModuleNameTextValueChangeListener();
        }
        this.updateListener(this._moduleNameListener, this._moduleNameFocusObserver, this._moduleNameText);
        if (this._rolesAllowedListener == null) {
            this._rolesAllowedListener = new RolesAllowedTextValueChangeListener();
        }
        this.updateListener(this._rolesAllowedListener, this._rolesAllowedFocusObserver, this._rolesAllowedText);
        if (this._runAsListener == null) {
            this._runAsListener = new RunAsTextValueChangeListener();
        }
        this.updateListener(this._runAsListener, this._runAsFocusObserver, this._runAsText);
        if (this._securityDomainListener == null) {
            this._securityDomainListener = new SecurityDomainTextValueChangeListener();
        }
        this.updateListener(this._securityDomainListener, this._securityDomainFocusObserver, this._securityDomainText);
    }

    private void removeObservableListeners() {
        this.removeListener(this._moduleNameListener, this._moduleNameFocusObserver);
        this.removeListener(this._rolesAllowedListener, this._rolesAllowedFocusObserver);
        this.removeListener(this._runAsListener, this._runAsFocusObserver);
        this.removeListener(this._securityDomainListener, this._securityDomainFocusObserver);
    }

    private void updateListener(DomainPropertyTextValueChangeListener listener, ISWTObservableValue focus, Text control) {
        if (listener != null && focus != null) {
            focus.removeValueChangeListener((IValueChangeListener)listener);
        }
        if (focus == null) {
            focus = SWTObservables.observeText((Control)control, (int)16);
        }
        focus.addValueChangeListener((IValueChangeListener)listener);
    }

    private void removeListener(DomainPropertyTextValueChangeListener listener, ISWTObservableValue focus) {
        if (listener != null && focus != null) {
            focus.removeValueChangeListener((IValueChangeListener)listener);
            focus.dispose();
            listener = null;
        }
    }

    public void dispose() {
        if (this._toolkit != null) {
            this._toolkit.dispose();
            this._toolkit = null;
        }
        this.removeObservableListeners();
        super.dispose();
    }

    public void setSecurityType(SecurityType security) {
        this._securityType = security;
    }

    public SecurityType getSecurityType() {
        return this._securityType;
    }

    protected String getCallbackHandler() {
        return this._callbackHandler;
    }

    protected String getModuleName() {
        return this._moduleName;
    }

    protected String getRolesAllowed() {
        return this._rolesAllowed;
    }

    protected String getRunAs() {
        return this._runAs;
    }

    protected String getSecurityDomain() {
        return this._securityDomain;
    }

    public void setSecuritiesType(SecuritiesType securities) {
        this._securitiesType = securities;
    }

    public SecuritiesType getSecuritiesType() {
        return this._securitiesType;
    }

    private boolean validate() {
        this.setErrorMessage(null);
        if (this.getSecuritiesType() != null) {
            for (SecurityType securityType : this.getSecuritiesType().getSecurity()) {
                boolean fieldNameIsOldName;
                String name = securityType.getName();
                boolean nameIsNull = name == null;
                boolean fieldNameIsNull = this._moduleName == null;
                boolean fieldNameIsEmpty = fieldNameIsNull || this._moduleName.trim().isEmpty();
                boolean fieldNameIsDefault = fieldNameIsNull || this._moduleName.equals("default");
                boolean fieldNameIsSTName = nameIsNull && fieldNameIsNull || !nameIsNull && !fieldNameIsNull && this._moduleName.equals(name);
                boolean oldNameIsNull = this._oldModuleName == null;
                boolean bl = fieldNameIsOldName = oldNameIsNull && fieldNameIsNull || !oldNameIsNull && !fieldNameIsNull && this._moduleName.equals(this._oldModuleName);
                if (nameIsNull && (fieldNameIsNull || fieldNameIsEmpty || fieldNameIsDefault) && !this._editing) {
                    this.setErrorMessage(Messages.error_moreThanOneDefaultSecurityConfiguration);
                    return false;
                }
                if (nameIsNull && (fieldNameIsNull || fieldNameIsEmpty || fieldNameIsDefault) && this._editing && !fieldNameIsOldName) {
                    this.setErrorMessage(Messages.error_moreThanOneDefaultSecurityConfiguration);
                    return false;
                }
                if (!nameIsNull && fieldNameIsSTName && !this._editing) {
                    this.setErrorMessage(MessageFormat.format(Messages.error_duplicateSecurityConfigurationName, this._moduleName));
                    return false;
                }
                if (nameIsNull || !fieldNameIsSTName || !this._editing || fieldNameIsOldName) continue;
                this.setErrorMessage(MessageFormat.format(Messages.error_duplicateSecurityConfigurationName, this._moduleName));
                return false;
            }
        }
        return true;
    }

    public void setEditing(boolean editing) {
        this._editing = editing;
    }

    class ModuleNameTextValueChangeListener
    extends DomainPropertyTextValueChangeListener {
        ModuleNameTextValueChangeListener() {
        }

        @Override
        protected void updateField(Text control) {
            String value = control.getText();
            if (value.trim().isEmpty()) {
                value = null;
            }
            NewSecurityTypeWizardPage.this._moduleName = value;
            NewSecurityTypeWizardPage.this.setPageComplete(NewSecurityTypeWizardPage.this.validate());
        }
    }

    class RolesAllowedTextValueChangeListener
    extends DomainPropertyTextValueChangeListener {
        RolesAllowedTextValueChangeListener() {
        }

        @Override
        protected void updateField(Text control) {
            String value = control.getText();
            if (value.trim().isEmpty()) {
                value = null;
            }
            NewSecurityTypeWizardPage.this._rolesAllowed = value;
            NewSecurityTypeWizardPage.this.setPageComplete(NewSecurityTypeWizardPage.this.validate());
        }
    }

    class RunAsTextValueChangeListener
    extends DomainPropertyTextValueChangeListener {
        RunAsTextValueChangeListener() {
        }

        @Override
        protected void updateField(Text control) {
            String value = control.getText();
            if (value.trim().isEmpty()) {
                value = null;
            }
            NewSecurityTypeWizardPage.this._runAs = value;
            NewSecurityTypeWizardPage.this.setPageComplete(NewSecurityTypeWizardPage.this.validate());
        }
    }

    class SecurityDomainTextValueChangeListener
    extends DomainPropertyTextValueChangeListener {
        SecurityDomainTextValueChangeListener() {
        }

        @Override
        protected void updateField(Text control) {
            String value = control.getText();
            if (value.trim().isEmpty()) {
                value = null;
            }
            NewSecurityTypeWizardPage.this._securityDomain = value;
            NewSecurityTypeWizardPage.this.setPageComplete(NewSecurityTypeWizardPage.this.validate());
        }
    }
}

