/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.model.merge;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.editor.model.merge.MergedModelAdapterFactory;

public abstract class AbstractMergedModelAdapter
implements Adapter {
    private static final Object NULL_VALUE = new Object();
    private MergedModelAdapterFactory _factory;
    private Notifier _target;

    protected AbstractMergedModelAdapter(MergedModelAdapterFactory factory) {
        this._factory = factory;
    }

    public SwitchYardType getSwitchYard() {
        return this._factory.getSwitchYard();
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return this._target;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget != this._target) {
            this._factory.clearFeatureDifferencesCache(this);
        }
        this._target = newTarget;
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(this.getClass());
    }

    protected EObject getSource() {
        if (this._target instanceof EObject) {
            return this._factory.getSource((EObject)this._target);
        }
        return null;
    }

    protected EObject getGenerated() {
        if (this._target instanceof EObject) {
            return this._factory.getGenerated((EObject)this._target);
        }
        return null;
    }

    protected Object getAggregatedValue(EStructuralFeature feature) {
        Comparison comparison;
        EObject source = this.getSource();
        EObject generated = this.getGenerated();
        if (source == null) {
            if (generated == null) {
                return null;
            }
            return generated.eGet(feature);
        }
        Object value = source.eGet(feature);
        Comparison comparison2 = comparison = this._factory == null ? null : this._factory.getDifferences(source);
        if (comparison == null) {
            return value;
        }
        if (feature.isMany()) {
            ArrayList<Object> added = (ArrayList<Object>)this._factory.getCachedFeatureDifferences(this, feature);
            if (added == null) {
                added = new ArrayList<Object>();
                if (this._factory.isCopiedSource(source, generated)) {
                    Collection sourceValues = (Collection)value;
                    Collection generatedValues = (Collection)generated.eGet(feature);
                    for (Object obj : generatedValues) {
                        if (obj instanceof EObject) {
                            if (this._factory.getSource((EObject)obj) != obj) continue;
                            added.add(obj);
                            continue;
                        }
                        added.addAll(generatedValues);
                        added.removeAll(sourceValues);
                        break;
                    }
                } else {
                    for (Diff difference : this._factory.getDifferencesFor(source)) {
                        Object addedElement;
                        if (difference.getKind() != DifferenceKind.DELETE || (addedElement = this.getRightTarget(feature, difference)) == null) continue;
                        added.add(addedElement);
                    }
                }
                this._factory.cacheFeatureDifferences(this, feature, added);
            }
            ArrayList<Object> aggregate = new ArrayList<Object>();
            if (value instanceof Collection) {
                aggregate.addAll((Collection)value);
            }
            aggregate.addAll(added);
            return aggregate;
        }
        if (!source.eIsSet(feature)) {
            Object added = this._factory.getCachedFeatureDifferences(this, feature);
            if (added == null) {
                for (Diff difference : this._factory.getDifferencesFor(source)) {
                    if (difference.getKind() != DifferenceKind.DELETE || (added = this.getRightTarget(feature, difference)) == null) continue;
                    this._factory.cacheFeatureDifferences(this, feature, added);
                    return added;
                }
                added = NULL_VALUE;
                this._factory.cacheFeatureDifferences(this, feature, added);
            }
            if (added != NULL_VALUE) {
                return added;
            }
        }
        return value;
    }

    private Object getRightTarget(final EStructuralFeature feature, Diff difference) {
        return new CompareSwitch<Object>(){

            public Object caseAttributeChange(AttributeChange object) {
                if (feature.equals(ExtendedMetaData.INSTANCE.getAffiliation(object.getMatch().getLeft().eClass(), (EStructuralFeature)object.getAttribute()))) {
                    return object.getValue();
                }
                if (ExtendedMetaData.INSTANCE.getGroup(feature) == object.getAttribute()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)object.getValue();
                    if (feature.equals(ExtendedMetaData.INSTANCE.getAffiliation(object.getMatch().getLeft().eClass(), entry.getEStructuralFeature()))) {
                        return entry.getValue();
                    }
                }
                return null;
            }

            public Object caseReferenceChange(ReferenceChange object) {
                if (feature.equals(ExtendedMetaData.INSTANCE.getAffiliation(object.getMatch().getLeft().eClass(), (EStructuralFeature)object.getReference()))) {
                    return object.getValue();
                }
                if (ExtendedMetaData.INSTANCE.getGroup(feature) == object.getReference()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)object.getValue();
                    if (feature.equals(ExtendedMetaData.INSTANCE.getAffiliation(object.getMatch().getLeft().eClass(), entry.getEStructuralFeature()))) {
                        return entry.getValue();
                    }
                }
                return null;
            }

            public Object defaultCase(EObject object) {
                return null;
            }
        }.doSwitch((EObject)difference);
    }
}

