/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.platform.GFPropertySection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.DomainType;
import org.switchyard.tools.models.switchyard1_0.switchyard.PropertiesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.PropertyType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class ApplicationPropertySection
extends GFPropertySection
implements ITabbedPropertyConstants,
ResourceSetListener {
    private static final String MESSAGE_TRACE_KEY = "org.switchyard.handlers.messageTrace.enabled";
    private Button _messageTraceCheckbox;
    private Object _businessObject;
    private boolean _inUpdate = false;
    private PictogramElement _pe = null;
    private TransactionalEditingDomain _domain = null;

    private void addDomainListener() {
        if (this._domain == null) {
            this._domain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
            this._domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._domain != null) {
            this._domain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this._messageTraceCheckbox = factory.createButton(composite, "Enable Message Trace", 16416);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this._messageTraceCheckbox.setLayoutData((Object)data);
        this._messageTraceCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (ApplicationPropertySection.this._businessObject != null && !ApplicationPropertySection.this._inUpdate) {
                    ApplicationPropertySection.this.updateMessageTraceHandler(ApplicationPropertySection.this._businessObject, ApplicationPropertySection.this._messageTraceCheckbox.getSelection());
                }
            }
        });
        this._messageTraceCheckbox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    ApplicationPropertySection.this._inUpdate = true;
                    ApplicationPropertySection.this._inUpdate = false;
                } else if (e.keyCode == 13) {
                    ApplicationPropertySection.this.updateMessageTraceHandler(ApplicationPropertySection.this._businessObject, ApplicationPropertySection.this._messageTraceCheckbox.getSelection());
                }
            }
        });
        this.addDomainListener();
    }

    private void updateMessageTraceHandler(Object bo, boolean value) {
        boolean changed = false;
        if (bo instanceof DocumentRoot) {
            final DocumentRoot root = (DocumentRoot)bo;
            boolean handlerExists = this.testForMessageTraceHandler(root);
            if (handlerExists && !value) {
                changed = true;
                this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                    protected void doExecute() {
                        ApplicationPropertySection.this.removeMessageTraceHandler(root);
                    }
                });
            } else if (!handlerExists && value) {
                changed = true;
                this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                    protected void doExecute() {
                        ApplicationPropertySection.this.addMessageTraceHandler(root);
                    }
                });
            }
        }
        if (this._pe != null && changed) {
            UpdateContext updateContext = new UpdateContext(this._pe);
            if (SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider() != null && SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider().getFeatureProvider() != null) {
                SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider().getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
            }
        }
    }

    private void removeMessageTraceHandler(DocumentRoot root) {
        PropertiesType properties;
        DomainType domain;
        if (root.getSwitchyard() != null && (domain = root.getSwitchyard().getDomain()) != null && (properties = domain.getProperties()) != null) {
            for (PropertyType property : properties.getProperty()) {
                if (!MESSAGE_TRACE_KEY.equals(property.getName())) continue;
                property.setValue(Boolean.toString(false));
                return;
            }
        }
    }

    private void addMessageTraceHandler(DocumentRoot root) {
        if (root.getSwitchyard() != null) {
            PropertiesType properties;
            DomainType domain = root.getSwitchyard().getDomain();
            if (domain == null) {
                domain = SwitchyardFactory.eINSTANCE.createDomainType();
                root.setDomain(domain);
            }
            if ((properties = domain.getProperties()) == null) {
                properties = SwitchyardFactory.eINSTANCE.createPropertiesType();
                domain.setProperties(properties);
            }
            for (PropertyType property : properties.getProperty()) {
                if (!MESSAGE_TRACE_KEY.equals(property.getName())) continue;
                property.setValue(Boolean.toString(true));
                return;
            }
            PropertyType messageTraceProperty = SwitchyardFactory.eINSTANCE.createPropertyType();
            messageTraceProperty.setName(MESSAGE_TRACE_KEY);
            messageTraceProperty.setValue(Boolean.toString(true));
            properties.getProperty().add((Object)messageTraceProperty);
        }
    }

    private boolean testForMessageTraceHandler(DocumentRoot root) {
        PropertiesType properties;
        DomainType domain;
        if (root.getSwitchyard() != null && (domain = root.getSwitchyard().getDomain()) != null && (properties = domain.getProperties()) != null) {
            for (PropertyType property : properties.getProperty()) {
                if (!MESSAGE_TRACE_KEY.equals(property.getName())) continue;
                return Boolean.valueOf(property.getValue());
            }
        }
        return false;
    }

    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PictogramElement pe = ApplicationPropertySection.this.getSelectedPictogramElement();
                if (pe != null) {
                    ApplicationPropertySection.this._inUpdate = true;
                    ApplicationPropertySection.this._pe = null;
                    ApplicationPropertySection.this._businessObject = null;
                    EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                    if (bo == null) {
                        return;
                    }
                    ApplicationPropertySection.this._businessObject = bo;
                    ApplicationPropertySection.this._pe = pe;
                    ApplicationPropertySection.this._inUpdate = true;
                    if (ApplicationPropertySection.this._messageTraceCheckbox != null && !ApplicationPropertySection.this._messageTraceCheckbox.isDisposed() && ApplicationPropertySection.this._businessObject instanceof DocumentRoot) {
                        DocumentRoot root = (DocumentRoot)ApplicationPropertySection.this._businessObject;
                        boolean messageTraceHandlerExists = ApplicationPropertySection.this.testForMessageTraceHandler(root);
                        ApplicationPropertySection.this._messageTraceCheckbox.setSelection(messageTraceHandlerExists);
                    }
                    ApplicationPropertySection.this._inUpdate = false;
                }
            }
        });
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this.refresh();
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public void dispose() {
        this.removeDomainListener();
        super.dispose();
    }

    public void aboutToBeHidden() {
        this._inUpdate = true;
        super.aboutToBeHidden();
    }
}

