/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.composite;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.notification.INotificationService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class CompositeMainComposite
extends AbstractModelComposite<Composite> {
    private Text _nameText;
    private Object _businessObject;
    private boolean _inUpdate = false;
    private PictogramElement _pe = null;
    private NameListener _nameListener = null;
    private Text _targetNamespaceText;
    private Label _tnsLabel;

    public CompositeMainComposite(ICompositeContainer container, org.eclipse.swt.widgets.Composite parent, int style) {
        super(Composite.class, container, parent, style);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        FormToolkit factory = this.getWidgetFactory();
        this._nameText = factory.createText((org.eclipse.swt.widgets.Composite)this, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this._nameText.setLayoutData((Object)data);
        this._nameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (CompositeMainComposite.this._businessObject != null && !CompositeMainComposite.this._inUpdate) {
                    CompositeMainComposite.this.updateObjectName(CompositeMainComposite.this._businessObject, CompositeMainComposite.this._nameText.getText().trim());
                }
            }
        });
        Label valueLabel = factory.createLabel((org.eclipse.swt.widgets.Composite)this, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this._nameText, -5);
        data.top = new FormAttachment((Control)this._nameText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        this._targetNamespaceText = factory.createText((org.eclipse.swt.widgets.Composite)this, "");
        data = new FormData();
        Integer widthTimes1Point5 = new Integer(127);
        data.left = new FormAttachment(0, widthTimes1Point5.intValue());
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this._nameText, 4);
        this._targetNamespaceText.setLayoutData((Object)data);
        this._targetNamespaceText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (CompositeMainComposite.this._businessObject != null && !CompositeMainComposite.this._inUpdate) {
                    CompositeMainComposite.this.updateTargetNamespace(CompositeMainComposite.this._businessObject, CompositeMainComposite.this._targetNamespaceText.getText().trim());
                }
            }
        });
        this._targetNamespaceText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    CompositeMainComposite.this._inUpdate = true;
                    CompositeMainComposite.this.undo((Control)CompositeMainComposite.this._targetNamespaceText);
                    CompositeMainComposite.this._inUpdate = false;
                } else if (e.keyCode == 13 || e.keyCode == 9) {
                    CompositeMainComposite.this.updateTargetNamespace(CompositeMainComposite.this._businessObject, CompositeMainComposite.this._targetNamespaceText.getText().trim());
                }
            }
        });
        this._tnsLabel = factory.createLabel((org.eclipse.swt.widgets.Composite)this, Messages.label_targetNamespace);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this._targetNamespaceText, -5);
        data.top = new FormAttachment((Control)this._targetNamespaceText, 0, 0x1000000);
        this._tnsLabel.setLayoutData((Object)data);
    }

    private void updateObjectName(final Object bo, final String value) {
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                Composite composite;
                boolean changed = false;
                if (bo instanceof Composite && !(composite = (Composite)bo).getName().contentEquals(value.trim())) {
                    changed = true;
                    composite.setName(value.trim());
                    if (composite.eContainer() instanceof SwitchYardType) {
                        SwitchYardType switchyard = (SwitchYardType)composite.eContainer();
                        switchyard.setName(value.trim());
                    }
                    SwitchyardSCAEditor editor = SwitchyardSCAEditor.getEditor((EObject)composite);
                    INotificationService notificationService = editor.getDiagramTypeProvider().getNotificationService();
                    notificationService.updatePictogramElements(notificationService.calculateRelatedPictogramElements(new Object[]{composite}));
                }
                if (CompositeMainComposite.this._pe != null && changed) {
                    UpdateContext updateContext = new UpdateContext(CompositeMainComposite.this._pe);
                    if (SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider() != null && SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider().getFeatureProvider() != null) {
                        SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider().getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
                    }
                }
            }
        });
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        try {
            Composite composite = (Composite)this.getTargetObject();
            if (composite != null) {
                this._businessObject = composite;
                if (this._nameListener == null) {
                    this._nameListener = new NameListener();
                }
                composite.eAdapters().add((Object)this._nameListener);
                if (this._nameText != null && !this._nameText.isDisposed()) {
                    String name = composite.getName();
                    this._nameText.setText(name == null ? "" : name);
                }
                if (this._targetNamespaceText != null && !this._targetNamespaceText.isDisposed()) {
                    String tns = composite.getTargetNamespace();
                    this._targetNamespaceText.setText(tns);
                }
            }
        }
        finally {
            this._inUpdate = false;
        }
    }

    private void undo(Control control) {
        if (control.equals(this._targetNamespaceText) && this._targetNamespaceText != null && !this._targetNamespaceText.isDisposed() && this._businessObject instanceof Composite) {
            Composite composite = (Composite)this._businessObject;
            this._targetNamespaceText.setText(composite.getTargetNamespace());
        }
    }

    private void updateTargetNamespace(final Object bo, final String value) {
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                boolean changed = false;
                if (bo instanceof Composite) {
                    Composite composite = (Composite)CompositeMainComposite.this._businessObject;
                    SwitchYardType switchyard = (SwitchYardType)composite.eContainer();
                    changed = true;
                    switchyard.setTargetNamespace(value);
                    composite.setTargetNamespace(value);
                }
                if (CompositeMainComposite.this._pe != null && changed) {
                    UpdateContext updateContext = new UpdateContext(CompositeMainComposite.this._pe);
                    if (SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider() != null && SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider().getFeatureProvider() != null) {
                        SwitchyardSCAEditor.getActiveEditor().getDiagramTypeProvider().getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
                    }
                }
            }
        });
    }

    private final class NameListener
    extends AdapterImpl {
        private NameListener() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature().equals(ScaPackage.eINSTANCE.getComposite_Name())) {
                CompositeMainComposite.this.refresh();
            } else if (msg.getFeature().equals(ScaPackage.eINSTANCE.getComponent_Name())) {
                CompositeMainComposite.this.refresh();
            } else {
                CompositeMainComposite.this.refresh();
            }
            super.notifyChanged(msg);
        }
    }
}

