/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.contract;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.switchyard.tools.ui.editor.BindingTypeExtensionManager;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.binding.BindingPropertyComposite;
import org.switchyard.tools.ui.editor.diagram.shared.IBindingComposite;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;
import org.switchyard.tools.ui.editor.property.adapters.LabelAdapter;

public class BindingsControlComposite
extends AbstractModelComposite<Contract>
implements ResourceSetListener {
    private Binding _binding = null;
    private ListViewer _listViewer;
    private FormToolkit _toolkit = null;
    private SashForm _sashForm;
    private Composite _tableComposite;
    private Button _removeButton;
    private Object _targetBO;
    private TransactionalEditingDomain _domain = null;
    private IBindingComposite _composite = null;
    private Map<String, IBindingComposite> _composites = new HashMap<String, IBindingComposite>();
    private ScrolledPageBook _pageBook = null;
    private String _validError = null;

    public BindingsControlComposite(ICompositeContainer container, Composite parent, int style) {
        super(Contract.class, container, parent, style);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        this._toolkit = this.getWidgetFactory();
        this._sashForm = new SashForm((Composite)this, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this._sashForm.setLayoutData((Object)data);
        this._sashForm.setLayout((Layout)new FillLayout());
        this._tableComposite = this._toolkit.createComposite((Composite)this._sashForm, 0);
        this._tableComposite.setLayout((Layout)new FillLayout());
        this.createTableAndButtons(this._tableComposite, 0);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(20);
        this._tableComposite.setLayoutData((Object)data);
        this._pageBook = new ScrolledPageBook((Composite)this._sashForm);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(20, 5);
        data.right = new FormAttachment(100, 0);
        this._pageBook.setLayoutData((Object)data);
        this._sashForm.setWeights(new int[]{25, 75});
        this.addDomainListener();
        this.adaptChildren((Control)this);
    }

    private void createTableAndButtons(Composite parent, int style) {
        boolean showButtons = true;
        Composite tableAndButtonsComposite = this._toolkit.createComposite(parent, 0);
        tableAndButtonsComposite.setLayout((Layout)new GridLayout(3, false));
        Composite buttonsComposite = this._toolkit.createComposite(tableAndButtonsComposite);
        buttonsComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        buttonsComposite.setLayout((Layout)new FillLayout(512));
        int span = 2;
        if (!showButtons) {
            span = 3;
        }
        this._listViewer = new ListViewer(tableAndButtonsComposite, 2818);
        GridData gridData = new GridData(4, 4, true, true, span, 1);
        gridData.widthHint = 100;
        gridData.heightHint = 100;
        this._listViewer.getList().setLayoutData((Object)gridData);
        this._listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Binding binding = (Binding)element;
                return LabelAdapter.getLabel((EObject)binding);
            }
        });
        this._listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof EList) {
                    EList v = (EList)inputElement;
                    return v.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this._listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (!ssel.isEmpty() && ssel.size() == 1 && ssel.getFirstElement() instanceof Binding) {
                    boolean justRefresh = true;
                    Binding testBinding = (Binding)ssel.getFirstElement();
                    String key = BindingsControlComposite.this.createKey(testBinding);
                    IBindingComposite testcomposite = (IBindingComposite)BindingsControlComposite.this._composites.get(key);
                    if (testcomposite == null) {
                        testcomposite = new BindingPropertyComposite(BindingTypeExtensionManager.instance().getExtensionFor(testBinding.getClass()).createComposites(BindingsControlComposite.this.getContainer().getToolkit(), testBinding));
                        BindingsControlComposite.this._composites.put(key, testcomposite);
                    }
                    if (BindingsControlComposite.this._composite == null || BindingsControlComposite.this._composite != testcomposite) {
                        justRefresh = false;
                    }
                    BindingsControlComposite.this._binding = testBinding;
                    BindingsControlComposite.this.handleSelectListItem(justRefresh);
                } else {
                    BindingsControlComposite.this._binding = null;
                    BindingsControlComposite.this.handleSelectListItem(true);
                }
            }
        });
        if (showButtons) {
            this._removeButton = this._toolkit.createButton(buttonsComposite, Messages.button_remove, 8);
            this._removeButton.setEnabled(false);
            this._removeButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget.equals(BindingsControlComposite.this._removeButton) && BindingsControlComposite.this._removeButton.isEnabled()) {
                        IStructuredSelection ssel = (IStructuredSelection)BindingsControlComposite.this._listViewer.getSelection();
                        if (BindingsControlComposite.this._composite != null && BindingsControlComposite.this._composite.getDidSomething()) {
                            BindingsControlComposite.this._composite.setDidSomething(false);
                            return;
                        }
                        if (ssel.size() == 1) {
                            Binding binding = (Binding)ssel.getFirstElement();
                            BindingsControlComposite.this.removeBinding(binding);
                        } else if (ssel.size() > 1) {
                            BindingsControlComposite.this.removeBindingss(ssel);
                        }
                        BindingsControlComposite.this._binding = null;
                        BindingsControlComposite.this.refresh();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
    }

    private void removeBindingss(IStructuredSelection ssel) {
        if (ssel != null && this._domain != null && this._targetBO instanceof Contract) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    Contract contract = (Contract)BindingsControlComposite.this._targetBO;
                    IStructuredSelection ssel = (IStructuredSelection)BindingsControlComposite.this._listViewer.getSelection();
                    for (Object next : ssel) {
                        contract.getBinding().remove(next);
                    }
                }
            });
            this.refresh();
        }
    }

    private void removeBinding(Binding selected) {
        if (selected != null && this._domain != null) {
            if (this._targetBO instanceof Contract) {
                RecordingCommand rcmd = new RecordingCommand(this._domain){

                    protected void doExecute() {
                        Contract contract = (Contract)BindingsControlComposite.this._targetBO;
                        IStructuredSelection ssel = (IStructuredSelection)BindingsControlComposite.this._listViewer.getSelection();
                        contract.getBinding().remove(ssel.getFirstElement());
                    }
                };
                this._domain.getCommandStack().execute((Command)rcmd);
            }
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        final Contract contract = (Contract)this.getTargetObject();
        if (contract != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BindingsControlComposite.this.getContainer().layout();
                    if (BindingsControlComposite.this._listViewer != null && BindingsControlComposite.this._listViewer.getList() != null && BindingsControlComposite.this._listViewer.getList().isDisposed()) {
                        return;
                    }
                    Contract newTarget = contract;
                    if (contract instanceof Service) {
                        BindingsControlComposite.this._listViewer.setInput((Object)((Service)contract).getBinding());
                    } else if (contract instanceof Reference) {
                        BindingsControlComposite.this._listViewer.setInput((Object)((Reference)contract).getBinding());
                    }
                    if (BindingsControlComposite.this._composite != null && BindingsControlComposite.this._composite.getDidSomething()) {
                        BindingsControlComposite.this._composite.setDidSomething(false);
                    }
                    if (BindingsControlComposite.this._targetBO == null) {
                        BindingsControlComposite.this._targetBO = newTarget;
                    } else if (BindingsControlComposite.this._targetBO != newTarget) {
                        BindingsControlComposite.this._targetBO = newTarget;
                    }
                    StructuredSelection ssel = (StructuredSelection)BindingsControlComposite.this._listViewer.getSelection();
                    if (!ssel.isEmpty()) {
                        Binding test = (Binding)ssel.getFirstElement();
                        if (test.eContainer() != BindingsControlComposite.this._targetBO) {
                            BindingsControlComposite.this._binding = null;
                        } else {
                            BindingsControlComposite.this._binding = test;
                        }
                    }
                    EList bindings = null;
                    if (BindingsControlComposite.this._targetBO instanceof Service) {
                        Service service = (Service)BindingsControlComposite.this._targetBO;
                        bindings = service.getBinding();
                    } else if (BindingsControlComposite.this._targetBO instanceof Reference) {
                        Reference reference = (Reference)BindingsControlComposite.this._targetBO;
                        bindings = reference.getBinding();
                    }
                    if (bindings != null && BindingsControlComposite.this._listViewer != null && !BindingsControlComposite.this._listViewer.getList().isDisposed()) {
                        BindingsControlComposite.this._listViewer.setInput((Object)bindings);
                        if (bindings.size() > 0) {
                            if (BindingsControlComposite.this._binding != null && bindings.contains((Object)BindingsControlComposite.this._binding)) {
                                BindingsControlComposite.this._listViewer.setSelection((ISelection)new StructuredSelection((Object)BindingsControlComposite.this._binding), true);
                            } else {
                                BindingsControlComposite.this._listViewer.setSelection((ISelection)new StructuredSelection(bindings.get(0)));
                            }
                        } else {
                            BindingsControlComposite.this._pageBook.showEmptyPage();
                        }
                        BindingsControlComposite.this._listViewer.getControl().setFocus();
                    }
                    BindingsControlComposite.this._pageBook.getContainer().layout();
                    BindingsControlComposite.this.getContainer().layout();
                }
            });
        }
    }

    private String createKey(Binding binding) {
        return String.valueOf(binding.getClass().getCanonicalName()) + binding.eContainer().getClass().getCanonicalName();
    }

    private void handleSelectListItem(boolean justRefresh) {
        if (this._removeButton != null && !this._removeButton.isDisposed()) {
            this._removeButton.setEnabled(!this._listViewer.getSelection().isEmpty());
        }
        if (this._binding != null) {
            String bindingKey = this.createKey(this._binding);
            final IBindingComposite composite = this._composites.get(bindingKey);
            if (composite.getPanel() == null) {
                composite.setOpenOnCreate(true);
                composite.setTargetObject(this._binding.eContainer());
                composite.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent arg0) {
                        if (BindingsControlComposite.this._composite != null) {
                            BindingsControlComposite.this._validError = BindingsControlComposite.this._composite.getErrorMessage();
                            BindingsControlComposite.this.getContainer().validated(BindingsControlComposite.this.validate());
                        }
                    }
                });
                this.getContainer().getObservablesManager().runAndCollect(new Runnable(){

                    @Override
                    public void run() {
                        composite.createContents(BindingsControlComposite.this._pageBook.getContainer(), 0, BindingsControlComposite.this.getContainer().getDataBindingContext());
                    }
                });
                this._pageBook.registerPage((Object)bindingKey, (Control)composite.getPanel());
                this.adaptChildren((Control)composite.getPanel());
            }
            this._composite = composite;
            if (composite.getBinding() != this._binding) {
                composite.setBinding(this._binding);
            }
            this._validError = this._composite.getErrorMessage();
            this.getContainer().validated(this.validate());
            this._pageBook.showPage((Object)bindingKey);
        } else {
            this._pageBook.showEmptyPage();
        }
        this.getContainer().layout();
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
        this.refresh();
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent arg0) throws RollbackException {
        return null;
    }

    private void addDomainListener() {
        if (this._domain == null) {
            this._domain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
            this._domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._domain != null) {
            this._domain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void dispose() {
        this.removeDomainListener();
        for (IBindingComposite bindingComposite : this._composites.values()) {
            bindingComposite.dispose();
        }
        this._composites.clear();
        super.dispose();
    }

    @Override
    public IStatus validate() {
        if (this._validError != null) {
            return new Status(4, "org.switchyard.tools.ui.editor", this._validError);
        }
        return super.validate();
    }
}

