/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.switchyard.tools.ui.editor.refactoring.UpdateReferencedModelURIChange;

public class SwitchYardRenameParticipant
extends RenameParticipant {
    private IFile _diagramFile;

    protected boolean initialize(Object element) {
        if (!(element instanceof IFile)) {
            return false;
        }
        IFile modelFile = (IFile)element;
        IPath diagramPath = modelFile.getProject().getFullPath().append(".xml").append(modelFile.getProjectRelativePath()).addFileExtension("diagram");
        this._diagramFile = modelFile.getWorkspace().getRoot().getFile(diagramPath);
        return this._diagramFile.exists();
    }

    public String getName() {
        return "SwitchYard Diagram File Rename";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        final String newName = String.valueOf(this.getArguments().getNewName()) + ".diagram";
        CompositeChange change = new CompositeChange(this.getName());
        IFile newFile = this._diagramFile.getParent().getFile((IPath)new Path(newName));
        if (newFile.exists()) {
            change.add((Change)new DeleteResourceChange(newFile.getFullPath(), true));
        }
        change.add((Change)new RenameResourceChange(this._diagramFile.getFullPath(), newName));
        change.add((Change)new UpdateReferencedModelURIChange(this._diagramFile){

            @Override
            protected IFile getDestination() {
                return SwitchYardRenameParticipant.this._diagramFile.getParent().getFile((IPath)new Path(newName));
            }
        });
        return change;
    }
}

