/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.refactoring;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public abstract class UpdateReferencedModelURIChange
extends ResourceChange {
    private final IFile _source;

    public UpdateReferencedModelURIChange(IFile source) {
        this._source = source;
    }

    protected IResource getModifiedResource() {
        return this._source;
    }

    public String getName() {
        return "Update SwitchYard Diagram File";
    }

    protected abstract IFile getDestination();

    protected IFile getDiagram() {
        return this.getDestination();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IFile destination = this.getDestination();
        String oldModelPath = this.getModelPathForDiagram(this._source);
        URI newModelURI = URI.createPlatformResourceURI((String)this.getModelPathForDiagram(destination), (boolean)true);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource diagram = rs.createResource(URI.createPlatformResourceURI((String)this.getDiagram().getFullPath().toPortableString(), (boolean)true), "org.eclipse.graphiti.content.diagram");
        rs.getResources().remove((Object)diagram);
        try {
            try {
                diagram.load(this.getLoadOptions());
                for (EObject eobject : EcoreUtil.ExternalCrossReferencer.find((Resource)diagram).keySet()) {
                    InternalEObject ieobject = (InternalEObject)eobject;
                    if (!ieobject.eIsProxy() || !oldModelPath.equals(ieobject.eProxyURI().toPlatformString(true))) continue;
                    ieobject.eSetProxyURI(newModelURI.appendFragment(ieobject.eProxyURI().fragment()));
                }
                diagram.save(null);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", "Error updating SwitchYard diagram file.", (Throwable)e));
            }
        }
        finally {
            try {
                diagram.unload();
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        return new UndoUpdateReferencedModelURIChange(destination, this._source, destination);
    }

    private Map<?, ?> getLoadOptions() {
        return new HashMap<Object, Object>(){
            {
                this.put("URI_HANDLER", new URIHandlerImpl(){
                    {
                        this.resolve = true;
                        this.baseURI = URI.createPlatformResourceURI((String)UpdateReferencedModelURIChange.this._source.getFullPath().toPortableString(), (boolean)true);
                    }

                    public void setBaseURI(URI uri) {
                    }
                });
            }
        };
    }

    private String getModelPathForDiagram(IFile file) {
        return file.getProject().getFullPath().append(file.getProjectRelativePath().removeFirstSegments(1).removeFileExtension()).toPortableString();
    }

    private static final class UndoUpdateReferencedModelURIChange
    extends UpdateReferencedModelURIChange {
        private final IFile _destination;
        private final IFile _diagram;

        private UndoUpdateReferencedModelURIChange(IFile source, IFile destination, IFile diagram) {
            super(source);
            this._destination = destination;
            this._diagram = diagram;
        }

        @Override
        protected IFile getDestination() {
            return this._destination;
        }

        @Override
        protected IFile getDiagram() {
            return this._diagram;
        }
    }
}

