/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.transform.DozerFileEntryType;
import org.switchyard.tools.models.switchyard1_0.transform.DozerMappingFilesType;
import org.switchyard.tools.models.switchyard1_0.transform.DozerTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.TransformFactory;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.ITransformControl;
import org.switchyard.tools.ui.editor.transform.ITransformProvider;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;

public class DozerTransformProvider
implements ITransformProvider {
    private static final String TEMPLATE = "DozerTemplate.ftl";
    private static final String TRANSFORMS_PARAM = "transforms";

    @Override
    public boolean providesWizard() {
        return false;
    }

    @Override
    public INewTransformWizard createWizard() {
        return null;
    }

    @Override
    public ITransformControl createTransformControl(Composite parent, ITransformProvider.IContainer container) {
        return new DozerTransformControl(parent, container);
    }

    @Override
    public String getName() {
        return Messages.DozerTransformProvider_Dozer_Transform_Title;
    }

    private static final class DozerTransformControl
    implements ITransformControl {
        private final ITransformProvider.IContainer _container;
        private final IJavaProject _project;
        private Collection<TransformType> _transforms;
        private Composite _content;
        private org.eclipse.swt.widgets.List _fileList;
        private Button _removeButton;
        private Button _upButton;
        private Button _downButton;
        private Button _clearAllButton;

        private DozerTransformControl(Composite parent, ITransformProvider.IContainer container) {
            this._container = container;
            this._project = JavaCore.create((IProject)container.getContainingProject());
            this._content = new Composite(parent, 0);
            this._content.setLayout((Layout)new GridLayout(1, false));
            Group group = new Group(this._content, 0);
            group.setText(Messages.DozerTransformProvider_Dozer_file_group_title);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            this._fileList = new org.eclipse.swt.widgets.List((Composite)group, 2560);
            this._fileList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
            this._fileList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    DozerTransformControl.this.updateButtons();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    DozerTransformControl.this.updateButtons();
                }
            });
            Button browseButton = new Button((Composite)group, 8);
            browseButton.setLayoutData((Object)new GridData(256));
            browseButton.setText(Messages.button_browse);
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DozerTransformControl.this.browse();
                }
            });
            Button newButton = new Button((Composite)group, 8);
            newButton.setLayoutData((Object)new GridData(256));
            newButton.setText(Messages.DozerTransformProvider_New_Button);
            newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DozerTransformControl.this.browseNew();
                }
            });
            this._removeButton = new Button((Composite)group, 8);
            this._removeButton.setLayoutData((Object)new GridData(256));
            this._removeButton.setText(Messages.button_remove);
            this._removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DozerTransformControl.this.remove();
                }
            });
            this._upButton = new Button((Composite)group, 8);
            this._upButton.setLayoutData((Object)new GridData(256));
            this._upButton.setText(Messages.button_up);
            this._upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DozerTransformControl.this.moveUp();
                }
            });
            this._downButton = new Button((Composite)group, 8);
            this._downButton.setLayoutData((Object)new GridData(256));
            this._downButton.setText(Messages.button_down);
            this._downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DozerTransformControl.this.moveDown();
                }
            });
            this._clearAllButton = new Button((Composite)group, 8);
            this._clearAllButton.setLayoutData((Object)new GridData(256));
            this._clearAllButton.setText(Messages.button_clearAll);
            this._clearAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DozerTransformControl.this.clearAll();
                }
            });
            this.updateButtons();
        }

        private void updateButtons() {
            boolean enabled = this._fileList.getSelectionCount() > 0;
            this._removeButton.setEnabled(enabled);
            this._upButton.setEnabled(enabled);
            this._downButton.setEnabled(enabled);
            this._clearAllButton.setEnabled(this._fileList.getItemCount() > 0);
        }

        @Override
        public void setVisible(boolean visible) {
            this._content.setVisible(visible);
        }

        @Override
        public void setSelectedTransforms(Collection<TransformType> transforms) {
            this._transforms = transforms;
        }

        @Override
        public IStatus validate() {
            IStatus transformsStaus = this.validateSelectedTransformers();
            if (!transformsStaus.isOK()) {
                return transformsStaus;
            }
            String[] items = this._fileList.getItems();
            int i = 0;
            while (i < items.length) {
                String pathString = items[i];
                if (pathString != null && !pathString.trim().isEmpty()) {
                    Path path = new Path(pathString);
                    if (!path.isValidPath(pathString)) {
                        return new Status(4, "org.switchyard.tools.ui.editor", Messages.DozerTransformProvider_invalid_path_error);
                    }
                    try {
                        IFile file = this._container.getContainingProject().getWorkspace().getRoot().getFile((IPath)path);
                        if (!this._project.isOnClasspath((IResource)file.getParent())) {
                            return new Status(2, "org.switchyard.tools.ui.editor", Messages.DozerTransformProvider_file_not_on_classpath_error);
                        }
                    }
                    catch (Exception e) {
                        return new Status(4, "org.switchyard.tools.ui.editor", e.getMessage());
                    }
                }
                ++i;
            }
            return Status.OK_STATUS;
        }

        private IStatus validateSelectedTransformers() {
            if (this._transforms == null) {
                return Status.OK_STATUS;
            }
            for (TransformType transformer : this._transforms) {
                if (NewTransformWizard.isJavaType(transformer.getFrom()) && NewTransformWizard.isJavaType(transformer.getTo())) continue;
                return new Status(4, "org.switchyard.tools.ui.editor", Messages.DozerTransformProvider_Only_java_types_supported);
            }
            return Status.OK_STATUS;
        }

        @Override
        public Collection<TransformType> createTransforms() throws CoreException {
            if (this._transforms == null || this._transforms.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TransformType> dozerTransforms = new ArrayList<TransformType>(this._transforms.size());
            ArrayList<String> dozerFilePaths = new ArrayList<String>();
            if (this._fileList.getItemCount() > 0) {
                int i = 0;
                while (i < this._fileList.getItemCount()) {
                    String item = this._fileList.getItem(i);
                    IFile dozerFile = this._project.getProject().getWorkspace().getRoot().getFile((IPath)new Path(item));
                    if (!dozerFile.exists()) {
                        this.createNewDozerFile(dozerFile);
                    }
                    String dozerFilePath = JavaUtil.getJavaPathForResource((IResource)dozerFile).toString();
                    dozerFilePaths.add(dozerFilePath);
                    ++i;
                }
            }
            for (TransformType transform : this._transforms) {
                DozerTransformType dozerTransform = TransformFactory.eINSTANCE.createDozerTransformType();
                dozerTransform.setFrom(transform.getFrom());
                dozerTransform.setTo(transform.getTo());
                if (!dozerFilePaths.isEmpty()) {
                    DozerMappingFilesType mappingFiles = TransformFactory.eINSTANCE.createDozerMappingFilesType();
                    for (String dozerFilePath : dozerFilePaths) {
                        DozerFileEntryType model = TransformFactory.eINSTANCE.createDozerFileEntryType();
                        model.setFile(dozerFilePath);
                        mappingFiles.getEntry().add((Object)model);
                    }
                    dozerTransform.setMappingFiles(mappingFiles);
                }
                dozerTransforms.add((TransformType)dozerTransform);
            }
            return dozerTransforms;
        }

        @Override
        public void setLayoutData(Object data) {
            this._content.setLayoutData(data);
        }

        @Override
        public void dispose() {
        }

        private void moveUp() {
            int index = this._fileList.getSelectionIndex();
            if (index > 0) {
                List<String> itemList = Arrays.asList(this._fileList.getItems());
                ArrayList<String> newList = new ArrayList<String>(itemList);
                String itemToMove = newList.get(index);
                newList.remove(index);
                newList.add(index - 1, itemToMove);
                this._fileList.setItems(newList.toArray(new String[newList.size()]));
                this._fileList.select(index - 1);
                this.updateButtons();
            }
        }

        private void moveDown() {
            int index = this._fileList.getSelectionIndex();
            if (index < this._fileList.getItemCount() - 1) {
                List<String> itemList = Arrays.asList(this._fileList.getItems());
                ArrayList<String> newList = new ArrayList<String>(itemList);
                String itemToMove = newList.get(index);
                newList.remove(index);
                newList.add(index + 1, itemToMove);
                this._fileList.setItems(newList.toArray(new String[newList.size()]));
                this._fileList.select(index + 1);
                this.updateButtons();
            }
        }

        private void browseNew() {
            IResource temp;
            Path path;
            IResource temp2;
            String pathString = "";
            Object resource = pathString == null || pathString.isEmpty() ? ((temp2 = JavaUtil.getFirstResourceRoot((IJavaProject)this._project)) == null ? this._project.getResource() : temp2) : ((path = new Path(pathString)).isValidPath(pathString) ? this._project.getProject().getWorkspace().getRoot().getFile((IPath)path) : ((temp = JavaUtil.getFirstResourceRoot((IJavaProject)this._project)) == null ? this._project.getResource() : temp));
            FileSelectionWizard wizard = new FileSelectionWizard((IStructuredSelection)new StructuredSelection(resource));
            WizardDialog dialog = new WizardDialog(this._content.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                this._fileList.add(wizard.getSelection().toString());
                this.updateButtons();
            }
        }

        private void browse() {
            IResource temp;
            Path path;
            IResource temp2;
            String pathString = "";
            Object resource = pathString == null || pathString.isEmpty() ? ((temp2 = JavaUtil.getFirstResourceRoot((IJavaProject)this._project)) == null ? this._project.getResource() : temp2) : ((path = new Path(pathString)).isValidPath(pathString) ? this._project.getProject().getWorkspace().getRoot().getFile((IPath)path) : ((temp = JavaUtil.getFirstResourceRoot((IJavaProject)this._project)) == null ? this._project.getResource() : temp));
            ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this._content.getShell(), (IContainer)resource.getProject(), new HashSet<String>(Arrays.asList("xml")));
            dialog.setInitialPattern("*.xml");
            dialog.setTitle(Messages.DozerTransformProvider_Select_Dozer_File_dialog_title);
            if (dialog.open() == 0) {
                this._fileList.add(((IResource)dialog.getFirstResult()).getFullPath().toString());
                this.updateButtons();
            }
        }

        private void remove() {
            int index = this._fileList.getSelectionIndex();
            if (index > 0) {
                this._fileList.remove(index);
                this.updateButtons();
            }
        }

        private void clearAll() {
            if (this._fileList.getItemCount() > 0) {
                this._fileList.removeAll();
                this.updateButtons();
            }
        }

        private void createNewDozerFile(final IFile file) throws CoreException {
            final IAdaptable uiInfo = WorkspaceUndoUtil.getUIInfoAdapter((Shell)this._content.getShell());
            final InputStream contents = this.createContents();
            try {
                try {
                    this._container.getContext().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        try {
                                            new CreateFileOperation(file, null, contents, Messages.DozerTransformProvider_creating_transformation_status).execute(monitor, uiInfo);
                                        }
                                        catch (ExecutionException e) {
                                            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.DozerTransformProvider_error_creating_dozer_transformer, (Throwable)e));
                                        }
                                    }
                                }, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Throwable realException = e.getTargetException();
                    if (realException instanceof CoreException) {
                        throw (CoreException)realException;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.DozerTransformProvider_error_creating_dozer_transformer, realException));
                }
                catch (InterruptedException e) {
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.DozerTransformProvider_error_creating_dozer_transformer, (Throwable)e));
                }
            }
            finally {
                try {
                    contents.close();
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
            }
        }

        private InputStream createContents() throws CoreException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Configuration config = new Configuration();
                config.setClassForTemplateLoading(this.getClass(), "");
                config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(){

                    public TemplateModel wrap(final Object obj) throws TemplateModelException {
                        if (obj instanceof TransformType) {
                            return new TemplateHashModel(){

                                public boolean isEmpty() throws TemplateModelException {
                                    return false;
                                }

                                public TemplateModel get(String param) throws TemplateModelException {
                                    final QName qname = "from".equals(param) ? QName.valueOf(((TransformType)obj).getFrom()) : ("to".equals(param) ? QName.valueOf(((TransformType)obj).getTo()) : null);
                                    if (qname == null) {
                                        return null;
                                    }
                                    return new TemplateHashModel(){

                                        public boolean isEmpty() throws TemplateModelException {
                                            return false;
                                        }

                                        public TemplateModel get(String paramFrom) throws TemplateModelException {
                                            if ("localPart".equals(paramFrom)) {
                                                return this.wrap(qname.getLocalPart());
                                            }
                                            if ("namespaceURI".equals(paramFrom)) {
                                                return this.wrap(qname.getNamespaceURI());
                                            }
                                            return null;
                                        }
                                    };
                                }
                            };
                        }
                        return super.wrap(obj);
                    }
                });
                HashMap<String, Collection<TransformType>> parameters = new HashMap<String, Collection<TransformType>>();
                parameters.put(DozerTransformProvider.TRANSFORMS_PARAM, this._transforms);
                Template template = config.getTemplate(DozerTransformProvider.TEMPLATE);
                template.process(parameters, (Writer)new PrintWriter(baos));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                return byteArrayInputStream;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.DozerTransformProvider_error_creating_dozer_transformer, (Throwable)e));
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
            }
        }

        private final class FileSelectionWizard
        extends Wizard {
            private WizardNewFileCreationPage _page;
            private IStructuredSelection _selection;
            private IPath _result;

            private FileSelectionWizard(IStructuredSelection selection) {
                this._selection = selection;
                this.setWindowTitle(Messages.DozerTransformProvider_new_transform_wizard_title);
            }

            private IPath getSelection() {
                return this._result;
            }

            public boolean performFinish() {
                this._result = this._page.getContainerFullPath().append(this._page.getFileName());
                return true;
            }

            public void addPages() {
                this._page = new WizardNewFileCreationPage("pageName", this._selection){

                    protected boolean validatePage() {
                        if (super.validatePage()) {
                            IFile file = DozerTransformControl.this._project.getProject().getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
                            if (!DozerTransformControl.this._project.isOnClasspath((IResource)file.getParent())) {
                                this.setMessage(Messages.error_specifiedFileNotOnClasspath, 2);
                            }
                            return true;
                        }
                        return false;
                    }

                    protected void createAdvancedControls(Composite parent) {
                    }

                    protected IStatus validateLinkedResource() {
                        return Status.OK_STATUS;
                    }
                };
                IResource resource = (IResource)this._selection.getFirstElement();
                if (resource.getType() == 1) {
                    this._page.setFileName(resource.getFullPath().lastSegment());
                }
                this._page.setFileExtension("xml");
                this._page.setTitle(Messages.DozerTransformProvider_new_transform_wizard_title);
                this._page.setDescription(Messages.DozerTransformProvider_new_file_wizard_page_description);
                this.addPage((IWizardPage)this._page);
            }
        }
    }
}

