/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.transform.JAXBTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.TransformFactory;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.ITransformControl;
import org.switchyard.tools.ui.editor.transform.ITransformProvider;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;

public class JAXBTransformProvider
implements ITransformProvider {
    @Override
    public boolean providesWizard() {
        return false;
    }

    @Override
    public INewTransformWizard createWizard() {
        return null;
    }

    @Override
    public ITransformControl createTransformControl(Composite parent, ITransformProvider.IContainer container) {
        return new JAXBTransformControl(parent, container);
    }

    @Override
    public String getName() {
        return Messages.label_jaxbTransformer;
    }

    private static final class JAXBTransformControl
    implements ITransformControl {
        private final ITransformProvider.IContainer _container;
        private final IJavaProject _project;
        private final boolean _is21Model;
        private Composite _content;
        private Collection<TransformType> _transforms;
        private Set<String> _packages = new LinkedHashSet<String>();
        private ListViewer _packagesView;
        private Button _enableAttachmentCheckbox;
        private Button _enableXOPPackageCheckbox;

        private JAXBTransformControl(Composite parent, ITransformProvider.IContainer container) {
            this._container = container;
            this._project = JavaCore.create((IProject)container.getContainingProject());
            this._is21Model = this.isVersion21OrHigher();
            this._content = new Composite(parent, 0);
            this._content.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(this._content, 0);
            label.setText(Messages.label_contextPath);
            label.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 2));
            this._packagesView = new ListViewer(this._content, 2826);
            this._packagesView.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
            this._packagesView.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this._packagesView.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            ((GridData)this._packagesView.getControl().getLayoutData()).heightHint = this._packagesView.getList().getItemHeight() * 3;
            this._packagesView.setInput(this._packages);
            Button addButton = new Button(this._content, 8);
            addButton.setText(Messages.button_addPackages);
            addButton.setLayoutData((Object)new GridData(4, 128, false, false));
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (JAXBTransformControl.this.addPackages()) {
                        JAXBTransformControl.this._packagesView.refresh();
                        JAXBTransformControl.this.internalValidate();
                    }
                }
            });
            Button removeButton = new Button(this._content, 8);
            removeButton.setText(Messages.button_removePackages);
            removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (JAXBTransformControl.this.removePackages()) {
                        JAXBTransformControl.this._packagesView.refresh();
                        JAXBTransformControl.this.internalValidate();
                    }
                }
            });
            if (this._is21Model) {
                this._enableAttachmentCheckbox = new Button(this._content, 32);
                this._enableAttachmentCheckbox.setText(Messages.JAXBTransformProvider_label_enableAttachment);
                GridData enableAttChxGD = new GridData(768);
                enableAttChxGD.horizontalSpan = 2;
                this._enableAttachmentCheckbox.setLayoutData((Object)enableAttChxGD);
                this._enableXOPPackageCheckbox = new Button(this._content, 32);
                this._enableXOPPackageCheckbox.setText(Messages.JAXBTransformProvider_label_enableXopPackage);
                this._enableXOPPackageCheckbox.setSelection(true);
                GridData enableXopChxGD = new GridData(768);
                enableXopChxGD.horizontalSpan = 2;
                this._enableXOPPackageCheckbox.setLayoutData((Object)enableXopChxGD);
            }
        }

        @Override
        public void dispose() {
        }

        @Override
        public void setVisible(boolean visible) {
            this._content.setVisible(visible);
        }

        @Override
        public void setSelectedTransforms(Collection<TransformType> transforms) {
            this._transforms = transforms;
        }

        @Override
        public IStatus validate() {
            if (this._transforms != null) {
                for (TransformType transformer : this._transforms) {
                    if (!(NewTransformWizard.isJavaType(transformer.getFrom()) ? NewTransformWizard.isJavaType(transformer.getTo()) : !NewTransformWizard.isJavaType(transformer.getTo()))) continue;
                    return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_jaxbOnlySupportsJavaToFromXml);
                }
            }
            return Status.OK_STATUS;
        }

        @Override
        public Collection<TransformType> createTransforms() {
            String enableXop;
            String enableAttachment;
            if (this._transforms == null) {
                return Collections.emptyList();
            }
            String contextPath = this.createContextPath();
            if (this._is21Model) {
                enableAttachment = Boolean.toString(this._enableAttachmentCheckbox.getSelection());
                enableXop = Boolean.toString(this._enableXOPPackageCheckbox.getSelection());
            } else {
                enableAttachment = null;
                enableXop = null;
            }
            ArrayList<TransformType> jaxbTransforms = new ArrayList<TransformType>(this._transforms.size());
            for (TransformType transform : this._transforms) {
                JAXBTransformType jaxbTransform = TransformFactory.eINSTANCE.createJAXBTransformType();
                jaxbTransform.setFrom(transform.getFrom());
                jaxbTransform.setTo(transform.getTo());
                jaxbTransform.setContextPath(contextPath);
                if (this._is21Model) {
                    jaxbTransform.setEnableAttachment((Object)enableAttachment);
                    jaxbTransform.setEnableXOPPackage((Object)enableXop);
                }
                jaxbTransforms.add((TransformType)jaxbTransform);
            }
            return jaxbTransforms;
        }

        @Override
        public void setLayoutData(Object data) {
            this._content.setLayoutData(data);
        }

        private String createContextPath() {
            StringBuffer buf = new StringBuffer();
            for (String pkg : this._packages) {
                buf.append(pkg).append(":");
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
                return buf.toString();
            }
            return null;
        }

        private void internalValidate() {
            this._container.updateStatus(this, this.validate());
        }

        private boolean addPackages() {
            boolean changed = false;
            try {
                IJavaElement filter = JavaUtil.getInitialPackageForProject((IJavaProject)this._project);
                SelectionDialog dialog = JavaUI.createPackageDialog((Shell)this._content.getShell(), (IJavaProject)this._project, (int)40, (String)(filter instanceof IPackageFragment ? ((IPackageFragment)filter).getElementName() : ""));
                dialog.setTitle(Messages.title_selectJaxbPackages);
                dialog.setMessage(Messages.description_selectJaxbPackages);
                if (dialog.open() == 0) {
                    Object[] objectArray = dialog.getResult();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        changed = this._packages.add(((IPackageFragment)obj).getElementName()) || changed;
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                Activator.logStatus(e.getStatus());
            }
            return changed;
        }

        private boolean removePackages() {
            IStructuredSelection selection = (IStructuredSelection)this._packagesView.getSelection();
            if (selection == null || selection.isEmpty()) {
                return false;
            }
            boolean changed = false;
            for (Object obj : selection.toList()) {
                boolean bl = changed = this._packages.remove(obj) || changed;
            }
            return changed;
        }

        private boolean isVersion21OrHigher() {
            IProject project = this._project.getProject();
            String version = SwitchYardModelUtils.getSwitchYardProjectRuntimeVersion((IProject)project);
            return !version.startsWith("2.0") && !version.startsWith("1");
        }
    }
}

