/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.NewTransformWizardPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NewJavaTransformerClassPage
extends NewTypeWizardPage {
    private static final String XML_ESB_TYPE = "XML_ESB_TYPE";
    private static final List<String> XML_ESB_TYPES = Arrays.asList(Element.class.getCanonicalName(), Document.class.getCanonicalName(), Node.class.getCanonicalName(), String.class.getCanonicalName(), "org.switchyard.Message", Object.class.getCanonicalName());
    private Collection<TransformType> _transforms;
    private IStatus _xmlESBTypeStatus = Status.OK_STATUS;
    private XMLESBTypeComboViewer _xmlESBTypeList;
    private String _xmlESBType = XML_ESB_TYPES.get(0);

    public NewJavaTransformerClassPage() {
        super(true, NewTransformWizardPage.class.getCanonicalName());
        this.setTitle(Messages.title_newJavaTransformerClass);
        this.setDescription(Messages.description_newJavaTransformerClass);
    }

    public void init(IProject project) {
        IJavaElement initialElement = JavaUtil.getInitialPackageForProject((IJavaProject)JavaCore.create((IProject)project));
        this.initContainerPage(initialElement);
        this.initTypePage(initialElement);
        this.setModifiers(17, false);
        this.doStatusUpdate();
    }

    protected void setSelectedTransforms(Collection<TransformType> transforms) {
        this._transforms = transforms;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createXMLESBTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createXMLESBTypeControls(Composite composite, int nColumns) {
        Label label = new Label(composite, 0);
        label.setText(Messages.label_forXmlEsbTypesUse);
        this._xmlESBTypeList = new XMLESBTypeComboViewer(composite);
        this._xmlESBTypeList.getCombo().setLayoutData((Object)new GridData(768));
        this._xmlESBTypeList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._xmlESBTypeList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._xmlESBTypeList.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, nColumns - 2, 1));
        this._xmlESBTypeList.setInput(XML_ESB_TYPES);
        if (this._xmlESBType != null) {
            this._xmlESBTypeList.setSelection((ISelection)new StructuredSelection((Object)this._xmlESBType));
        }
        this._xmlESBTypeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewJavaTransformerClassPage.this.handleFieldChanged(NewJavaTransformerClassPage.XML_ESB_TYPE);
            }
        });
        Button button = new Button(composite, 8);
        button.setText(Messages.button_browse);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewJavaTransformerClassPage.this.browseXMLESBType();
            }
        });
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == XML_ESB_TYPE) {
            this._xmlESBType = this._xmlESBTypeList.getSelection().isEmpty() ? "" : ((IStructuredSelection)this._xmlESBTypeList.getSelection()).getFirstElement().toString();
            this.validateXMLESBType();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this._xmlESBTypeStatus};
        this.updateStatus(status);
    }

    private void validateXMLESBType() {
        if (this._xmlESBType == null || this._xmlESBType.length() == 0) {
            this._xmlESBTypeStatus = new Status(4, "org.switchyard.tools.ui.editor", Messages.error_selectJavaTypeforXmlEsbTypes);
            return;
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            this._xmlESBTypeStatus = JavaConventions.validateJavaTypeName((String)this._xmlESBType, (String)"1.5", (String)"1.5");
            return;
        }
        try {
            if (javaProject.findType(this._xmlESBType) != null) {
                this._xmlESBTypeStatus = Status.OK_STATUS;
                return;
            }
        }
        catch (JavaModelException e) {
            e.fillInStackTrace();
        }
        this._xmlESBTypeStatus = new Status(2, "org.switchyard.tools.ui.editor", Messages.error_selectedXmlEsbTypeNotOnClasspath);
    }

    private void browseXMLESBType() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return;
        }
        try {
            IJavaElement[] elements = new IJavaElement[]{project};
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
            String filter = this._xmlESBType == null ? "" : this._xmlESBType;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getContainer(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)filter);
            dialog.setTitle(Messages.title_selectXmlEsbType);
            dialog.setMessage(Messages.description_selectXmlEsbType);
            if (dialog.open() == 0) {
                this._xmlESBTypeList.setSelection((ISelection)new StructuredSelection((Object)((IType)dialog.getResult()[0]).getFullyQualifiedName()));
            }
        }
        catch (JavaModelException e) {
            Activator.logStatus(e.getStatus());
        }
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        String lineDelimiter = this.getJavaProject().getJavaModel().findRecommendedLineSeparator();
        HashSet<String> methodNames = new HashSet<String>();
        for (TransformType transform : this._transforms) {
            this.createTransformMethod(type, transform, type.getCompilationUnit(), imports, lineDelimiter, methodNames, monitor);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void createTransformMethod(IType type, TransformType transform, ICompilationUnit cu, NewTypeWizardPage.ImportsManager imports, String lineDelimiter, Collection<String> methodNames, IProgressMonitor monitor) throws CoreException {
        String typeName = type.getFullyQualifiedName();
        TypeHelper fromType = new TypeHelper(QName.valueOf(transform.getFrom()));
        TypeHelper toType = new TypeHelper(QName.valueOf(transform.getTo()));
        String methodName = this.createTransformMethodName(fromType, toType, methodNames);
        StringBuffer methodText = new StringBuffer();
        this.createMethodAnnotation(methodText, fromType, toType, imports, lineDelimiter);
        this.createMethodSignature(methodText, methodName, fromType, toType, imports, lineDelimiter);
        try {
            methodText.append(CodeGeneration.getMethodBodyContent((ICompilationUnit)cu, (String)typeName, (String)methodName, (boolean)false, (String)"return null;", (String)lineDelimiter));
        }
        catch (CoreException coreException) {
            methodText.append("return null;");
        }
        methodText.append("}");
        type.createMethod(methodText.toString(), null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private String createTransformMethodName(TypeHelper fromType, TypeHelper toType, Collection<String> names) {
        String baseName;
        String name = baseName = "transform" + this.getSimpleTypeName(fromType) + "To" + this.getSimpleTypeName(toType);
        int count = 1;
        while (names.contains(name)) {
            name = String.valueOf(baseName) + count++;
        }
        names.add(name);
        return name;
    }

    private String getSimpleTypeName(TypeHelper type) {
        int lastDot;
        String name = type._annotationType == null ? ((lastDot = type._methodType.lastIndexOf(46)) >= 0 ? type._methodType.substring(lastDot + 1) : type._methodType) : QName.valueOf(type._annotationType).getLocalPart();
        if (name.length() == 0) {
            name = "_";
        } else if (Character.isLowerCase(name.charAt(0))) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        return name;
    }

    private void createMethodAnnotation(StringBuffer methodText, TypeHelper fromType, TypeHelper toType, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
        methodText.append("@").append(imports.addImport("org.switchyard.annotations.Transformer"));
        if (fromType._annotationType != null) {
            methodText.append("(from=\"").append(fromType._annotationType).append('\"');
            if (toType._annotationType != null) {
                methodText.append(", to=\"").append(toType._annotationType).append('\"');
            }
            methodText.append(")");
        } else if (toType._annotationType != null) {
            methodText.append("(to=\"").append(toType._annotationType).append("\")");
        }
        methodText.append(lineDelimiter);
    }

    private void createMethodSignature(StringBuffer methodText, String methodName, TypeHelper fromType, TypeHelper toType, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
        methodText.append("public ").append(imports.addImport(toType._methodType)).append(" ").append(methodName).append("(").append(imports.addImport(fromType._methodType)).append(" from) {").append(lineDelimiter);
    }

    private final class TypeHelper {
        private String _annotationType;
        private String _methodType;

        private TypeHelper(QName type) {
            if (type.getLocalPart().startsWith("java:")) {
                this._methodType = type.getLocalPart().substring(5);
                this._annotationType = null;
            } else {
                this._methodType = NewJavaTransformerClassPage.this._xmlESBType;
                this._annotationType = type.toString();
            }
        }
    }

    private final class XMLESBTypeComboViewer
    extends ComboViewer {
        private XMLESBTypeComboViewer(Composite parent) {
            super(parent, 4);
            this.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)XMLESBTypeComboViewer.this, XMLESBTypeComboViewer.this.getSelection());
                    XMLESBTypeComboViewer.this.fireSelectionChanged(event);
                }
            });
        }

        protected List<?> getSelectionFromWidget() {
            if (this.getCombo().getSelectionIndex() < 0) {
                ArrayList<String> selected = new ArrayList<String>();
                try {
                    selected.add(this.getCombo().getText());
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
                return selected;
            }
            return super.getSelectionFromWidget();
        }

        protected void setSelectionToWidget(ISelection selection, boolean reveal) {
            if (!selection.isEmpty() && XML_ESB_TYPES != null) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (!XML_ESB_TYPES.contains(obj)) {
                    this.getCombo().setText(obj.toString());
                    return;
                }
            }
            super.setSelectionToWidget(selection, reveal);
        }
    }
}

