/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.switchyard.ExchangePattern;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.switchyard.impl.TransformTypeImpl;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.model.merge.SwitchYardMergedModelAdapter;

public class TransformDetails {
    private SwitchYardType _switchYard;
    private SortedSet<TransformType> _transforms = new TreeSet<TransformType>(new TranformTypeComparator());
    private NavigableMap<TransformType, Set<String>> _required = new TreeMap<TransformType, Set<String>>(new TranformTypeComparator());

    public TransformDetails(SwitchYardType switchYard) throws Exception {
        this._switchYard = switchYard;
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader((IJavaProject)JavaCore.create((IProject)PlatformResourceAdapterFactory.getContainingProject((Object)switchYard)), null));
        try {
            this.collectProvidedTransforms();
            this.collectRequiredTransforms(switchYard);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    public TransformDetails(SwitchYardType switchYard, Contract source, Contract target) throws Exception {
        this._switchYard = switchYard;
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader((IJavaProject)JavaCore.create((IProject)PlatformResourceAdapterFactory.getContainingProject((Object)switchYard)), (ClassLoader)this.getClass().getClassLoader()));
        try {
            this.collectProvidedTransforms();
            this.collectRequiredTransforms(source, target);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    public SwitchYardType getSwitchYard() {
        return this._switchYard;
    }

    public SortedSet<TransformType> getDeclaredTransforms() {
        return Collections.unmodifiableSortedSet(this._transforms);
    }

    public SortedSet<TransformType> getRequiredTransforms() {
        return Collections.unmodifiableSortedSet(this._required.navigableKeySet());
    }

    public Set<String> getTransformDetails(TransformType transform) {
        return (Set)this._required.get(transform);
    }

    private void collectProvidedTransforms() {
        SwitchYardMergedModelAdapter switchYardAdapter = (SwitchYardMergedModelAdapter)EcoreUtil.getRegisteredAdapter((EObject)this._switchYard, SwitchYardMergedModelAdapter.class);
        if (switchYardAdapter == null) {
            return;
        }
        this._transforms.addAll(switchYardAdapter.getTransforms());
    }

    private void collectRequiredTransforms(SwitchYardType switchYard) {
        SwitchyardSCAEditor editor = SwitchyardSCAEditor.getEditor((EObject)switchYard);
        if (editor == null) {
            return;
        }
        Diagram diagram = editor.getDiagramTypeProvider().getDiagram();
        IFeatureProvider featureProvider = editor.getDiagramTypeProvider().getFeatureProvider();
        for (Connection connection : diagram.getConnections()) {
            Object sourceBO = featureProvider.getBusinessObjectForPictogramElement((PictogramElement)connection.getStart());
            Object targetBO = featureProvider.getBusinessObjectForPictogramElement((PictogramElement)connection.getEnd());
            if (!(sourceBO instanceof Contract) || !(targetBO instanceof Contract)) continue;
            this.collectRequiredTransforms((Contract)sourceBO, (Contract)targetBO);
        }
    }

    private void collectRequiredTransforms(Contract sourceBO, Contract targetBO) {
        try {
            ServiceInterface target;
            ServiceInterface source = sourceBO.getInterface() == null ? null : SwitchYardModelUtils.getServiceInterface((Interface)sourceBO.getInterface());
            ServiceInterface serviceInterface = target = targetBO.getInterface() == null ? null : SwitchYardModelUtils.getServiceInterface((Interface)targetBO.getInterface());
            if (source.getOperations().size() == 1 && target.getOperations().size() == 1) {
                this.collectRequiredTransforms(sourceBO.getName(), targetBO.getName(), (ServiceOperation)source.getOperations().iterator().next(), (ServiceOperation)target.getOperations().iterator().next());
            } else {
                for (ServiceOperation operation : source.getOperations()) {
                    this.collectRequiredTransforms(sourceBO.getName(), targetBO.getName(), operation, target.getOperation(operation.getName()));
                }
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    private void collectRequiredTransforms(String sourceServiceName, String targetServiceName, ServiceOperation source, ServiceOperation target) {
        if (source == null || target == null) {
            return;
        }
        if (source.getInputType() != null && target.getInputType() != null && !source.getInputType().equals(target.getInputType())) {
            this.addRequiredMapping((TransformType)new MissingTransformType(source.getInputType(), target.getInputType()), TransformDetails.createOperationDetails(sourceServiceName, targetServiceName, source.getName(), target.getName(), MapType.Input));
        }
        if (source.getExchangePattern() == ExchangePattern.IN_OUT) {
            if (source.getOutputType() != null && target.getOutputType() != null && !source.getOutputType().equals(target.getOutputType())) {
                this.addRequiredMapping((TransformType)new MissingTransformType(target.getOutputType(), source.getOutputType()), TransformDetails.createOperationDetails(sourceServiceName, targetServiceName, source.getName(), target.getName(), MapType.Output));
            }
            if (source.getFaultType() != null && target.getFaultType() != null && !source.getFaultType().equals(target.getFaultType())) {
                this.addRequiredMapping((TransformType)new MissingTransformType(target.getFaultType(), source.getFaultType()), TransformDetails.createOperationDetails(sourceServiceName, targetServiceName, source.getName(), target.getName(), MapType.Fault));
            }
        }
    }

    private void addRequiredMapping(TransformType transform, String detail) {
        LinkedHashSet<String> details = (LinkedHashSet<String>)this._required.get(transform);
        if (details == null) {
            details = new LinkedHashSet<String>();
            this._required.put(transform, details);
        }
        details.add(detail);
    }

    private static String createOperationDetails(String invokingServiceName, String targetServiceName, String invokingOperationName, String targetOperationName, MapType type) {
        return (Object)((Object)type) + ": " + invokingServiceName + "." + invokingOperationName + (type == MapType.Input ? "() => " : "() <=") + targetServiceName + "." + targetOperationName + "()";
    }

    private static enum MapType {
        Input,
        Output,
        Fault;

    }

    private final class MissingTransformType
    extends TransformTypeImpl {
        public MissingTransformType(QName from, QName to) {
            this.setFrom(from == null ? null : from.toString());
            this.setTo(to == null ? null : to.toString());
        }
    }

    private static final class TranformTypeComparator
    implements Comparator<TransformType> {
        private TranformTypeComparator() {
        }

        @Override
        public int compare(TransformType t1, TransformType t2) {
            int retVal = this.compareValues(t1.getFrom(), t2.getFrom());
            if (retVal == 0) {
                retVal = this.compareValues(t1.getTo(), t2.getTo());
            }
            return retVal;
        }

        private int compareValues(String s1, String s2) {
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }
}

