/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.switchyard.tools.models.switchyard1_0.bean.BeanImplementationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMImplementationType;
import org.switchyard.tools.models.switchyard1_0.camel.CamelImplementationType;
import org.switchyard.tools.models.switchyard1_0.clojure.ClojureImplementationType;
import org.switchyard.tools.models.switchyard1_0.rules.ManifestType;
import org.switchyard.tools.models.switchyard1_0.rules.ResourceType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesImplementationType;
import org.switchyard.tools.models.switchyard1_0.transform.JavaTransformType1;
import org.switchyard.tools.models.switchyard1_0.transform.SmooksTransformType1;
import org.switchyard.tools.models.switchyard1_0.transform.XsltTransformType;
import org.switchyard.tools.ui.SwitchYardModelUtils;

public class PlatformResourceAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_LIST = new Class[]{IResource.class, IFile.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!adapterType.isAssignableFrom(IFile.class)) {
            return null;
        }
        if (adaptableObject instanceof Component) {
            Component component = (Component)adaptableObject;
            return component.getImplementation() == null ? null : Platform.getAdapterManager().loadAdapter((Object)component.getImplementation(), adapterType.getCanonicalName());
        }
        IProject project = PlatformResourceAdapterFactory.getContainingProject(adaptableObject);
        if (project == null) {
            return null;
        }
        return PlatformResourceAdapterFactory.getFileForObject(adaptableObject, project);
    }

    public static IFile getFileForObject(Object adaptableObject, IProject project) {
        if (adaptableObject instanceof Implementation) {
            Implementation impl = (Implementation)adaptableObject;
            if (impl instanceof BeanImplementationType) {
                return (IFile)SwitchYardModelUtils.getJavaType(project, ((BeanImplementationType)impl).getClass_());
            }
            if (impl instanceof BPMImplementationType) {
                org.switchyard.tools.models.switchyard1_0.bpm.ManifestType manifest = ((BPMImplementationType)impl).getManifest();
                if (manifest == null || manifest.getResources() == null) {
                    return null;
                }
                Iterator iterator = manifest.getResources().getResource().iterator();
                if (iterator.hasNext()) {
                    org.switchyard.tools.models.switchyard1_0.bpm.ResourceType resource = (org.switchyard.tools.models.switchyard1_0.bpm.ResourceType)iterator.next();
                    return (IFile)SwitchYardModelUtils.getJavaResource(project, resource.getLocation());
                }
                return null;
            }
            if (impl instanceof RulesImplementationType) {
                ManifestType manifest = ((RulesImplementationType)impl).getManifest();
                if (manifest == null || manifest.getResources() == null) {
                    return null;
                }
                Iterator iterator = manifest.getResources().getResource().iterator();
                if (iterator.hasNext()) {
                    ResourceType resource = (ResourceType)iterator.next();
                    return (IFile)SwitchYardModelUtils.getJavaResource(project, resource.getLocation());
                }
                return null;
            }
            if (impl instanceof CamelImplementationType) {
                CamelImplementationType camelImpl = (CamelImplementationType)impl;
                if (camelImpl.getJava() != null) {
                    return (IFile)SwitchYardModelUtils.getJavaType(project, camelImpl.getJava().getClass_());
                }
                if (camelImpl.getXml() != null) {
                    return (IFile)SwitchYardModelUtils.getJavaResource(project, camelImpl.getXml().getPath());
                }
                return null;
            }
            if (impl instanceof ClojureImplementationType) {
                return (IFile)SwitchYardModelUtils.getJavaResource(project, ((ClojureImplementationType)impl).getScript());
            }
            return null;
        }
        if (adaptableObject instanceof Service) {
            Service service = (Service)adaptableObject;
            if (service.getInterface() == null) {
                if (service.getPromote() == null) {
                    return null;
                }
                if (service.getPromote() == null) {
                    return null;
                }
                return PlatformResourceAdapterFactory.getFileForObject(service.getPromote(), project);
            }
            return PlatformResourceAdapterFactory.getFileForObject(service.getInterface(), project);
        }
        if (adaptableObject instanceof Reference) {
            Reference reference = (Reference)adaptableObject;
            if (reference.getInterface() == null) {
                if (reference.getPromote() == null) {
                    return null;
                }
                for (ComponentReference promoted : reference.getPromote()) {
                    if (promoted.getInterface() == null) continue;
                    return PlatformResourceAdapterFactory.getFileForObject(promoted, project);
                }
                return null;
            }
            return PlatformResourceAdapterFactory.getFileForObject(reference.getInterface(), project);
        }
        if (adaptableObject instanceof ComponentService) {
            ComponentService service = (ComponentService)adaptableObject;
            if (service.getInterface() == null) {
                return null;
            }
            return PlatformResourceAdapterFactory.getFileForObject(service.getInterface(), project);
        }
        if (adaptableObject instanceof ComponentReference) {
            ComponentReference reference = (ComponentReference)adaptableObject;
            if (reference.getInterface() == null) {
                return null;
            }
            return PlatformResourceAdapterFactory.getFileForObject(reference.getInterface(), project);
        }
        if (adaptableObject instanceof JavaInterface) {
            return (IFile)SwitchYardModelUtils.getJavaType(project, ((JavaInterface)adaptableObject).getInterface());
        }
        if (adaptableObject instanceof WSDLPortType) {
            return (IFile)SwitchYardModelUtils.getJavaResource(project, ((WSDLPortType)adaptableObject).getInterface());
        }
        if (adaptableObject instanceof JavaTransformType1) {
            return (IFile)SwitchYardModelUtils.getJavaType(project, ((JavaTransformType1)adaptableObject).getClass_());
        }
        if (adaptableObject instanceof SmooksTransformType1) {
            return (IFile)SwitchYardModelUtils.getJavaResource(project, ((SmooksTransformType1)adaptableObject).getConfig());
        }
        if (adaptableObject instanceof XsltTransformType) {
            return (IFile)SwitchYardModelUtils.getJavaResource(project, ((XsltTransformType)adaptableObject).getXsltFile());
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public static IProject getContainingProject(Object obj) {
        if (!(obj instanceof EObject)) {
            return null;
        }
        Resource objectResource = ((EObject)obj).eResource();
        if (objectResource == null) {
            return null;
        }
        for (Resource resource : objectResource.getResourceSet() == null ? Collections.singleton(objectResource) : objectResource.getResourceSet().getResources()) {
            URI uri = resource.getURI();
            if (uri.isPlatformResource()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                if (file == null) {
                    return null;
                }
                return file.getProject();
            }
            if (!uri.isFile()) continue;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
            if (file == null) {
                return null;
            }
            return file.getProject();
        }
        return null;
    }
}

