/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.i18n.Messages;

public class ContractControl
implements ISelectionProvider {
    private Contract _service;
    private boolean _enabled = true;
    private InterfaceControl _interfaceControl;
    private String _oldServiceName;
    private Text _serviceNameText;
    private Set<ISelectionChangedListener> _listeners = new LinkedHashSet<ISelectionChangedListener>();
    private boolean _updating;

    public ContractControl(EClass contractType, IJavaProject project, Set<InterfaceControl.InterfaceType> supportedTypes) {
        if (!contractType.getEAllSuperTypes().contains((Object)ScaPackage.eINSTANCE.getContract())) {
            throw new IllegalArgumentException(String.valueOf(Messages.ContractControl_errorContractTypeMustExtendContract) + contractType.getName());
        }
        this._service = (Contract)contractType.getEPackage().getEFactoryInstance().create(contractType);
        this._interfaceControl = new InterfaceControl(project, supportedTypes);
        this._interfaceControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ContractControl.this._updating) {
                    return;
                }
                Interface intf = ContractControl.this._interfaceControl.getInterface();
                ContractControl.this._service.getInterfaceGroup().clear();
                if (intf != null) {
                    ContractControl.this._service.setInterface(intf);
                    String newName = InterfaceControl.getSimpleServiceInterfaceName(intf);
                    String currentName = ContractControl.this._service.getName();
                    if (ContractControl.this.updateDefault(ContractControl.this._oldServiceName, newName, currentName)) {
                        if (ContractControl.this._serviceNameText == null) {
                            ContractControl.this._service.setName(newName);
                        } else {
                            ContractControl.this._serviceNameText.setText(newName == null ? "" : newName);
                        }
                        ContractControl.this._oldServiceName = newName;
                        return;
                    }
                    ContractControl.this._oldServiceName = newName;
                    ContractControl.this.fireSelectionChanged();
                }
            }
        });
    }

    public void createControl(Composite parent, int numColumns) {
        Interface intf;
        this._interfaceControl.createControl(parent, numColumns);
        Label label = new Label(parent, 0);
        label.setText(Messages.ContractControl_labelServiceName);
        this._serviceNameText = new Text(parent, 2052);
        this._serviceNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, numColumns - 2, 1));
        this._serviceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String name = ContractControl.this._serviceNameText.getText();
                ContractControl.this._service.setName(name.length() == 0 ? null : name);
                ContractControl.this.fireSelectionChanged();
            }
        });
        new Label(parent, 0);
        if (this._service != null && this._service.getName() != null) {
            this._serviceNameText.setText(this._service.getName());
        }
        if ((intf = this._interfaceControl.getInterface()) != null) {
            this._service.setInterface(intf);
        }
        this.setEnabled(this._enabled);
    }

    public void setSupportedInterfaceTypes(Set<InterfaceControl.InterfaceType> supportedTypes) {
        this._interfaceControl.setSupportedTypes(supportedTypes);
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        if (this._serviceNameText == null) {
            return;
        }
        this._serviceNameText.setEnabled(this._enabled);
        this._interfaceControl.setEnabled(this._enabled);
    }

    public void init(Contract contract, Contract related) {
        if (contract == null) {
            return;
        }
        this._updating = true;
        try {
            this._oldServiceName = InterfaceControl.getSimpleServiceInterfaceName(contract.getInterface());
            if (this._serviceNameText == null) {
                this._service.setName(contract.getName());
            } else if (contract.getName() != null) {
                this._serviceNameText.setText(contract.getName());
            }
            this._interfaceControl.init(contract.getInterface(), related == null ? null : related.getInterface());
        }
        finally {
            this._updating = false;
        }
    }

    public void setInterface(Interface intf) {
        if (intf == null) {
            return;
        }
        this._interfaceControl.init(intf, null);
    }

    public IStatus getStatus() {
        if (!this._enabled) {
            return Status.OK_STATUS;
        }
        IStatus status = this._interfaceControl.getStatus();
        if (status.getSeverity() != 4 && this._service.getName() == null) {
            return new Status(4, "org.switchyard.tools.ui", Messages.ContractControl_validateMessageMustSpecifyName);
        }
        return status;
    }

    public void setProject(IJavaProject project) {
        this._interfaceControl.setProject(project);
    }

    public Contract getContract() {
        return this._service;
    }

    public ISelection getSelection() {
        if (this._service == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this._service);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        this._service = (Contract)((IStructuredSelection)selection).getFirstElement();
        this.init(this._service, null);
    }

    private void fireSelectionChanged() {
        LinkedHashSet<ISelectionChangedListener> listeners = new LinkedHashSet<ISelectionChangedListener>(this._listeners);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : listeners) {
            try {
                listener.selectionChanged(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean updateDefault(String oldValue, String newValue, String currentValue) {
        return currentValue == null || currentValue.length() == 0 || !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || oldValue.equals(currentValue));
    }

    public InterfaceControl getInterfaceControl() {
        return this._interfaceControl;
    }
}

