/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.M2EUtils;
import org.switchyard.tools.ui.common.ILayoutUtilities;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.facets.ISwitchYardFacetConstants;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardSettingsGroup {
    public static final Object NULL_RUNTIME = new Object();
    private IRunnableContext _context;
    private ComboViewer _runtimesList;
    private ComboViewer _runtimeVersionsList;
    private ComboViewer _configVersionsList;
    private ComboViewer _kieVersionsList;
    private ComboViewer _integVersionsList;
    private Button _configureBxMSVersionDetailsCheckbox;
    private Button _runtimeProvidedCheckbox;
    private CheckboxTreeViewer _componentsTable;
    private Text _descriptionText;
    private IRuntimeComponent _initialComponent;
    private List<Object> _compatibleRuntimes;
    private Set<ArtifactVersion> _availableVersions;
    private Set<ArtifactVersion> _availableKieVersions;
    private Set<ArtifactVersion> _availableIntegVersions;
    private boolean _isInitialized = false;
    private IFacetedProjectWorkingCopy _project;
    private IFacetedProjectListener _projectListener = new IFacetedProjectListener(){

        public void handleEvent(IFacetedProjectEvent event) {
            switch (event.getType()) {
                case PROJECT_FACETS_CHANGED: {
                    SwitchYardSettingsGroup.this._configVersionsList.setSelection((ISelection)new StructuredSelection((Object)SwitchYardSettingsGroup.this._project.getProjectFacetVersion(ISwitchYardFacetConstants.SWITCHYARD_FACET)), true);
                }
                case TARGETABLE_RUNTIMES_CHANGED: {
                    SwitchYardSettingsGroup.this.repopulateRuntimesList();
                    break;
                }
            }
        }
    };
    private ViewerFilter _runtimesFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element == NULL_RUNTIME) {
                return true;
            }
            if (SwitchYardSettingsGroup.this._project == null) {
                IRuntime runtime = ((IRuntimeComponent)element).getRuntime();
                return runtime.supports(SwitchYardSettingsGroup.this.getSelectedConfigurationVersion());
            }
            IRuntime runtime = ((IRuntimeComponent)element).getRuntime();
            for (IProjectFacetVersion ipfv : SwitchYardSettingsGroup.this._project.getProjectFacets()) {
                if (runtime.supports(ipfv)) continue;
                return false;
            }
            return true;
        }
    };
    private ListenerList _changeListeners;

    public SwitchYardSettingsGroup(Composite parent, ILayoutUtilities layoutUtilities, IRunnableContext context) {
        this._context = context;
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createRuntimeControls(content);
        this.createBxMSIntegrationControls(content);
        this.createComponentControls(content);
        this.initControls();
    }

    private void createBxMSIntegrationControls(Composite content) {
        this._configureBxMSVersionDetailsCheckbox = new Button(content, 32);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        this._configureBxMSVersionDetailsCheckbox.setLayoutData((Object)gd);
        this._configureBxMSVersionDetailsCheckbox.setText(Messages.SwitchYardSettingsGroup_Integration_Pack_Version_Checkbox);
        this._configureBxMSVersionDetailsCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SwitchYardSettingsGroup.this._configureBxMSVersionDetailsCheckbox.getSelection()) {
                    SwitchYardSettingsGroup.this.handleRuntimeSelected();
                } else {
                    SwitchYardSettingsGroup.this._kieVersionsList.setSelection((ISelection)new StructuredSelection((Object)""));
                    SwitchYardSettingsGroup.this._kieVersionsList.getCombo().setEnabled(false);
                    SwitchYardSettingsGroup.this._integVersionsList.setSelection((ISelection)new StructuredSelection((Object)""));
                    SwitchYardSettingsGroup.this._integVersionsList.getCombo().setEnabled(false);
                    SwitchYardSettingsGroup.this.fireChangedEvent(this);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group integControls = new Group(content, 0);
        integControls.setLayout((Layout)new GridLayout(2, false));
        integControls.setLayoutData((Object)new GridData(768));
        integControls.setText(Messages.SwitchYardSettingsGroup_Integration_Pack_Group_Label);
        Label label = new Label((Composite)integControls, 0);
        label.setText(Messages.SwitchYardSettingsGroup_Kie_Version_Label);
        this._kieVersionsList = new VersionComboViewer((Composite)integControls);
        this._kieVersionsList.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        this._kieVersionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._kieVersionsList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._kieVersionsList.getCombo().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwitchYardSettingsGroup.this.fireChangedEvent(this);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)integControls, 0);
        label.setText(Messages.SwitchYardSettingsGroup_Integration_Pack_Version_Label);
        this._integVersionsList = new VersionComboViewer((Composite)integControls);
        this._integVersionsList.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        this._integVersionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._integVersionsList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._integVersionsList.getCombo().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwitchYardSettingsGroup.this.fireChangedEvent(this);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createRuntimeControls(Composite content) {
        Group runtimeControls = new Group(content, 0);
        runtimeControls.setLayout((Layout)new GridLayout(3, false));
        runtimeControls.setLayoutData((Object)new GridData(768));
        runtimeControls.setText(Messages.SwitchYardSettingsGroup_VersionDetailsGroup);
        Label label = new Label((Composite)runtimeControls, 0);
        label.setText(Messages.SwitchYardSettingsGroup_ConfigurationVersionLabel);
        this._configVersionsList = new ComboViewer((Composite)runtimeControls);
        this._configVersionsList.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        this._configVersionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IProjectFacetVersion)element).getVersionString();
            }
        });
        this._configVersionsList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._configVersionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SwitchYardSettingsGroup.this.handleConfigVersionSelected();
            }
        });
        this._configVersionsList.setInput((Object)ISwitchYardFacetConstants.SWITCHYARD_FACET.getVersions());
        new Label((Composite)runtimeControls, 0);
        label = new Label((Composite)runtimeControls, 0);
        label.setText(Messages.SwitchYardSettingsGroup_TargetRuntimeLabel);
        this._runtimesList = new ComboViewer((Composite)runtimeControls);
        this._runtimesList.getCombo().setLayoutData((Object)new GridData(768));
        this._runtimesList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRuntimeComponent) {
                    IRuntimeComponent component = (IRuntimeComponent)element;
                    StringBuffer text = new StringBuffer(((IRuntimeComponentLabelProvider)IRuntimeComponentLabelProvider.class.cast(component.getAdapter(IRuntimeComponentLabelProvider.class))).getLabel());
                    text.append(" [").append(component.getRuntime().getName()).append("]");
                    return text.toString();
                }
                return Messages.SwitchYardSettingsGroup_EmptyRuntimeComponentLabel;
            }
        });
        this._runtimesList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._runtimesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SwitchYardSettingsGroup.this.handleRuntimeSelected();
            }
        });
        this._runtimesList.setSorter((ViewerSorter)new RuntimesListSorter());
        this._runtimesList.addFilter(this._runtimesFilter);
        this._runtimesList.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (SwitchYardSettingsGroup.this._project != null) {
                    SwitchYardSettingsGroup.this._project.removeListener(SwitchYardSettingsGroup.this._projectListener);
                }
            }
        });
        final Link newRuntimeLink = new Link((Composite)runtimeControls, 0);
        newRuntimeLink.setText(Messages.SwitchYardSettingsGroup_RuntimeLinkLabel);
        newRuntimeLink.setEnabled(true);
        newRuntimeLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String id = "org.eclipse.wst.server.ui.preferencePage";
                String id2 = "org.eclipse.wst.server.ui.runtime.preferencePage";
                String id3 = "org.jboss.tools.runtime.preferences.RuntimePreferencePage";
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)newRuntimeLink.getShell(), (String)id2, (String[])new String[]{id, id2, id3}, null);
                if (dialog.open() == 0) {
                    SwitchYardSettingsGroup.this.repopulateRuntimesList();
                }
            }
        });
        label = new Label((Composite)runtimeControls, 0);
        label.setText(Messages.SwitchYardSettingsGroup_LibraryVersionLabel);
        this._runtimeVersionsList = new VersionComboViewer((Composite)runtimeControls);
        this._runtimeVersionsList.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        this._runtimeVersionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._runtimeVersionsList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._runtimeVersionsList.getCombo().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwitchYardSettingsGroup.this.fireChangedEvent(this);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)runtimeControls, 0);
    }

    private void createComponentControls(Composite content) {
        Group componentControls = new Group(content, 0);
        componentControls.setLayout((Layout)new GridLayout());
        componentControls.setLayoutData((Object)new GridData(4, 4, true, true));
        componentControls.setText(Messages.SwitchYardSettingsGroup_SYComponentsGroupLabel);
        this._componentsTable = new CheckboxTreeViewer((Composite)componentControls, 2564);
        this._componentsTable.setLabelProvider((IBaseLabelProvider)new ComponentsLabelProvider());
        this._componentsTable.setContentProvider((IContentProvider)new ComponentsContentProvider());
        this._componentsTable.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this._componentsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = SwitchYardSettingsGroup.this._componentsTable.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    Object selected = ((IStructuredSelection)selection).getFirstElement();
                    if (selected instanceof ISwitchYardComponentExtension) {
                        String description = ((ISwitchYardComponentExtension)selected).getDescription();
                        if (description == null || description.length() == 0) {
                            description = Messages.SwitchYardSettingsGroup_ComponentUnavailableLabel;
                        }
                        SwitchYardSettingsGroup.this._descriptionText.setText(description);
                    } else {
                        SwitchYardSettingsGroup.this._descriptionText.setText("");
                    }
                } else {
                    SwitchYardSettingsGroup.this._descriptionText.setText("");
                }
            }
        });
        this._componentsTable.addFilter(new ViewerFilter(){
            private final Object _runtimeComponent = SwitchYardComponentExtensionManager.instance().getRuntimeComponentExtension();
            private final boolean _hasUnknownComponents = SwitchYardComponentExtensionManager.instance().getComponentExtensions(ISwitchYardComponentExtension.Category.UNKNOWN).size() > 1;

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element != this._runtimeComponent && (element != ISwitchYardComponentExtension.Category.UNKNOWN || this._hasUnknownComponents);
            }
        });
        this._componentsTable.setSorter((ViewerSorter)new ComponentsSorter());
        this._componentsTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SwitchYardSettingsGroup.this.updateCheckState(event.getElement(), event.getChecked());
            }
        });
        Group detailsGroup = new Group((Composite)componentControls, 0);
        detailsGroup.setText(Messages.SwitchYardSettingsGroup_DetailsGroup);
        detailsGroup.setLayout((Layout)new GridLayout());
        detailsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._descriptionText = new Text((Composite)detailsGroup, 586);
        GridData gd = new GridData(768);
        gd.heightHint = this._descriptionText.getLineHeight() * 3;
        this._descriptionText.setLayoutData((Object)gd);
    }

    public void setProject(IFacetedProjectWorkingCopy project) {
        if (this._project != null) {
            this._project.removeListener(this._projectListener);
        }
        this._project = project;
        this._runtimesList.refresh();
        if (this._project != null) {
            this._configVersionsList.setSelection((ISelection)new StructuredSelection((Object)this._project.getProjectFacetVersion(ISwitchYardFacetConstants.SWITCHYARD_FACET)), true);
            this._project.addListener(this._projectListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.TARGETABLE_RUNTIMES_CHANGED, IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
        }
    }

    public IRuntimeComponent getSelectedTargetRuntime() {
        IStructuredSelection selection = (IStructuredSelection)this._runtimesList.getSelection();
        if (selection == null || selection.isEmpty() || selection.getFirstElement() == NULL_RUNTIME) {
            return null;
        }
        return (IRuntimeComponent)selection.getFirstElement();
    }

    public IProjectFacetVersion getSelectedConfigurationVersion() {
        IStructuredSelection selection = (IStructuredSelection)this._configVersionsList.getSelection();
        if (selection == null || selection.isEmpty() || selection.getFirstElement() == NULL_RUNTIME) {
            return null;
        }
        return (IProjectFacetVersion)selection.getFirstElement();
    }

    public Set<ArtifactVersion> getAvailableVersions() {
        return this._availableVersions;
    }

    public CheckboxTreeViewer getComponentsTable() {
        return this._componentsTable;
    }

    public StructuredViewer getRuntimeVersionsList() {
        return this._runtimeVersionsList;
    }

    public StructuredViewer getIntegrationVersionsList() {
        return this._integVersionsList;
    }

    public StructuredViewer getKieVersionsList() {
        return this._kieVersionsList;
    }

    public Button getConfigureIntegrationCheckbox() {
        return this._configureBxMSVersionDetailsCheckbox;
    }

    public StructuredViewer getTargetRuntimesList() {
        return this._runtimesList;
    }

    public Button getRuntimeProvidedCheckbox() {
        return this._runtimeProvidedCheckbox;
    }

    public Set<ISwitchYardComponentExtension> getSelectedComponents() {
        LinkedHashSet<Object> selectedComponents = new LinkedHashSet<Object>(Arrays.asList(this._componentsTable.getCheckedElements()));
        selectedComponents.add(SwitchYardComponentExtensionManager.instance().getRuntimeComponentExtension());
        selectedComponents.removeAll(Arrays.asList(ISwitchYardComponentExtension.Category.values()));
        return selectedComponents;
    }

    public void setCheckedComponents(Set<ISwitchYardComponentExtension> components, boolean checked) {
        if (components == null || components.isEmpty() || this._componentsTable == null || this._componentsTable.getTree().isDisposed()) {
            return;
        }
        for (ISwitchYardComponentExtension component : components) {
            this._componentsTable.setChecked((Object)component, checked);
            this.updateCheckState(component, checked);
        }
    }

    private void handleConfigVersionSelected() {
        IStructuredSelection selection = (IStructuredSelection)this._configVersionsList.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (this._project != null) {
            this._project.changeProjectFacetVersion((IProjectFacetVersion)selection.getFirstElement());
        }
        this.repopulateRuntimesList();
        this.fireChangedEvent(this);
    }

    private void handleRuntimeSelected() {
        boolean updateInteg;
        IStructuredSelection selection = (IStructuredSelection)this._runtimesList.getSelection();
        if (selection != null && this.getSelectedTargetRuntime() != null) {
            boolean runtimeHasIntegInstalled = this.getIntegVersion(this.getSelectedTargetRuntime()) != null;
            this._configureBxMSVersionDetailsCheckbox.setEnabled(runtimeHasIntegInstalled);
            if (!runtimeHasIntegInstalled) {
                this._configureBxMSVersionDetailsCheckbox.setSelection(false);
            }
        } else {
            boolean enableIntegCheckbox = this._kieVersionsList.getCombo().getItemCount() > 0 && this._integVersionsList.getCombo().getItemCount() > 0;
            this._configureBxMSVersionDetailsCheckbox.setEnabled(enableIntegCheckbox);
        }
        if (!this._configureBxMSVersionDetailsCheckbox.isEnabled()) {
            this._kieVersionsList.setSelection((ISelection)new StructuredSelection((Object)""));
            this._kieVersionsList.getCombo().setEnabled(false);
            this._integVersionsList.setSelection((ISelection)new StructuredSelection((Object)""));
            this._integVersionsList.getCombo().setEnabled(false);
        }
        boolean bl = updateInteg = this._configureBxMSVersionDetailsCheckbox.getEnabled() && this._configureBxMSVersionDetailsCheckbox.getSelection();
        if (selection == null || selection.isEmpty() || selection.getFirstElement() == NULL_RUNTIME) {
            this._runtimeVersionsList.getCombo().setEnabled(true);
            this._kieVersionsList.getCombo().setEnabled(updateInteg);
            this._integVersionsList.getCombo().setEnabled(updateInteg);
        } else {
            ArtifactVersion version = this.getRuntimeVersion((IRuntimeComponent)selection.getFirstElement());
            if (version != null) {
                this._runtimeVersionsList.setSelection((ISelection)new StructuredSelection((Object)version));
            }
            this._runtimeVersionsList.getCombo().setEnabled(false);
            if (updateInteg) {
                ArtifactVersion kieVersion = this.getKieVersion((IRuntimeComponent)selection.getFirstElement());
                if (kieVersion != null) {
                    this._kieVersionsList.setSelection((ISelection)new StructuredSelection((Object)kieVersion));
                } else {
                    this._kieVersionsList.setSelection((ISelection)new StructuredSelection((Object)""));
                }
                ArtifactVersion integVersion = this.getIntegVersion((IRuntimeComponent)selection.getFirstElement());
                if (integVersion != null) {
                    this._integVersionsList.setSelection((ISelection)new StructuredSelection((Object)integVersion));
                } else {
                    this._integVersionsList.setSelection((ISelection)new StructuredSelection((Object)""));
                }
                this._kieVersionsList.getCombo().setEnabled(false);
                this._integVersionsList.getCombo().setEnabled(false);
            }
        }
        this.fireChangedEvent(this);
    }

    private ArtifactVersion getRuntimeVersion(IRuntimeComponent component) {
        return this.parseVersion(component.getProperty("switchyard.version"));
    }

    public ArtifactVersion getKieVersion(IRuntimeComponent component) {
        return this.parseVersion(component.getProperty("kie.version"));
    }

    public ArtifactVersion getIntegVersion(IRuntimeComponent component) {
        return this.parseVersion(component.getProperty("fuse.integ.version"));
    }

    public boolean hasIntegrationVersion(IRuntimeComponent component) {
        return this.getIntegVersion(component) != null;
    }

    private void initControls() {
        if (this._isInitialized) {
            return;
        }
        if (this._project == null) {
            this._configVersionsList.setSelection((ISelection)new StructuredSelection((Object)ISwitchYardFacetConstants.SWITCHYARD_FACET.getDefaultVersion()), true);
        } else {
            this._configVersionsList.setSelection((ISelection)new StructuredSelection((Object)this._project.getProjectFacetVersion(ISwitchYardFacetConstants.SWITCHYARD_FACET)), true);
        }
        try {
            this._context.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.SwitchYardSettingsGroup_LoadingAvailableCapabilitiesMessage, 100);
                    try {
                        boolean updateInteg;
                        SwitchYardSettingsGroup.this.populateComponentsTable();
                        monitor.worked(25);
                        SwitchYardSettingsGroup.this.populateRuntimesList();
                        monitor.worked(25);
                        SwitchYardSettingsGroup.this.populateRuntimeVersionsList((IProgressMonitor)new SubProgressMonitor(monitor, 15));
                        SwitchYardSettingsGroup.this.populateKieVersionsList((IProgressMonitor)new SubProgressMonitor(monitor, 15));
                        SwitchYardSettingsGroup.this.populateIntegVersionsList((IProgressMonitor)new SubProgressMonitor(monitor, 15));
                        if (SwitchYardSettingsGroup.this._kieVersionsList.getCombo().getItemCount() > 0 && SwitchYardSettingsGroup.this._integVersionsList.getCombo().getItemCount() > 0) {
                            SwitchYardSettingsGroup.this._configureBxMSVersionDetailsCheckbox.setEnabled(true);
                        } else {
                            SwitchYardSettingsGroup.this._configureBxMSVersionDetailsCheckbox.setEnabled(false);
                            SwitchYardSettingsGroup.this._configureBxMSVersionDetailsCheckbox.setSelection(false);
                        }
                        boolean bl = updateInteg = SwitchYardSettingsGroup.this._configureBxMSVersionDetailsCheckbox.getEnabled() && SwitchYardSettingsGroup.this._configureBxMSVersionDetailsCheckbox.getSelection();
                        if (SwitchYardSettingsGroup.this._initialComponent == null) {
                            SwitchYardSettingsGroup.this._runtimesList.setSelection((ISelection)new StructuredSelection(NULL_RUNTIME), true);
                            SwitchYardSettingsGroup.this._runtimeVersionsList.setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.this._availableVersions.iterator().next()));
                            if (updateInteg) {
                                SwitchYardSettingsGroup.this._kieVersionsList.setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.this._availableKieVersions.iterator().next()));
                                SwitchYardSettingsGroup.this._integVersionsList.setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.this._availableIntegVersions.iterator().next()));
                            }
                        } else {
                            SwitchYardSettingsGroup.this._runtimesList.setSelection((ISelection)new StructuredSelection((Object)SwitchYardSettingsGroup.this._initialComponent), true);
                            SwitchYardSettingsGroup.this._runtimeVersionsList.setSelection((ISelection)new StructuredSelection((Object)SwitchYardSettingsGroup.this._initialComponent));
                            if (updateInteg) {
                                SwitchYardSettingsGroup.this._kieVersionsList.setSelection((ISelection)new StructuredSelection((Object)SwitchYardSettingsGroup.this._initialComponent));
                                SwitchYardSettingsGroup.this._integVersionsList.setSelection((ISelection)new StructuredSelection((Object)SwitchYardSettingsGroup.this._initialComponent));
                            }
                            SwitchYardSettingsGroup.this._kieVersionsList.getControl().setEnabled(false);
                            SwitchYardSettingsGroup.this._integVersionsList.getControl().setEnabled(false);
                        }
                    }
                    finally {
                        monitor.done();
                        SwitchYardSettingsGroup.this._isInitialized = true;
                    }
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof CoreException) {
                Activator.getDefault().getLog().log((IStatus)new MultiStatus("org.switchyard.tools.ui", -1, new IStatus[]{((CoreException)e.getCause()).getStatus()}, Messages.SwitchYardSettingsGroup_ErrorLoadingCapabilitiesMessage, (Throwable)e));
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardSettingsGroup_ErrorLoadingCapabilitiesMessage, (Throwable)e));
        }
    }

    private void populateRuntimesList() {
        if (this._compatibleRuntimes == null) {
            LinkedHashSet<IRuntimeComponent> compatibleRuntimes = new LinkedHashSet<IRuntimeComponent>();
            for (IProjectFacetVersion ipfv : ISwitchYardFacetConstants.SWITCHYARD_FACET.getVersions()) {
                Set runtimes = RuntimeManager.getRuntimes(Collections.singleton(ipfv));
                RuntimesListSorter sorter = new RuntimesListSorter();
                block1: for (IRuntime runtime : runtimes) {
                    for (IRuntimeComponent component : runtime.getRuntimeComponents()) {
                        if (!"switchyard.runtime".equals(component.getRuntimeComponentType().getId()) && !"fuseServiceWorks.runtime".equals(component.getRuntimeComponentType().getId())) continue;
                        compatibleRuntimes.add(component);
                        if (!this._runtimesFilter.select(null, null, (Object)component)) continue block1;
                        if (this._initialComponent == null) {
                            this._initialComponent = component;
                            continue block1;
                        }
                        if (sorter.compare(null, component, this._initialComponent) >= 0) continue block1;
                        this._initialComponent = component;
                        continue block1;
                    }
                }
            }
            this._compatibleRuntimes = new ArrayList<Object>(compatibleRuntimes.size() + 1);
            this._compatibleRuntimes.add(NULL_RUNTIME);
            this._compatibleRuntimes.addAll(compatibleRuntimes);
        }
        this._runtimesList.setInput(this._compatibleRuntimes);
    }

    private void populateKieVersionsList(IProgressMonitor monitor) {
        try {
            this._availableKieVersions = this.filterSwitchYardVersions(M2EUtils.resolveKieVersionRange(monitor));
        }
        catch (Exception exception) {
            this._availableKieVersions = new LinkedHashSet<ArtifactVersion>();
        }
        ArtifactVersion defaultVersion = this.parseVersion("6.4.0.Final");
        this._availableKieVersions.add(defaultVersion);
        for (Object obj : (List)this._runtimesList.getInput()) {
            ArtifactVersion version;
            if (obj == NULL_RUNTIME || (version = this.getRuntimeVersion((IRuntimeComponent)obj)) == null || this._availableVersions.contains(version)) continue;
            this._availableKieVersions.add(version);
        }
        this._kieVersionsList.setInput(this._availableKieVersions);
    }

    private void populateIntegVersionsList(IProgressMonitor monitor) {
        try {
            this._availableIntegVersions = this.filterSwitchYardVersions(M2EUtils.resolveFuseIntegrationVersionRange(monitor));
        }
        catch (Exception exception) {
            this._availableIntegVersions = new LinkedHashSet<ArtifactVersion>();
        }
        ArtifactVersion defaultVersion = this.parseVersion("1.4.0.redhat-621043");
        this._availableIntegVersions.add(defaultVersion);
        for (Object obj : (List)this._runtimesList.getInput()) {
            ArtifactVersion version;
            if (obj == NULL_RUNTIME || (version = this.getRuntimeVersion((IRuntimeComponent)obj)) == null || this._availableVersions.contains(version)) continue;
            this._availableIntegVersions.add(version);
        }
        this._integVersionsList.setInput(this._availableIntegVersions);
    }

    private void populateRuntimeVersionsList(IProgressMonitor monitor) {
        try {
            this._availableVersions = this.filterSwitchYardVersions(M2EUtils.resolveSwitchYardVersionRange(monitor));
        }
        catch (Exception exception) {
            this._availableVersions = new LinkedHashSet<ArtifactVersion>();
        }
        ArtifactVersion defaultVersion = this.parseVersion("2.1.0.Final");
        this._availableVersions.add(defaultVersion);
        for (Object obj : (List)this._runtimesList.getInput()) {
            ArtifactVersion version;
            if (obj == NULL_RUNTIME || (version = this.getRuntimeVersion((IRuntimeComponent)obj)) == null || this._availableVersions.contains(version)) continue;
            this._availableVersions.add(version);
        }
        this._runtimeVersionsList.setInput(this._availableVersions);
    }

    private Set<ArtifactVersion> filterSwitchYardVersions(List<ArtifactVersion> versions) {
        LinkedHashSet<ArtifactVersion> filtered = new LinkedHashSet<ArtifactVersion>();
        String previousMajorMinor = null;
        boolean previousWasSnapshot = false;
        ListIterator<ArtifactVersion> it = versions.listIterator(versions.size());
        while (it.hasPrevious()) {
            ArtifactVersion next = it.previous();
            String version = next.toString();
            String majorMinor = this.getMajorMinor(version);
            try {
                if (previousMajorMinor == null) {
                    filtered.add(next);
                    previousWasSnapshot = version.endsWith("-SNAPSHOT");
                    continue;
                }
                if (version.endsWith("-SNAPSHOT")) {
                    previousWasSnapshot = true;
                    continue;
                }
                if (previousMajorMinor.equals(majorMinor) && !previousWasSnapshot) continue;
                filtered.add(next);
                previousWasSnapshot = false;
                if (!"1.0".equals(majorMinor)) continue;
                break;
            }
            finally {
                previousMajorMinor = majorMinor;
            }
        }
        return filtered;
    }

    private String getMajorMinor(String version) {
        int secondDot;
        int firstDot = version.indexOf(46);
        int n = secondDot = firstDot < 0 ? -1 : version.indexOf(46, firstDot + 1);
        if (secondDot < 0) {
            return version;
        }
        return version.substring(0, secondDot);
    }

    private void populateComponentsTable() {
        this._componentsTable.setInput((Object)SwitchYardComponentExtensionManager.instance());
        this._componentsTable.setExpandedElements(EnumSet.of(ISwitchYardComponentExtension.Category.IMPLEMENTATION).toArray());
    }

    private void updateCheckState(Object element, boolean checked) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this._componentsTable.getContentProvider();
        this._componentsTable.setSubtreeChecked(element, checked);
        this._componentsTable.setGrayed(element, false);
        Object parent = contentProvider.getParent(element);
        Object input = this._componentsTable.getInput();
        while (parent != null && parent != input) {
            Object[] siblings = contentProvider.getChildren(parent);
            int count = 0;
            int i = 0;
            while (i < siblings.length) {
                if (this._componentsTable.getChecked(siblings[i])) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                this._componentsTable.setGrayChecked(parent, false);
            } else if (count == siblings.length) {
                this._componentsTable.setChecked(parent, true);
                this._componentsTable.setGrayed(parent, false);
            } else {
                this._componentsTable.setGrayChecked(parent, true);
            }
            parent = contentProvider.getParent(parent);
        }
    }

    private ArtifactVersion parseVersion(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return new DefaultArtifactVersion(text);
    }

    private void repopulateRuntimesList() {
        this._runtimesList.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IStructuredSelection selection = (IStructuredSelection)SwitchYardSettingsGroup.this._runtimesList.getSelection();
                SwitchYardSettingsGroup.this._initialComponent = null;
                SwitchYardSettingsGroup.this._compatibleRuntimes = null;
                SwitchYardSettingsGroup.this.populateRuntimesList();
                if (selection.isEmpty() || !SwitchYardSettingsGroup.this._runtimesFilter.select(null, null, selection.getFirstElement())) {
                    if (SwitchYardSettingsGroup.this._initialComponent == null) {
                        SwitchYardSettingsGroup.this._runtimesList.setSelection((ISelection)new StructuredSelection(NULL_RUNTIME), true);
                    } else {
                        SwitchYardSettingsGroup.this._runtimesList.setSelection((ISelection)new StructuredSelection((Object)SwitchYardSettingsGroup.this._initialComponent), true);
                    }
                } else {
                    SwitchYardSettingsGroup.this._runtimesList.setSelection((ISelection)selection, true);
                }
            }
        });
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        if (this._changeListeners != null && !this._changeListeners.isEmpty()) {
            Object[] listeners = this._changeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ChangeListener)listeners[i]).stateChanged(e);
                ++i;
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this._changeListeners == null) {
            this._changeListeners = new ListenerList();
        }
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this._changeListeners != null && !this._changeListeners.isEmpty()) {
            this._changeListeners.remove((Object)listener);
        }
    }

    public void setRuntimeControlEnablement(boolean value) {
        this._configVersionsList.getCombo().setEnabled(value);
        this._runtimesList.getCombo().setEnabled(value);
        this._runtimeVersionsList.getCombo().setEnabled(value);
        this._kieVersionsList.getCombo().setEnabled(value);
        this._integVersionsList.getCombo().setEnabled(value);
        this._configureBxMSVersionDetailsCheckbox.setEnabled(value);
    }

    public ArtifactVersion getIntegrationVersion() {
        ISelection integrationVersionListSelection = this._integVersionsList.getSelection();
        if (integrationVersionListSelection.isEmpty()) {
            return null;
        }
        return (ArtifactVersion)((IStructuredSelection)integrationVersionListSelection).getFirstElement();
    }

    public ArtifactVersion getKieVersion() {
        ISelection kieVersionListSelection = this._kieVersionsList.getSelection();
        if (kieVersionListSelection.isEmpty()) {
            return null;
        }
        return (ArtifactVersion)((IStructuredSelection)kieVersionListSelection).getFirstElement();
    }

    private static final class ComponentsContentProvider
    implements ITreeContentProvider {
        private ComponentsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof ISwitchYardComponentExtension.Category) {
                return SwitchYardComponentExtensionManager.instance();
            }
            if (element instanceof ISwitchYardComponentExtension) {
                return ((ISwitchYardComponentExtension)element).getCategory();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SwitchYardComponentExtensionManager) {
                return ISwitchYardComponentExtension.Category.values();
            }
            if (parentElement instanceof ISwitchYardComponentExtension.Category) {
                return SwitchYardComponentExtensionManager.instance().getComponentExtensions((ISwitchYardComponentExtension.Category)((Object)parentElement)).toArray();
            }
            return new Object[0];
        }
    }

    private static final class ComponentsLabelProvider
    extends LabelProvider {
        private ComponentsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ISwitchYardComponentExtension.Category) {
                switch ((ISwitchYardComponentExtension.Category)((Object)element)) {
                    case UNKNOWN: {
                        return Messages.SwitchYardSettingsGroup_UnknownCategoryLabel;
                    }
                    case IMPLEMENTATION: {
                        return Messages.SwitchYardSettingsGroup_ImplementationSupportLabel;
                    }
                    case GATEWAY: {
                        return Messages.SwitchYardSettingsGroup_GatewayBindingsLabel;
                    }
                    case TEST: {
                        return Messages.SwitchYardSettingsGroup_TestMixinsLabel;
                    }
                }
            } else if (element instanceof ISwitchYardComponentExtension) {
                return ((ISwitchYardComponentExtension)element).getName();
            }
            return super.getText(element);
        }
    }

    private static final class ComponentsSorter
    extends ViewerSorter {
        private ComponentsSorter() {
        }

        public int category(Object element) {
            ISwitchYardComponentExtension.Category category = element instanceof ISwitchYardComponentExtension.Category ? (ISwitchYardComponentExtension.Category)((Object)element) : (element instanceof ISwitchYardComponentExtension ? ((ISwitchYardComponentExtension)element).getCategory() : ISwitchYardComponentExtension.Category.UNKNOWN);
            switch (category) {
                case IMPLEMENTATION: {
                    return 0;
                }
                case GATEWAY: {
                    return 1;
                }
                case TEST: {
                    return 2;
                }
            }
            return 3;
        }
    }

    private static final class RuntimesListSorter
    extends ViewerSorter {
        private Comparator _comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return -((String)o1).compareTo((String)o2);
            }
        };

        private RuntimesListSorter() {
        }

        public int category(Object element) {
            if (element == NULL_RUNTIME) {
                return 0;
            }
            if ("fuseServiceWorks.runtime".equals(((IRuntimeComponent)element).getRuntimeComponentType().getId())) {
                return 1;
            }
            return 2;
        }

        protected Comparator getComparator() {
            return this._comparator;
        }
    }

    private final class VersionComboViewer
    extends ComboViewer {
        private VersionComboViewer(Composite parent) {
            super(parent, 4);
            this.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)VersionComboViewer.this, VersionComboViewer.this.getSelection());
                    VersionComboViewer.this.fireSelectionChanged(event);
                }
            });
        }

        protected List<?> getSelectionFromWidget() {
            if (this.getCombo().getSelectionIndex() < 0) {
                ArrayList<ArtifactVersion> selected = new ArrayList<ArtifactVersion>();
                ArtifactVersion version = SwitchYardSettingsGroup.this.parseVersion(this.getCombo().getText());
                if (version != null) {
                    selected.add(version);
                }
                return selected;
            }
            return super.getSelectionFromWidget();
        }

        protected void setSelectionToWidget(ISelection selection, boolean reveal) {
            if (!selection.isEmpty() && SwitchYardSettingsGroup.this._availableVersions != null) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (!SwitchYardSettingsGroup.this._availableVersions.contains(obj)) {
                    this.getCombo().setText(obj.toString());
                    return;
                }
            }
            super.setSelectionToWidget(selection, reveal);
        }
    }
}

