/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.ISwitchYardTestMixInExtension;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.i18n.Messages;

public final class SwitchYardTestMixInExtensionManager {
    private static final SwitchYardTestMixInExtensionManager INSTANCE = new SwitchYardTestMixInExtensionManager();
    private Map<String, ISwitchYardTestMixInExtension> _extensions = new HashMap<String, ISwitchYardTestMixInExtension>();

    public static SwitchYardTestMixInExtensionManager instance() {
        return INSTANCE;
    }

    private SwitchYardTestMixInExtensionManager() {
        this.loadExtensions();
    }

    public Collection<ISwitchYardTestMixInExtension> getExtensions() {
        return Collections.unmodifiableCollection(this._extensions.values());
    }

    private void loadExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.switchyard.tools.ui", "switchYardTestMixIn");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension pluginExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = pluginExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("switchYardTestMixIn".equals(element.getName())) {
                    String message;
                    String name = element.getAttribute("name");
                    String description = element.getAttribute("description");
                    String mixInClass = element.getAttribute("mixInClass");
                    ISwitchYardComponentExtension capability = SwitchYardComponentExtensionManager.instance().getComponentExtension(element.getAttribute("componentId"));
                    if (name == null) {
                        message = NLS.bind((String)Messages.SwitchYardTestMixInExtensionManager_logMessageMissingNameForSYMixIn, (Object[])new Object[]{mixInClass, element.getNamespaceIdentifier()});
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", message));
                    } else if (this._extensions.containsKey(name)) {
                        message = NLS.bind((String)Messages.SwitchYardTestMixInExtensionManager_logMessageDuplicateNameForSYMixIn, (Object[])new Object[]{name, element.getNamespaceIdentifier()});
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", message));
                    } else {
                        this._extensions.put(name, new SwitchYardTestMixInExtension(name, description, mixInClass, capability));
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static final class SwitchYardTestMixInExtension
    implements ISwitchYardTestMixInExtension {
        private final ISwitchYardComponentExtension _capability;
        private final String _mixInClass;
        private final String _name;
        private final String _description;

        private SwitchYardTestMixInExtension(String name, String description, String mixInClass, ISwitchYardComponentExtension capability) {
            this._capability = capability;
            this._mixInClass = mixInClass;
            this._name = name;
            this._description = description;
        }

        @Override
        public String getMixInClass() {
            return this._mixInClass;
        }

        @Override
        public ISwitchYardComponentExtension getRequiredComponent() {
            return this._capability;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getDescription() {
            return this._description;
        }
    }
}

