/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.config.model.switchyard.ArtifactModel;
import org.switchyard.config.model.switchyard.ArtifactsModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.IArtifactNode;
import org.switchyard.tools.ui.explorer.IArtifactsNode;
import org.switchyard.tools.ui.explorer.impl.ArtifactNode;
import org.switchyard.tools.ui.explorer.impl.SwitchYardRootNode;
import org.switchyard.tools.ui.i18n.Messages;

public class ArtifactsNode
extends AbstractSwitchYardNode
implements IArtifactsNode {
    private List<IArtifactNode> _artifacts;

    public ArtifactsNode(SwitchYardRootNode root, SwitchYardModel configuration) {
        super(root);
        if (configuration == null) {
            this._artifacts = Collections.emptyList();
            return;
        }
        ArtifactsModel artifactsModel = configuration.getArtifacts();
        if (artifactsModel == null) {
            this._artifacts = Collections.emptyList();
            return;
        }
        List artifacts = artifactsModel.getArtifacts();
        this._artifacts = new ArrayList<IArtifactNode>(artifacts.size());
        for (ArtifactModel artifact : artifacts) {
            this._artifacts.add(new ArtifactNode(this, artifact));
        }
    }

    @Override
    public List<IArtifactNode> getArtifacts() {
        return this._artifacts;
    }

    @Override
    public String getName() {
        return Messages.ArtifactsNode_labelArtifacts;
    }

    public int hashCode() {
        return this.getParent().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArtifactsNode) {
            return ((ArtifactsNode)obj).getRoot() == this.getRoot();
        }
        return false;
    }
}

