/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceFactoryImpl;
import org.switchyard.tools.ui.M2EUtils;
import org.switchyard.tools.ui.RuntimeUtils;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.facets.ISwitchYardFacetConstants;
import org.switchyard.tools.ui.i18n.Messages;

public class CreateSwitchYardProjectOperation
implements IWorkspaceRunnable {
    public static final String DEFAULT_JAVA_VERSION = "1.7";
    private final NewSwitchYardProjectMetaData _projectMetatData;
    private final IAdaptable _uiInfo;
    private IFile _switchYardFile;

    public CreateSwitchYardProjectOperation(NewSwitchYardProjectMetaData projectMetatData, IAdaptable uiInfo) {
        this._projectMetatData = projectMetatData;
        this._uiInfo = uiInfo;
    }

    public IFile getSwitchYardFile() {
        return this._switchYardFile;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        MultiStatus status = new MultiStatus("org.switchyard.tools.ui", 15, Messages.CreateSwitchYardProjectOperation_statusLabel_errorsCreatingProject, null);
        monitor.beginTask(Messages.CreateSwitchYardProjectOperation_taskLabel_creatingSYProject, 700);
        try {
            block48: {
                SubProgressMonitor subMonitor;
                block46: {
                    block44: {
                        block42: {
                            block40: {
                                block38: {
                                    CreateProjectOperation op;
                                    subMonitor = new SubProgressMonitor(monitor, 100, 4);
                                    try {
                                        try {
                                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                            IProjectDescription description = workspace.newProjectDescription(this._projectMetatData.getNewProjectHandle().getName());
                                            description.setLocationURI(this._projectMetatData.getProjectLocation());
                                            op = new CreateProjectOperation(description, Messages.CreateSwitchYardProjectOperation_operationLabel_newSYProject);
                                            op.execute((IProgressMonitor)subMonitor, this._uiInfo);
                                        }
                                        catch (ExecutionException e) {
                                            if (e.getCause() instanceof CoreException) {
                                                throw (CoreException)e.getCause();
                                            }
                                            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.CreateSwitchYardProjectOperation_exceptionMessage_errorCreatingSYProject, (Throwable)e));
                                        }
                                    }
                                    finally {
                                        subMonitor.done();
                                        subMonitor.setTaskName("");
                                    }
                                    try {
                                        try {
                                            monitor.subTask(Messages.CreateSwitchYardProjectOperation_taskLabel_creatingDefaultFolders);
                                            String packageFolder = this._projectMetatData.getPackageName().replace('.', '/');
                                            IFolder folder = this._projectMetatData.getNewProjectHandle().getFolder("src/main/java").getFolder(packageFolder);
                                            op = new CreateFolderOperation(folder, null, Messages.CreateSwitchYardProjectOperation_operationLabel_creatingDefaultMainSourceFolder);
                                            subMonitor = new SubProgressMonitor(monitor, 25, 4);
                                            op.execute((IProgressMonitor)subMonitor, this._uiInfo);
                                            subMonitor.done();
                                            subMonitor.setTaskName("");
                                            folder = this._projectMetatData.getNewProjectHandle().getFolder("src/main/resources");
                                            op = new CreateFolderOperation(folder, null, Messages.CreateSwitchYardProjectOperation_operationLabel_creatingDefaultMainResourceFolder);
                                            subMonitor = new SubProgressMonitor(monitor, 25, 4);
                                            op.execute((IProgressMonitor)subMonitor, this._uiInfo);
                                            subMonitor.done();
                                            subMonitor.setTaskName("");
                                            folder = this._projectMetatData.getNewProjectHandle().getFolder("src/test/java").getFolder(packageFolder);
                                            op = new CreateFolderOperation(folder, null, Messages.CreateSwitchYardProjectOperation_operationLabel_creatingDefaultMainTestSourceFolder);
                                            subMonitor = new SubProgressMonitor(monitor, 25, 4);
                                            op.execute((IProgressMonitor)subMonitor, this._uiInfo);
                                            subMonitor.done();
                                            subMonitor.setTaskName("");
                                            folder = this._projectMetatData.getNewProjectHandle().getFolder("src/test/resources");
                                            op = new CreateFolderOperation(folder, null, Messages.CreateSwitchYardProjectOperation_operationLabel_creatingDefaultTestResourceFolder);
                                            subMonitor = new SubProgressMonitor(monitor, 25, 4);
                                            op.execute((IProgressMonitor)subMonitor, this._uiInfo);
                                        }
                                        catch (Exception e) {
                                            this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_statusMessage_errorCreatingDefaultFolders, e);
                                            subMonitor.done();
                                            subMonitor.setTaskName("");
                                            break block38;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        subMonitor.done();
                                        subMonitor.setTaskName("");
                                        throw throwable;
                                    }
                                    subMonitor.done();
                                    subMonitor.setTaskName("");
                                }
                                try {
                                    try {
                                        monitor.subTask(Messages.CreateSwitchYardProjectOperation_taskLabel_creatingPOM);
                                        Model model = this.createPom();
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        MavenPlugin.getMaven().writeModel(model, (OutputStream)baos);
                                        IFile pomFile = this._projectMetatData.getNewProjectHandle().getFile("pom.xml");
                                        CreateFileOperation op = new CreateFileOperation(pomFile, null, (InputStream)new ByteArrayInputStream(baos.toByteArray()), Messages.CreateSwitchYardProjectOperation_operationLabel_creatingPOM);
                                        subMonitor = new SubProgressMonitor(monitor, 100, 4);
                                        op.execute((IProgressMonitor)subMonitor, this._uiInfo);
                                    }
                                    catch (Exception e) {
                                        this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_statusMessage_errorCreatingPOM, e);
                                        subMonitor.done();
                                        subMonitor.setTaskName("");
                                        break block40;
                                    }
                                }
                                catch (Throwable throwable) {
                                    subMonitor.done();
                                    subMonitor.setTaskName("");
                                    throw throwable;
                                }
                                subMonitor.done();
                                subMonitor.setTaskName("");
                            }
                            if (this._projectMetatData.isOSGIEnabled()) {
                                try {
                                    try {
                                        this.createFeaturesXML(monitor, status);
                                    }
                                    catch (Exception e) {
                                        this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_ErrorCreatingFeaturesXML, e);
                                        subMonitor.done();
                                        subMonitor.setTaskName("");
                                        break block42;
                                    }
                                }
                                catch (Throwable throwable) {
                                    subMonitor.done();
                                    subMonitor.setTaskName("");
                                    throw throwable;
                                }
                                subMonitor.done();
                                subMonitor.setTaskName("");
                            }
                        }
                        try {
                            try {
                                monitor.subTask(Messages.CreateSwitchYardProjectOperation_taskLabel_creatingSYXMLFile);
                                subMonitor = new SubProgressMonitor(monitor, 100, 4);
                                this.createSwitchYardConfig((IProgressMonitor)subMonitor);
                            }
                            catch (Exception e) {
                                this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_statusMessage_errorCreatingSYXML, e);
                                subMonitor.done();
                                subMonitor.setTaskName("");
                                break block44;
                            }
                        }
                        catch (Throwable throwable) {
                            subMonitor.done();
                            subMonitor.setTaskName("");
                            throw throwable;
                        }
                        subMonitor.done();
                        subMonitor.setTaskName("");
                    }
                    try {
                        try {
                            monitor.subTask(Messages.CreateSwitchYardProjectOperation_taskLabel_updatingMavenProjectConfig);
                            subMonitor = new SubProgressMonitor(monitor, 100, 4);
                            IProjectConfigurationManager mavenProjectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
                            mavenProjectConfigurationManager.enableMavenNature(this._projectMetatData.getNewProjectHandle(), mavenProjectConfigurationManager.getResolverConfiguration(this._projectMetatData.getNewProjectHandle()), (IProgressMonitor)subMonitor);
                        }
                        catch (Exception e) {
                            this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_statusMessage_errorUpdatingMavenProjectConfig, e);
                            subMonitor.done();
                            subMonitor.setTaskName("");
                            break block46;
                        }
                    }
                    catch (Throwable throwable) {
                        subMonitor.done();
                        subMonitor.setTaskName("");
                        throw throwable;
                    }
                    subMonitor.done();
                    subMonitor.setTaskName("");
                }
                try {
                    try {
                        this.createLog4jXMLFile(monitor, status);
                    }
                    catch (Exception e) {
                        this.mergeStatus(status, "Error encountered while creating log4j.xml file.", e);
                        subMonitor.done();
                        subMonitor.setTaskName("");
                        break block48;
                    }
                }
                catch (Throwable throwable) {
                    subMonitor.done();
                    subMonitor.setTaskName("");
                    throw throwable;
                }
                subMonitor.done();
                subMonitor.setTaskName("");
            }
            if (this._projectMetatData.getTargetRuntime() != null) {
                this.attachTargetRuntime(monitor, status);
            }
            this.refreshProject(monitor);
            if (!status.isOK()) {
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshProject(IProgressMonitor monitor) throws CoreException {
        IProject project = this._projectMetatData.getNewProjectHandle();
        if (project != null) {
            UpdateMavenProjectJob updateJob = new UpdateMavenProjectJob(new IProject[]{project});
            updateJob.schedule();
        }
    }

    private void createFeaturesXML(IProgressMonitor monitor, MultiStatus status) throws IOException {
        if (this._projectMetatData.isOSGIEnabled()) {
            SubProgressMonitor subMonitor = null;
            try {
                try {
                    monitor.subTask(Messages.CreateSwitchYardProjectOperation_CreatingFeaturesXML);
                    IFile featuresFile = this._projectMetatData.getNewProjectHandle().getFolder("src/main/resources").getFile("features.xml");
                    StringBuffer contents = new StringBuffer();
                    contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    contents.append("<features xmlns=\"http://karaf.apache.org/xmlns/features/v1.0.0\">\n");
                    contents.append("\t<repository>mvn:org.switchyard.karaf/switchyard/${switchyard.version}/xml/features</repository>\n");
                    contents.append("\t<feature name=\"" + this._projectMetatData.getNewProjectHandle().getName() + "\" version=\"" + this._projectMetatData._projectVersion + "\" resolver=\"(obr)\"" + ">\n");
                    for (ISwitchYardComponentExtension component : this._projectMetatData.getComponents()) {
                        String featureId = component.getBundleId();
                        if (featureId == null || featureId.length() <= 0) continue;
                        contents.append("\t\t<feature version=\"${switchyard.version}\">" + featureId + "</feature>\n");
                    }
                    contents.append("\t\t<bundle>mvn:${project.groupId}/${project.artifactId}/${project.version}</bundle>\n");
                    contents.append("\t</feature>\n");
                    contents.append("</features>\n");
                    CreateFileOperation op = new CreateFileOperation(featuresFile, null, (InputStream)new ByteArrayInputStream(contents.toString().getBytes()), Messages.CreateSwitchYardProjectOperation_CreatingFeaturesXML);
                    subMonitor = new SubProgressMonitor(monitor, 100, 4);
                    op.execute((IProgressMonitor)subMonitor, this._uiInfo);
                }
                catch (Exception e) {
                    this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_ErrorCreatingFeaturesXML, e);
                    if (subMonitor != null) {
                        subMonitor.done();
                        subMonitor.setTaskName("");
                    }
                }
            }
            finally {
                if (subMonitor != null) {
                    subMonitor.done();
                    subMonitor.setTaskName("");
                }
            }
        }
    }

    private void createLog4jXMLFile(IProgressMonitor monitor, MultiStatus status) throws IOException {
        SubProgressMonitor subMonitor = null;
        try {
            try {
                monitor.subTask("Creating log4j.xml in Test Resources");
                IFile featuresFile = this._projectMetatData.getNewProjectHandle().getFolder("src/test/resources").getFile("log4j.xml");
                StringBuffer contents = new StringBuffer();
                contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                contents.append("<log4j:configuration xmlns:log4j=\"http://jakarta.apache.org/log4j/\">\n");
                contents.append("\t<appender name=\"STDOUT\" class=\"org.apache.log4j.ConsoleAppender\">\n");
                contents.append("\t\t<layout class=\"org.apache.log4j.PatternLayout\">\n");
                contents.append("\t\t\t<param name=\"ConversionPattern\" value=\"%d{HH:mm:ss,SSS} %-5p [%c] %m%n\"/>\n");
                contents.append("\t\t</layout>\n");
                contents.append("\t</appender>\n");
                contents.append("\t<logger name=\"org.jboss.weld.Bootstrap\">\n");
                contents.append("\t\t<level value=\"ERROR\"/>\n");
                contents.append("\t</logger>\n");
                contents.append("\t<root>\n");
                contents.append("\t\t<level value=\"INFO\"/>\n");
                contents.append("\t\t<appender-ref ref=\"STDOUT\"/>\n");
                contents.append("\t</root>\n");
                contents.append("</log4j:configuration>\n");
                CreateFileOperation op = new CreateFileOperation(featuresFile, null, (InputStream)new ByteArrayInputStream(contents.toString().getBytes()), Messages.CreateSwitchYardProjectOperation_CreatingFeaturesXML);
                subMonitor = new SubProgressMonitor(monitor, 100, 4);
                op.execute((IProgressMonitor)subMonitor, this._uiInfo);
            }
            catch (Exception e) {
                this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_ErrorCreatingFeaturesXML, e);
                if (subMonitor != null) {
                    subMonitor.done();
                    subMonitor.setTaskName("");
                }
            }
        }
        finally {
            if (subMonitor != null) {
                subMonitor.done();
                subMonitor.setTaskName("");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createSwitchYardConfig(IProgressMonitor monitor) throws IOException {
        rs = SwitchYardModelUtils.newResourceSet();
        try {
            this._switchYardFile = this._projectMetatData.getNewProjectHandle().getFolder("src/main/resources").getFolder("META-INF").getFile("switchyard.xml");
            rs.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.switchyard.content-type.1.x", new SwitchyardResourceFactoryImpl());
            switchYardResource = (XMLResource)rs.createResource(URI.createPlatformResourceURI((String)this._switchYardFile.getFullPath().toPortableString(), (boolean)true), "org.switchyard.content-type.1.x");
            namespace = this._projectMetatData.getNamespace();
            switchYardModel = this.newSwitchYardModel(this._projectMetatData.getNewProjectHandle().getName(), namespace == null || namespace.length() == 0 ? SwitchYardModelUtils.createTargetnamespace(this._projectMetatData.getGroupId(), this._projectMetatData.getNewProjectHandle().getName(), this._projectMetatData.getProjectVersion()) : namespace);
            switchYardResource.getContents().add((Object)switchYardModel);
            configVersion = this._projectMetatData.getConfigurationVersion();
            converter = (SwitchyardResourceFactoryImpl.NamespaceVersionConverter)switchYardResource.getDefaultSaveOptions().get("EXTENDED_META_DATA");
            converter.setVersion(configVersion == null ? ISwitchYardFacetConstants.SWITCHYARD_FACET.getDefaultVersion().getVersionString() : configVersion.getVersionString());
            switchYardResource.save(null);
        }
        finally {
            ** for (resource : rs.getResources())
        }
lbl-1000:
        // 1 sources

        {
            try {
                resource.unload();
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
            continue;
        }
lbl25:
        // 1 sources

    }

    private void mergeStatus(MultiStatus status, String message, Exception e) {
        if (e instanceof CoreException) {
            status.merge(((CoreException)((Object)e)).getStatus());
        } else if (e.getCause() instanceof CoreException) {
            status.merge(((CoreException)e.getCause()).getStatus());
        } else {
            status.merge((IStatus)new Status(4, "org.switchyard.tools.ui", message, (Throwable)e));
        }
    }

    private void attachTargetRuntime(IProgressMonitor monitor, MultiStatus status) {
        monitor.subTask(Messages.CreateSwitchYardProjectOperation_taskLabel_attachingTargetRuntimeToProject);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50, 4);
        IFacetedProjectWorkingCopy ifpwc = null;
        try {
            try {
                IFacetedProject ifp = ProjectFacetsManager.create((IProject)this._projectMetatData.getNewProjectHandle(), (boolean)true, (IProgressMonitor)subMonitor);
                subMonitor.done();
                ifpwc = ifp.createWorkingCopy();
                ifpwc.addTargetedRuntime(this._projectMetatData.getTargetRuntime().getRuntime());
                subMonitor = new SubProgressMonitor(monitor, 50, 4);
                ifpwc.commitChanges((IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                this.mergeStatus(status, Messages.CreateSwitchYardProjectOperation_errorMessage_errorAttachingTargetRuntimeToProject, e);
                if (ifpwc != null) {
                    ifpwc.dispose();
                }
                subMonitor.done();
                subMonitor.setTaskName("");
            }
        }
        finally {
            if (ifpwc != null) {
                ifpwc.dispose();
            }
            subMonitor.done();
            subMonitor.setTaskName("");
        }
    }

    private SwitchYardType newSwitchYardModel(String name, String targetNamespace) {
        SwitchYardType switchYardModel = SwitchYardModelUtils.createSwitchYardModel(name, targetNamespace);
        Composite composite = ScaFactory.eINSTANCE.createComposite();
        composite.setName(name);
        composite.setTargetNamespace(targetNamespace);
        switchYardModel.setComposite(composite);
        return switchYardModel;
    }

    private Model createPom() {
        IRuntimeComponent rtc;
        IRuntime rt;
        String tempVersion;
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this._projectMetatData.getGroupId());
        model.setArtifactId(this._projectMetatData.getNewProjectHandle().getName());
        model.setVersion(this._projectMetatData.getProjectVersion());
        if (this._projectMetatData.isOSGIEnabled()) {
            model.setPackaging("bundle");
        } else {
            model.setPackaging("jar");
        }
        model.setName(String.valueOf(this._projectMetatData.getGroupId()) + ":" + this._projectMetatData.getNewProjectHandle().getName());
        boolean isIntegration = this._projectMetatData.getIntegrationVersion() != null;
        String versionString = "${switchyard.version}";
        if (isIntegration) {
            model.addProperty("integration.version", this._projectMetatData.getIntegrationVersion());
            model.addProperty("kie.version", this._projectMetatData.getKieVersion());
        }
        model.addProperty("switchyard.version", this._projectMetatData.getRuntimeVersion());
        String javaVersion = DEFAULT_JAVA_VERSION;
        if (this._projectMetatData.getTargetRuntime() != null && (tempVersion = RuntimeUtils.getJavaExecutionEnvironment(rt = (rtc = this._projectMetatData.getTargetRuntime()).getRuntime())) != null) {
            javaVersion = tempVersion;
        }
        model.addProperty("maven.compiler.target", javaVersion);
        model.addProperty("maven.compiler.source", javaVersion);
        if (this._projectMetatData.isOSGIEnabled()) {
            model.addProperty("switchyard.osgi.require.capability", "org.ops4j.pax.cdi.extension; filter:=\"(extension=switchyard-component-bean)\",\norg.ops4j.pax.cdi.extension; filter:=\"(extension=deltaspike-core-api)\",\nosgi.extender; filter:=\"(osgi.extender=pax.cdi)\"");
            model.addProperty("switchyard.osgi.symbolic.name", String.valueOf(this._projectMetatData.getGroupId()) + "." + model.getArtifactId());
            model.addProperty("switchyard.osgi.import.switchyard.version", "version=\"[$(version;==;${switchyard.osgi.version}),$(version;=+;${switchyard.osgi.version}))\"");
            model.addProperty("switchyard.osgi.import.default.version", "[$(version;==;$(@)),$(version;+;$(@)))");
            model.addProperty("switchyard.osgi.export", String.valueOf(this._projectMetatData.getPackageName()) + "*");
            model.addProperty("switchyard.osgi.import", "org.switchyard.*;${switchyard.osgi.import.switchyard.version},*");
            model.addProperty("switchyard.osgi.dynamic", "org.switchyard,org.switchyard.*");
        }
        if (this._projectMetatData.isSwitchYardDependencyBOMEnabled()) {
            if (model.getDependencyManagement() == null) {
                model.setDependencyManagement(new DependencyManagement());
            }
            if (isIntegration) {
                Dependency integrationBomDependency = new Dependency();
                integrationBomDependency.setGroupId("org.jboss.integration.fuse");
                integrationBomDependency.setArtifactId("fuse-integration-bom");
                integrationBomDependency.setVersion("${integration.version}");
                integrationBomDependency.setScope("import");
                integrationBomDependency.setType("pom");
                model.getDependencyManagement().addDependency(integrationBomDependency);
                Dependency kieBomDependency = new Dependency();
                kieBomDependency.setGroupId("org.kie");
                kieBomDependency.setArtifactId("kie-bom");
                kieBomDependency.setVersion("${kie.version}");
                kieBomDependency.setScope("import");
                kieBomDependency.setType("pom");
                model.getDependencyManagement().addDependency(kieBomDependency);
                Dependency droolsBomDependency = new Dependency();
                droolsBomDependency.setGroupId("org.drools");
                droolsBomDependency.setArtifactId("drools-bom");
                droolsBomDependency.setVersion("${kie.version}");
                droolsBomDependency.setScope("import");
                droolsBomDependency.setType("pom");
                model.getDependencyManagement().addDependency(droolsBomDependency);
                Dependency jbpmBomDependency = new Dependency();
                jbpmBomDependency.setGroupId("org.jbpm");
                jbpmBomDependency.setArtifactId("jbpm-bom");
                jbpmBomDependency.setVersion("${kie.version}");
                jbpmBomDependency.setScope("import");
                jbpmBomDependency.setType("pom");
                model.getDependencyManagement().addDependency(jbpmBomDependency);
            }
            Dependency bomDependency = new Dependency();
            bomDependency.setGroupId("org.switchyard");
            bomDependency.setArtifactId("switchyard-bom");
            bomDependency.setVersion("${switchyard.version}");
            bomDependency.setScope("import");
            bomDependency.setType("pom");
            model.getDependencyManagement().addDependency(bomDependency);
        }
        LinkedHashSet<String> scanners = new LinkedHashSet<String>();
        for (ISwitchYardComponentExtension component : this._projectMetatData.getComponents()) {
            String scanner = component.getScannerClassName();
            if (scanner != null) {
                scanners.add(scanner);
            }
            for (Dependency dependency : component.getDependencies()) {
                dependency = dependency.clone();
                if (!this._projectMetatData.isSwitchYardDependencyBOMEnabled()) {
                    dependency.setVersion(versionString);
                } else if (dependency.getArtifactId().equals("switchyard-plugin")) {
                    dependency.setVersion(versionString);
                }
                if (isIntegration) {
                    M2EUtils.hackIntegrationPackDependency(dependency);
                }
                model.getDependencies().add(dependency);
            }
        }
        model.setBuild(this.createBuildSection(versionString, scanners));
        return model;
    }

    private Build createBuildSection(String versionString, Set<String> scanners) {
        Build build = new Build();
        build.addPlugin(this.createSwitchYardPlugin(versionString, scanners));
        if (this._projectMetatData.isOSGIEnabled()) {
            build.addPlugin(this.createBundlePlugin());
            build.addPlugin(this.createAttachFeaturePlugin());
            build.addResource(this.createFilteredResource());
            build.addResource(this.createUnFilteredResource());
        }
        return build;
    }

    private Resource createFilteredResource() {
        Resource mvnResource = new Resource();
        mvnResource.setDirectory("src/main/resources");
        mvnResource.setFiltering(true);
        ArrayList<String> includesList = new ArrayList<String>();
        includesList.add("features.xml");
        mvnResource.setIncludes(includesList);
        return mvnResource;
    }

    private Resource createUnFilteredResource() {
        Resource mvnResource = new Resource();
        mvnResource.setDirectory("src/main/resources");
        mvnResource.setFiltering(false);
        ArrayList<String> excludesList = new ArrayList<String>();
        excludesList.add("features.xml");
        mvnResource.setExcludes(excludesList);
        return mvnResource;
    }

    private Plugin createAttachFeaturePlugin() {
        Plugin plugin = new Plugin();
        plugin.setArtifactId("build-helper-maven-plugin");
        plugin.setGroupId("org.codehaus.mojo");
        PluginExecution attachFeatureExecution = new PluginExecution();
        attachFeatureExecution.setId("attach-artifacts");
        attachFeatureExecution.setPhase("package");
        attachFeatureExecution.addGoal("attach-artifact");
        Xpp3Dom configuration = this.createNode("configuration");
        Xpp3Dom artifacts = this.createNode("artifacts");
        Xpp3Dom artifact = this.createNode("artifact");
        Xpp3Dom file = this.createNode("file", "target/classes/features.xml");
        artifact.addChild(file);
        Xpp3Dom type = this.createNode("type", "xml");
        artifact.addChild(type);
        Xpp3Dom classifier = this.createNode("classifier", "features");
        artifact.addChild(classifier);
        artifacts.addChild(artifact);
        configuration.addChild(artifacts);
        attachFeatureExecution.setConfiguration((Object)configuration);
        plugin.addExecution(attachFeatureExecution);
        return plugin;
    }

    private Xpp3Dom createNode(String tag) {
        return this.createNode(tag, null);
    }

    private Xpp3Dom createNode(String tag, String value) {
        Xpp3Dom domNode = new Xpp3Dom(tag);
        if (value != null) {
            domNode.setValue(value);
        }
        return domNode;
    }

    private Plugin createBundlePlugin() {
        Plugin plugin = new Plugin();
        plugin.setArtifactId("maven-bundle-plugin");
        plugin.setGroupId("org.apache.felix");
        plugin.setVersion("2.4.0");
        plugin.setExtensions(true);
        String versionStr = "${switchyard.version}";
        ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
        PluginExecution execution = new PluginExecution();
        execution.setId("cleanVersions");
        execution.setPhase("generate-sources");
        execution.addGoal("cleanVersions");
        Xpp3Dom exeuctionConfiguration = this.createNode("configuration");
        Xpp3Dom exeuctionVersions = this.createNode("versions");
        Xpp3Dom executionVersionsOSGIVersion = this.createNode("switchyard.osgi.version", versionStr);
        exeuctionVersions.addChild(executionVersionsOSGIVersion);
        exeuctionConfiguration.addChild(exeuctionVersions);
        execution.setConfiguration((Object)exeuctionConfiguration);
        executions.add(execution);
        plugin.setExecutions(executions);
        Xpp3Dom configuration = this.createNode("configuration");
        Xpp3Dom excludeDeps = this.createNode("excludeDependencies", "false");
        configuration.addChild(excludeDeps);
        Xpp3Dom instructions = this.createNode("instructions");
        instructions.addChild(this.createNode("Bundle-Name", "${project.name}"));
        instructions.addChild(this.createNode("Bundle-SymbolicName", "${project.groupId}.${project.artifactId}"));
        instructions.addChild(this.createNode("Import-Package", "${switchyard.osgi.import}"));
        instructions.addChild(this.createNode("Include-Resource", "{maven-resources}, META-INF/switchyard.xml=target/classes/META-INF/switchyard.xml"));
        instructions.addChild(this.createNode("DynamicImport-Package", "${switchyard.osgi.dynamic}"));
        instructions.addChild(this.createNode("_failok", "true"));
        instructions.addChild(this.createNode("Embed-Dependency", "!*"));
        instructions.addChild(this.createNode("Require-Capability", "${switchyard.osgi.require.capability}"));
        configuration.addChild(instructions);
        Xpp3Dom archive = this.createNode("archive");
        Xpp3Dom manifestEntries = this.createNode("manifestEntries");
        manifestEntries.addChild(this.createNode("Project-Artifact-Id", "${project.artifactId}"));
        manifestEntries.addChild(this.createNode("Project-Group-Id", "${project.groupId}"));
        manifestEntries.addChild(this.createNode("Project-Version", "${project.version}"));
        archive.addChild(manifestEntries);
        configuration.addChild(archive);
        plugin.setConfiguration((Object)configuration);
        return plugin;
    }

    private Plugin createSwitchYardPlugin(String versionString, Set<String> scanners) {
        boolean isIntegration = false;
        if (this._projectMetatData.getTargetRuntime() != null) {
            String label = this._projectMetatData.getTargetRuntime().getProperty("switchyard.label");
            isIntegration = label.contains("Integration");
        }
        if (isIntegration) {
            return M2EUtils.createSwitchYardPlugin(null, true, scanners);
        }
        return M2EUtils.createSwitchYardPlugin(versionString, true, scanners);
    }

    public static final class NewSwitchYardProjectMetaData {
        private IProject _newProjectHandle;
        private java.net.URI _projectLocation;
        private String _namespace;
        private String _packageName;
        private String _groupId;
        private String _projectVersion;
        private String _runtimeVersion;
        private String _kieVersion;
        private String _integVersion;
        private boolean _isOSGIEnabled = false;
        private boolean _useSwitchYardDependencyBOM = false;
        private IProjectFacetVersion _configurationVersion;
        private IRuntimeComponent _targetRuntime;
        private Collection<ISwitchYardComponentExtension> _components;

        public IProjectFacetVersion getConfigurationVersion() {
            return this._configurationVersion;
        }

        public void setConfigurationVersion(IProjectFacetVersion switchYardFacet) {
            this._configurationVersion = switchYardFacet;
        }

        public IRuntimeComponent getTargetRuntime() {
            return this._targetRuntime;
        }

        public void setTargetRuntime(IRuntimeComponent targetRuntime) {
            this._targetRuntime = targetRuntime;
        }

        public IProject getNewProjectHandle() {
            return this._newProjectHandle;
        }

        public void setNewProjectHandle(IProject newProjectHandle) {
            this._newProjectHandle = newProjectHandle;
        }

        public java.net.URI getProjectLocation() {
            return this._projectLocation;
        }

        public void setProjectLocation(java.net.URI projectLocation) {
            this._projectLocation = projectLocation;
        }

        public String getNamespace() {
            return this._namespace;
        }

        public void setNamespace(String namespace) {
            this._namespace = namespace;
        }

        public String getPackageName() {
            return this._packageName;
        }

        public void setPackageName(String packageName) {
            this._packageName = packageName;
        }

        public String getGroupId() {
            return this._groupId;
        }

        public void setGroupId(String groupId) {
            this._groupId = groupId;
        }

        public String getProjectVersion() {
            return this._projectVersion;
        }

        public void setProjectVersion(String projectVersion) {
            this._projectVersion = projectVersion;
        }

        public String getRuntimeVersion() {
            return this._runtimeVersion;
        }

        public void setRuntimeVersion(String runtimeVersion) {
            this._runtimeVersion = runtimeVersion;
        }

        public String getKieVersion() {
            return this._kieVersion;
        }

        public void setKieVersion(String version) {
            this._kieVersion = version;
        }

        public String getIntegrationVersion() {
            return this._integVersion;
        }

        public void setIntegrationVersion(String version) {
            this._integVersion = version;
        }

        public Collection<ISwitchYardComponentExtension> getComponents() {
            return this._components;
        }

        public void setComponents(Collection<ISwitchYardComponentExtension> components) {
            this._components = components;
        }

        public boolean isOSGIEnabled() {
            return this._isOSGIEnabled;
        }

        public void setIsOSGIEnabled(boolean isEnabled) {
            this._isOSGIEnabled = isEnabled;
        }

        public boolean isSwitchYardDependencyBOMEnabled() {
            return this._useSwitchYardDependencyBOM;
        }

        public void setIsSwitchYardDependencyBOMEnabled(boolean isEnabled) {
            this._useSwitchYardDependencyBOM = isEnabled;
        }
    }
}

