/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.switchyard.tools.models.switchyard1_0.bean.BeanImplementationType;
import org.switchyard.tools.ui.JavaTypeScanner;
import org.switchyard.tools.ui.validation.SwitchYardProjectValidator;
import org.switchyard.tools.ui.validation.ValidationProblem;

public class BeanComponentConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof BeanImplementationType) {
            return this.validate(ctx, (BeanImplementationType)eObj);
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validate(IValidationContext ctx, BeanImplementationType bean) {
        Component component = (Component)bean.eContainer();
        String className = bean.getClass_();
        if (className == null || className.length() == 0) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.BeanUnspecifiedClass.getSeverity(), (int)ValidationProblem.BeanUnspecifiedClass.ordinal(), (String)ValidationProblem.BeanUnspecifiedClass.getMessage(), (Object[])new Object[]{component.getName()});
        }
        SwitchYardProjectValidator.ValidationAdapter adapter = (SwitchYardProjectValidator.ValidationAdapter)EcoreUtil.getAdapter((List)bean.eResource().eAdapters(), SwitchYardProjectValidator.ValidationAdapter.class);
        IJavaProject javaProject = adapter.getJavaProject();
        try {
            IType javaClass;
            IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
            if (javaClass == null) {
                return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.BeanUnresolvableClass.getSeverity(), (int)ValidationProblem.BeanUnresolvableClass.ordinal(), (String)ValidationProblem.BeanUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
            }
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            JavaTypeScanner scanner = new JavaTypeScanner(javaClass);
            adapter.addDependency(javaClass.getResource());
            statuses.add(this.validateContracts(ctx, component, (List<? extends Contract>)component.getService(), scanner.getServices(), ValidationProblem.MissingServiceDeclaration, ValidationProblem.ServiceInterfaceMismatch, ValidationProblem.UnusedServiceDeclaration));
            statuses.add(this.validateContracts(ctx, component, (List<? extends Contract>)component.getReference(), scanner.getReferences(), ValidationProblem.MissingReferenceDeclaration, ValidationProblem.ReferenceInterfaceMismatch, ValidationProblem.UnusedReferenceDeclaration));
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        }
        catch (JavaModelException javaModelException) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.BeanUnresolvableClass.getSeverity(), (int)ValidationProblem.BeanUnresolvableClass.ordinal(), (String)ValidationProblem.BeanUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
        }
    }

    private IStatus validateContracts(IValidationContext ctx, Component component, List<? extends Contract> switchYard, List<? extends Contract> java, ValidationProblem missingProblem, ValidationProblem mismatchProblem, ValidationProblem superfluousProblem) {
        ArrayList<ConstraintStatus> statuses = new ArrayList<ConstraintStatus>();
        ArrayList<? extends Contract> switchYardContracts = new ArrayList<Contract>(switchYard);
        block0: for (Contract contract : java) {
            if (contract == null) continue;
            Iterator switchIt = switchYardContracts.iterator();
            while (switchIt.hasNext()) {
                JavaInterface jInt;
                Contract switchYardContract = (Contract)switchIt.next();
                if (switchYardContract == null) {
                    switchIt.remove();
                    continue;
                }
                if (!contract.getName().equals(switchYardContract.getName())) continue;
                boolean isReferenceInvoker = false;
                if (contract.getInterface() instanceof JavaInterface && (jInt = (JavaInterface)contract.getInterface()).getInterface().contentEquals("org.switchyard.component.bean.ReferenceInvoker")) {
                    isReferenceInvoker = true;
                }
                if (!isReferenceInvoker && !EcoreUtil.equals((EObject)contract.getInterface(), (EObject)switchYardContract.getInterface())) {
                    statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)switchYardContract, null, (int)mismatchProblem.getSeverity(), (int)mismatchProblem.ordinal(), (String)mismatchProblem.getMessage(), (Object[])new Object[]{contract.getName(), component.getName()}));
                }
                switchIt.remove();
                continue block0;
            }
            statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)missingProblem.getSeverity(), (int)missingProblem.ordinal(), (String)missingProblem.getMessage(), (Object[])new Object[]{contract.getName(), component.getName()}));
        }
        for (Contract contract : switchYardContracts) {
            statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)contract, null, (int)superfluousProblem.getSeverity(), (int)superfluousProblem.ordinal(), (String)superfluousProblem.getMessage(), (Object[])new Object[]{contract.getName(), component.getName()}));
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }
}

