/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.ui.validation.ValidationProblem;

public class ServiceNameConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Composite) {
            return this.validate(ctx, (Composite)eObj);
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validate(IValidationContext ctx, Composite composite) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        IStatus status = this.validateUniqueNames(ctx, composite);
        if (status != null) {
            statuses.add(status);
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private IStatus validateUniqueNames(IValidationContext ctx, Composite composite) {
        EList compositeServices = composite.getService();
        boolean dupd = false;
        ArrayList<String> allNames = new ArrayList<String>();
        ArrayList<Service> allServices = new ArrayList<Service>();
        Service dupeService = null;
        for (Service other : compositeServices) {
            allServices.add(other);
            if (allNames.contains(other.getName())) {
                dupeService = other;
                dupd = true;
                break;
            }
            allNames.add(other.getName());
        }
        if (dupd) {
            ValidationProblem problem = ValidationProblem.DuplicateServiceName;
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)composite, allServices, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{dupeService.getName()});
        }
        return null;
    }
}

