/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.switchyard.tools.cxf.Java2WSDLOptions;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.explorer.IComponentNode;
import org.switchyard.tools.ui.explorer.IComponentReference;
import org.switchyard.tools.ui.explorer.IComponentService;
import org.switchyard.tools.ui.explorer.IReferenceNode;
import org.switchyard.tools.ui.explorer.IServiceNode;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.CreateWSDLFromJavaOperation;
import org.switchyard.tools.ui.wizards.Java2WSDLOptionsWizardPage;

public class Java2WSDLWizard
extends BasicNewResourceWizard {
    private Java2WSDLOptionsWizardPage _optionsPage;
    private WizardNewFileCreationPage _filePage;
    private IFile _wsdlFile;

    public Java2WSDLWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.Java2WSDLWizard_wizardTitle);
    }

    public IFile getWSDLFile() {
        return this._wsdlFile;
    }

    public void addPages() {
        this._filePage = new WizardNewFileCreationPage("NewWSDLFilePage", (IStructuredSelection)StructuredSelection.EMPTY){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.setPageComplete(this.validatePage());
            }

            protected void createAdvancedControls(Composite parent) {
            }

            protected IStatus validateLinkedResource() {
                return Status.OK_STATUS;
            }

            protected void createLinkTarget() {
            }
        };
        this._filePage.setFileExtension("wsdl");
        this._filePage.setTitle(Messages.Java2WSDLWizard_wsdlFilePageTitle);
        this._filePage.setDescription(Messages.Java2WSDLWizard_wsdlFilePageDescription);
        this.setFilePageDefaults();
        this.addPage((IWizardPage)this._filePage);
        this._optionsPage = new Java2WSDLOptionsWizardPage();
        this._optionsPage.init(this.getSelection());
        this.addPage((IWizardPage)this._optionsPage);
    }

    public boolean performFinish() {
        final Java2WSDLOptions options = new Java2WSDLOptions();
        options.setLocationURI(this._optionsPage.getLocationURI());
        options.setServiceInterface(this._optionsPage.getServiceInterface());
        options.setTargetNamespace(this._optionsPage.getTargetNamespace());
        options.setUseImportedSchema(this._optionsPage.isUseImportedSchema());
        options.setServiceName(this._optionsPage.getServiceName());
        options.setWrapped(this._optionsPage.isUseWrappedMessages());
        this._wsdlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this._filePage.getContainerFullPath().append(this._filePage.getFileName()));
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    CreateWSDLFromJavaOperation op = new CreateWSDLFromJavaOperation(options, Java2WSDLWizard.this.getWSDLFile());
                    op.run(monitor);
                    final IStatus status = op.getStatus();
                    Activator.getDefault().getLog().log(status);
                    if (status.getSeverity() > 1) {
                        Java2WSDLWizard.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ErrorDialog.openError((Shell)Java2WSDLWizard.this.getContainer().getShell(), null, (String)Messages.Java2WSDLWizard_errorMessage_errorWhileGeneratingSchemaFiles, (IStatus)status);
                            }
                        });
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    Java2WSDLWizard.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)Java2WSDLWizard.this.getContainer().getShell(), null, (String)Messages.Java2WSDLWizard_errorMessage_errorWhileGeneratingWSDL, (IStatus)e.getStatus());
                        }
                    });
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
            this.selectAndReveal((IResource)this.getWSDLFile());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.fillInStackTrace();
        }
        return true;
    }

    private void setFilePageDefaults() {
        IStructuredSelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        for (Object selected : selection.toList()) {
            if (selected instanceof IContainer) {
                this._filePage.setContainerFullPath(((IContainer)selected).getFullPath());
                return;
            }
            if (selected instanceof IFile) {
                IFile file = (IFile)selected;
                IJavaElement javaElement = JavaCore.create((IFile)file);
                if (javaElement == null) {
                    this._filePage.setContainerFullPath(file.getParent().getFullPath());
                    this._filePage.setFileName(this.getBaseFileName(file.getName()));
                } else {
                    this.setFilePageDefaultsForJavaElement(javaElement);
                    if (this._filePage.getName() == null) {
                        this._filePage.setFileName(this.getBaseFileName(file.getName()));
                    }
                }
                return;
            }
            if (selected instanceof IJavaElement) {
                this.setFilePageDefaultsForJavaElement((IJavaElement)selected);
                return;
            }
            if (!(selected instanceof ISwitchYardNode)) continue;
            ISwitchYardNode switchYardNode = (ISwitchYardNode)selected;
            ISwitchYardProject switchYardProject = switchYardNode.getRoot().getSwitchYardProject();
            IJavaProject javaProject = JavaCore.create((IProject)switchYardProject.getProject());
            IResource root = JavaUtil.getFirstResourceRoot(javaProject);
            if (root == null) {
                this._filePage.setContainerFullPath(switchYardProject.getProject().getFullPath());
            } else {
                this._filePage.setContainerFullPath(root.getFullPath());
            }
            if (switchYardNode instanceof IServiceNode || switchYardNode instanceof IReferenceNode || switchYardNode instanceof IComponentNode || switchYardNode instanceof IComponentService || switchYardNode instanceof IComponentReference) {
                this._filePage.setFileName(switchYardNode.getName());
            }
            return;
        }
    }

    private void setFilePageDefaultsForJavaElement(IJavaElement javaElement) {
        int elementType;
        IResource root;
        switch (javaElement.getElementType()) {
            case 3: 
            case 4: {
                root = javaElement.getResource();
                break;
            }
            default: {
                root = JavaUtil.getFirstResourceRoot(javaElement.getJavaProject());
                if (root != null || (root = javaElement.getResource()).getType() != 1) break;
                root = root.getParent();
            }
        }
        if (root != null) {
            this._filePage.setContainerFullPath(root.getFullPath());
        }
        if ((elementType = javaElement.getElementType()) == 7) {
            this._filePage.setFileName(javaElement.getElementName());
        } else if (elementType == 5) {
            IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
            if (primaryType == null) {
                this.getBaseFileName(javaElement.getElementName());
            } else {
                this._filePage.setFileName(primaryType.getElementName());
            }
        }
    }

    private String getBaseFileName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return name;
        }
        return name.substring(0, dot);
    }

    protected IProject getTargetProject() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this._filePage.getContainerFullPath());
        return resource == null ? null : resource.getProject();
    }
}

