/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpel;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.wsdl.parsers.WsdlParser;
import org.eclipse.bpel.ui.wizards.NewBpelFileFirstPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.BPELImplementation;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.bpel.BPELProcessDetailsWizardPage;
import org.switchyard.tools.ui.bpel.Messages;
import org.switchyard.tools.ui.bpel.util.ICreationDetails;
import org.switchyard.tools.ui.bpel.util.IWSDLDetails;
import org.switchyard.tools.ui.bpel.util.NewBPELFileUtils;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.diagram.shared.BaseNewServiceFileWizard;

public class BPELComponentWizard
extends BaseNewServiceFileWizard
implements INewWizard {
    private static final String WSDL_PORTTYPE = "#wsdl.porttype(";
    private boolean _openAfterCreate;
    private BPELImplementation _implementation;
    private BPELProcessDetailsWizardPage _processPage;
    private Composite _container;

    public BPELComponentWizard(boolean openAfterCreate) {
        super(false, "bpel", EnumSet.of(InterfaceControl.InterfaceType.WSDL));
        this._openAfterCreate = openAfterCreate;
    }

    public void init(Composite container) {
        super.init(container);
        this._container = container;
    }

    public void addPages() {
        super.addPages();
        WizardNewFileCreationPage page = this.getFileCreationPage();
        page.setTitle(Messages.BPELComponentWizard_wizardPageTitle);
        page.setDescription(Messages.BPELComponentWizard_wizardPageDescription);
        if (this.getService() == null) {
            page.setFileName("Process.bpel");
        } else {
            page.setFileName(this.getService().getName() + "Process.bpel");
        }
        this._processPage = new BPELProcessDetailsWizardPage(BPELProcessDetailsWizardPage.class.getCanonicalName());
        if (this._container != null) {
            this._processPage.setProcessNamespace(this._container.getTargetNamespace());
        }
        this.addPage((IWizardPage)this._processPage);
    }

    public boolean canFinish() {
        this._processPage.update(this.getJavaProject(), this.getFileCreationPage().getFileName(), this.getService());
        return super.canFinish();
    }

    public boolean performFinish() {
        this._implementation = ScaFactory.eINSTANCE.createBPELImplementation();
        if (!super.performFinish()) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    new NewBPELFileUtils(new CreationDetails(), null, new WSDLDetails(), BPELComponentWizard.this.getCreatedFile()).createResourcesFromWsdl(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof CoreException) {
                Activator.getDefault().getLog().log(((CoreException)realException).getStatus());
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.BPELComponentWizard_errorMessageCreatingBPELFile, realException));
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.BPELComponentWizard_errorMessageCreatingBPELService, (String)realException.getMessage());
        }
        String processName = this._processPage.getProcessName();
        String prefix = processName.length() == 0 ? processName : String.valueOf(processName.substring(0, 1).toLowerCase()) + processName.substring(1, processName.length());
        this._implementation.setProcess(new QName(this._processPage.getProcessNamespace(), processName, prefix));
        if (!this._openAfterCreate) {
            return true;
        }
        final IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)BPELComponentWizard.this.getCreatedFile(), (boolean)true);
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.BPELComponentWizard_errorMessageOpeningBPELFile, (Throwable)e));
                    }
                }
            });
        }
        return true;
    }

    protected Implementation createImplementation() {
        return this._implementation;
    }

    protected List<ComponentReference> createReferences() {
        return Collections.emptyList();
    }

    protected InputStream getInitialContents() {
        return null;
    }

    private final class CreationDetails
    implements ICreationDetails {
        private CreationDetails() {
        }

        @Override
        public String getProcessName() {
            return BPELComponentWizard.this._processPage.getProcessName();
        }

        @Override
        public String getProcessNamespace() {
            return BPELComponentWizard.this._processPage.getProcessNamespace();
        }

        @Override
        public boolean isAbstractProcess() {
            return false;
        }

        @Override
        public NewBpelFileFirstPage.BpelCreationMode getCreationMode() {
            return NewBpelFileFirstPage.BpelCreationMode.GENERATE_BPEL_FROM_WSDL;
        }

        @Override
        public String getServiceName() {
            return BPELComponentWizard.this.getService().getName();
        }
    }

    private final class WSDLDetails
    implements IWSDLDetails {
        private PortType _portType;

        private WSDLDetails() {
        }

        @Override
        public String getWsdlUrl() {
            BaseNewServiceFileWizard.ServiceImplementationFileCreationPage page = (BaseNewServiceFileWizard.ServiceImplementationFileCreationPage)BPELComponentWizard.this.getFileCreationPage();
            Interface wizardInterface = page.getContractControl().getInterfaceControl().getInterface();
            BPELComponentWizard.this.getService().setInterface(wizardInterface);
            WSDLPortType portType = (WSDLPortType)BPELComponentWizard.this.getService().getInterface();
            String intf = portType.getInterface();
            return intf.substring(0, intf.indexOf(35));
        }

        @Override
        public boolean isImportWsdl() {
            return false;
        }

        @Override
        public PortType getPortType() {
            if (this._portType == null) {
                String portTypeURL = ((WSDLPortType)BPELComponentWizard.this.getService().getInterface()).getInterface();
                String portTypeName = portTypeURL.substring(portTypeURL.indexOf(BPELComponentWizard.WSDL_PORTTYPE) + BPELComponentWizard.WSDL_PORTTYPE.length(), portTypeURL.length() - 1);
                IFile wsdlFile = (IFile)SwitchYardModelUtils.getJavaResource((IProject)BPELComponentWizard.this.getCreatedFile().getProject(), (String)portTypeURL);
                ResourceSet rs = WsdlParser.createBasicResourceSetForWsdl();
                Definition definition = WsdlParser.loadWsdlDefinition((URI)URI.createPlatformResourceURI((String)wsdlFile.getFullPath().toString(), (boolean)true), (ResourceSet)rs);
                this._portType = (PortType)definition.getPortType(new QName(definition.getTargetNamespace(), portTypeName));
                for (Resource resource : rs.getResources()) {
                    try {
                        resource.unload();
                    }
                    catch (Exception e) {
                        e.fillInStackTrace();
                    }
                }
            }
            return this._portType;
        }
    }
}

