/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpel;

import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.ui.bpel.Messages;

public class BPELProcessDetailsWizardPage
extends WizardPage {
    private String _processName;
    private Text _processNameText;
    private String _processNamespace;
    private Text _processNamespaceText;
    private String _oldProcessName;

    public BPELProcessDetailsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.BPELProcessDetailsWizardPage_wizardPageTitle);
        this.setDescription(Messages.BPELProcessDetailsWizardPage_wizardPageDescription);
    }

    public void createControl(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(contents, Messages.BPELProcessDetailsWizardPage_processNameLabel);
        this._processNameText = new Text(contents, 2052);
        this._processNameText.setLayoutData((Object)new GridData(768));
        this._processNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BPELProcessDetailsWizardPage.this._processName = BPELProcessDetailsWizardPage.this._processNameText.getText();
                BPELProcessDetailsWizardPage.this.validate();
            }
        });
        this.createLabel(contents, Messages.BPELProcessDetailsWizardPage_processNamespaceLabel);
        this._processNamespaceText = new Text(contents, 2052);
        this._processNamespaceText.setLayoutData((Object)new GridData(768));
        this._processNamespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BPELProcessDetailsWizardPage.this._processNamespace = BPELProcessDetailsWizardPage.this._processNamespaceText.getText();
                BPELProcessDetailsWizardPage.this.validate();
            }
        });
        this.initControls();
        this.validate();
        this.setErrorMessage(null);
        this.setControl((Control)contents);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    public String getProcessName() {
        return this.nullForEmpty(this._processName);
    }

    public void setProcessName(String processName) {
        if (this._processNameText == null) {
            this._processName = processName;
        } else {
            this._processNameText.setText(processName);
        }
    }

    public String getProcessNamespace() {
        return this.emptyForNull(this._processNamespace);
    }

    public void setProcessNamespace(String processNamespace) {
        if (this._processNamespaceText == null) {
            this._processNamespace = processNamespace;
        } else {
            this._processNamespaceText.setText(processNamespace);
        }
    }

    public void update(IJavaProject project, String bpmnFileName, ComponentService service) {
        String newServiceName = this.emptyForNull(new Path(bpmnFileName).removeFileExtension().lastSegment());
        if (this.updateDefault(this._oldProcessName, newServiceName, this._processNameText.getText())) {
            this.setProcessName(newServiceName);
        }
        this._oldProcessName = newServiceName;
    }

    private boolean updateDefault(String oldValue, String newValue, String currentValue) {
        return !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || currentValue.length() == 0 || oldValue.equals(currentValue));
    }

    private String emptyForNull(String string) {
        return string == null ? "" : string;
    }

    private String nullForEmpty(String string) {
        return string == null ? null : (string.length() == 0 ? null : string);
    }

    private void initControls() {
        this.setProcessNamespace(this.emptyForNull(this._processNamespace));
        this.setProcessName(this.emptyForNull(this._processName));
    }

    private void validate() {
        this.setErrorMessage(null);
        if (this.getProcessName() == null) {
            this.setErrorMessage(Messages.BPELProcessDetailsWizardPage_errorMessageSpecifyName);
        } else if (this.getProcessNamespace() == null) {
            this.setErrorMessage(Messages.BPELProcessDetailsWizardPage_errorMessageSpecifyNamespace);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

