/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ErrorHandlerType implements Enumerator
{
    DEFAULT_ERROR_HANDLER(0, "DefaultErrorHandler", "DefaultErrorHandler"),
    DEAD_LETTER_CHANNEL(1, "DeadLetterChannel", "DeadLetterChannel"),
    LOGGING_ERROR_HANDLER(2, "LoggingErrorHandler", "LoggingErrorHandler"),
    NO_ERROR_HANDLER(3, "NoErrorHandler", "NoErrorHandler"),
    TRANSACTION_ERROR_HANDLER(4, "TransactionErrorHandler", "TransactionErrorHandler");

    public static final int DEFAULT_ERROR_HANDLER_VALUE = 0;
    public static final int DEAD_LETTER_CHANNEL_VALUE = 1;
    public static final int LOGGING_ERROR_HANDLER_VALUE = 2;
    public static final int NO_ERROR_HANDLER_VALUE = 3;
    public static final int TRANSACTION_ERROR_HANDLER_VALUE = 4;
    private static final ErrorHandlerType[] VALUES_ARRAY;
    public static final List<ErrorHandlerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ErrorHandlerType[]{DEFAULT_ERROR_HANDLER, DEAD_LETTER_CHANNEL, LOGGING_ERROR_HANDLER, NO_ERROR_HANDLER, TRANSACTION_ERROR_HANDLER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ErrorHandlerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ErrorHandlerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ErrorHandlerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ErrorHandlerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ErrorHandlerType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_ERROR_HANDLER;
            }
            case 1: {
                return DEAD_LETTER_CHANNEL;
            }
            case 2: {
                return LOGGING_ERROR_HANDLER;
            }
            case 3: {
                return NO_ERROR_HANDLER;
            }
            case 4: {
                return TRANSACTION_ERROR_HANDLER;
            }
        }
        return null;
    }

    private ErrorHandlerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

