/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExchangePattern implements Enumerator
{
    IN_ONLY(0, "InOnly", "InOnly"),
    ROBUST_IN_ONLY(1, "RobustInOnly", "RobustInOnly"),
    IN_OUT(2, "InOut", "InOut"),
    IN_OPTIONAL_OUT(3, "InOptionalOut", "InOptionalOut"),
    OUT_ONLY(4, "OutOnly", "OutOnly"),
    ROBUST_OUT_ONLY(5, "RobustOutOnly", "RobustOutOnly"),
    OUT_IN(6, "OutIn", "OutIn"),
    OUT_OPTIONAL_IN(7, "OutOptionalIn", "OutOptionalIn");

    public static final int IN_ONLY_VALUE = 0;
    public static final int ROBUST_IN_ONLY_VALUE = 1;
    public static final int IN_OUT_VALUE = 2;
    public static final int IN_OPTIONAL_OUT_VALUE = 3;
    public static final int OUT_ONLY_VALUE = 4;
    public static final int ROBUST_OUT_ONLY_VALUE = 5;
    public static final int OUT_IN_VALUE = 6;
    public static final int OUT_OPTIONAL_IN_VALUE = 7;
    private static final ExchangePattern[] VALUES_ARRAY;
    public static final List<ExchangePattern> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExchangePattern[]{IN_ONLY, ROBUST_IN_ONLY, IN_OUT, IN_OPTIONAL_OUT, OUT_ONLY, ROBUST_OUT_ONLY, OUT_IN, OUT_OPTIONAL_IN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExchangePattern get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExchangePattern result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExchangePattern getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExchangePattern result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExchangePattern get(int value) {
        switch (value) {
            case 0: {
                return IN_ONLY;
            }
            case 1: {
                return ROBUST_IN_ONLY;
            }
            case 2: {
                return IN_OUT;
            }
            case 3: {
                return IN_OPTIONAL_OUT;
            }
            case 4: {
                return OUT_ONLY;
            }
            case 5: {
                return ROBUST_OUT_ONLY;
            }
            case 6: {
                return OUT_IN;
            }
            case 7: {
                return OUT_OPTIONAL_IN;
            }
        }
        return null;
    }

    private ExchangePattern(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

