/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ThreadPoolRejectedPolicy implements Enumerator
{
    ABORT(0, "Abort", "Abort"),
    CALLER_RUNS(1, "CallerRuns", "CallerRuns"),
    DISCARD_OLDEST(2, "DiscardOldest", "DiscardOldest"),
    DISCARD(3, "Discard", "Discard");

    public static final int ABORT_VALUE = 0;
    public static final int CALLER_RUNS_VALUE = 1;
    public static final int DISCARD_OLDEST_VALUE = 2;
    public static final int DISCARD_VALUE = 3;
    private static final ThreadPoolRejectedPolicy[] VALUES_ARRAY;
    public static final List<ThreadPoolRejectedPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ThreadPoolRejectedPolicy[]{ABORT, CALLER_RUNS, DISCARD_OLDEST, DISCARD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ThreadPoolRejectedPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThreadPoolRejectedPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThreadPoolRejectedPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThreadPoolRejectedPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThreadPoolRejectedPolicy get(int value) {
        switch (value) {
            case 0: {
                return ABORT;
            }
            case 1: {
                return CALLER_RUNS;
            }
            case 2: {
                return DISCARD_OLDEST;
            }
            case 3: {
                return DISCARD;
            }
        }
        return null;
    }

    private ThreadPoolRejectedPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

