/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.transform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JavaTransformType implements Enumerator
{
    XML2JAVA(0, "XML2JAVA", "XML2JAVA"),
    JAVA2XML(1, "JAVA2XML", "JAVA2XML");

    public static final int XML2JAVA_VALUE = 0;
    public static final int JAVA2XML_VALUE = 1;
    private static final JavaTransformType[] VALUES_ARRAY;
    public static final List<JavaTransformType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JavaTransformType[]{XML2JAVA, JAVA2XML};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JavaTransformType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JavaTransformType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JavaTransformType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JavaTransformType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JavaTransformType get(int value) {
        switch (value) {
            case 0: {
                return XML2JAVA;
            }
            case 1: {
                return JAVA2XML;
            }
        }
        return null;
    }

    private JavaTransformType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

