/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.editor;

import java.util.List;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.features.CustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.BooleanObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ComboObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.IntObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.NCNameObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmCustomTaskDetailComposite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.switchyard.tools.ui.bpmn2.Messages;
import org.switchyard.tools.ui.bpmn2.editor.FaultActionObjectEditor;
import org.switchyard.tools.ui.bpmn2.editor.FaultSignalIdObjectEditor;

public class SwitchYardCustomTaskPropertiesComposite
extends JbpmCustomTaskDetailComposite {
    public SwitchYardCustomTaskPropertiesComposite(Composite parent, int style) {
        super(parent, style);
    }

    public SwitchYardCustomTaskPropertiesComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    protected void createInputParameterBindings(Task task) {
        String id;
        this.migrateTaskName(task);
        ModelExtensionDescriptor med = null;
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((EObject)task);
        if (adapter != null) {
            med = (ModelExtensionDescriptor)adapter.getProperty(ModelExtensionDescriptor.class);
        }
        if (med == null && (id = CustomElementFeatureContainer.findId((EObject)task)) != null) {
            TargetRuntime rt = TargetRuntime.getRuntime((EObject)task);
            med = rt.getCustomTask(id);
        }
        if (med != null) {
            List props = med.getProperties("ioSpecification/dataInputs/name");
            InputOutputSpecification ioSpec = task.getIoSpecification();
            if (ioSpec == null) {
                ioSpec = this.copyCreateModelObject(InputOutputSpecification.class);
                InsertionAdapter.add((EObject)task, (EStructuralFeature)PACKAGE.getActivity_IoSpecification(), (EObject)ioSpec);
            }
            for (ModelExtensionDescriptor.Property property : props) {
                ComboObjectEditor editor;
                String name = property.getFirstStringValue();
                DataInput parameter = null;
                DataAssociation association = null;
                block1: for (DataInput di : ioSpec.getDataInputs()) {
                    this.migrateOldInputs(di);
                    if (!name.equals(di.getName())) continue;
                    parameter = di;
                    for (DataAssociation da : task.getDataInputAssociations()) {
                        if (da.getTargetRef() != di) continue;
                        association = da;
                        break block1;
                    }
                }
                if (parameter == null) {
                    parameter = this.copyCreateModelObject(DataInput.class);
                    parameter.setName(name);
                    InsertionAdapter.add((EObject)ioSpec, (EStructuralFeature)PACKAGE.getInputOutputSpecification_DataInputs(), (EObject)parameter);
                    InputSet inputSet = null;
                    if (ioSpec.getInputSets().size() == 0) {
                        inputSet = this.copyCreateModelObject(InputSet.class);
                        InsertionAdapter.add((EObject)ioSpec, (EStructuralFeature)PACKAGE.getInputOutputSpecification_InputSets(), (EObject)inputSet);
                    } else {
                        inputSet = (InputSet)ioSpec.getInputSets().get(0);
                    }
                    InsertionAdapter.add((EObject)inputSet, (EStructuralFeature)PACKAGE.getInputSet_DataInputRefs(), (EObject)parameter);
                }
                if (association == null) {
                    association = (DataAssociation)this.copyCreateModelObject(DataInputAssociation.class);
                    association.setTargetRef((ItemAwareElement)parameter);
                    InsertionAdapter.add((EObject)task, (EStructuralFeature)PACKAGE.getActivity_DataInputAssociations(), (EObject)association);
                }
                FormalExpression fromExpression = null;
                Assignment assignment = null;
                if (association.getAssignment().size() == 1) {
                    assignment = (Assignment)association.getAssignment().get(0);
                    fromExpression = (FormalExpression)assignment.getFrom();
                }
                if (assignment == null) {
                    assignment = this.copyCreateModelObject(Assignment.class);
                    FormalExpression toExpression = this.copyCreateModelObject(FormalExpression.class);
                    toExpression.setBody(parameter.getId());
                    toExpression.setLanguage("http://www.mvel.org/2.0");
                    assignment.setTo((Expression)toExpression);
                    InsertionAdapter.add((EObject)association, (EStructuralFeature)PACKAGE.getDataAssociation_Assignment(), (EObject)assignment);
                }
                if (fromExpression == null) {
                    fromExpression = this.copyCreateModelObject(FormalExpression.class);
                    fromExpression.setLanguage("http://www.mvel.org/2.0");
                    InsertionAdapter.add((EObject)assignment, (EStructuralFeature)PACKAGE.getAssignment_From(), (EObject)fromExpression);
                }
                EAttribute attribute = PACKAGE.getFormalExpression_Body();
                String dataType = property.type;
                if ("FaultAction".equals(name)) {
                    editor = new FaultActionObjectEditor((AbstractDetailComposite)this, fromExpression);
                    editor.createControl(this.getAttributesParent(), "Fault Action");
                    continue;
                }
                if ("FaultName".equals(name)) {
                    editor = this.createTextObjectEditor(association, fromExpression, attribute);
                    editor.setMultiLine(false);
                    editor.createControl(this.getAttributesParent(), "Fault Name");
                    continue;
                }
                if ("FaultEventId".equals(name)) {
                    editor = new FaultSignalIdObjectEditor((AbstractDetailComposite)this, fromExpression);
                } else if ("EInt".equals(dataType)) {
                    editor = new IntObjectEditor((AbstractDetailComposite)this, (EObject)fromExpression, (EStructuralFeature)attribute);
                } else if ("EBoolean".equals(dataType)) {
                    editor = new BooleanObjectEditor((AbstractDetailComposite)this, (EObject)fromExpression, (EStructuralFeature)attribute);
                } else if ("ID".equals(dataType)) {
                    editor = new NCNameObjectEditor((AbstractDetailComposite)this, (EObject)fromExpression, (EStructuralFeature)attribute);
                } else {
                    editor = this.createTextObjectEditor(association, fromExpression, attribute);
                    ((TextObjectEditor)editor).setMultiLine(false);
                }
                editor.createControl(this.getAttributesParent(), ModelUtil.toCanonicalString((String)name));
            }
        }
    }

    private TextObjectEditor createTextObjectEditor(final DataAssociation association, FormalExpression fromExpression, EAttribute attribute) {
        return new TextObjectEditor((AbstractDetailComposite)this, (EObject)fromExpression, (EStructuralFeature)attribute){

            protected String getText() {
                List sources = association.getSourceRef();
                if (sources == null || sources.isEmpty()) {
                    return super.getText();
                }
                return ModelUtil.getTextValue(sources.get(0));
            }

            public boolean setValue(Object result) {
                if (result != null && result.equals(this.getText())) {
                    return false;
                }
                if (super.setValue(result)) {
                    final List sources = association.getSourceRef();
                    if (sources != null && sources.size() > 0) {
                        TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                sources.clear();
                            }
                        });
                        this.updateText();
                    }
                    return true;
                }
                return false;
            }

            protected Control createControl(Composite composite, String label, int style) {
                Control control = super.createControl(composite, label, style);
                this.updateText();
                return control;
            }

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (association == notification.getNotifier() && notification.getFeature() == Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef()) {
                    this.updateText();
                }
            }
        };
    }

    private void migrateOldInputs(final DataInput di) {
        if ("FaultEventType".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateFaultEventTypeToFaultEventId){

                protected void doExecute() {
                    di.setName("FaultEventId");
                }
            });
        } else if ("FaultSignalId".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateFaultSignalIdToFaultEventId){

                protected void doExecute() {
                    di.setName("FaultEventId");
                }
            });
        } else if ("CompleteAfterFault".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateCompleteAfterFaultToFaultAction){

                protected void doExecute() {
                    di.setName("FaultAction");
                }
            });
        } else if ("messageContentIn".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateMessageContentInToParameterName){

                protected void doExecute() {
                    di.setName("ParameterName");
                }
            });
        } else if ("ContentInputName".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateContentInputNameToParameterName){

                protected void doExecute() {
                    di.setName("ParameterName");
                }
            });
        } else if ("messageContentOut".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateMessageContentOutToResultName){

                protected void doExecute() {
                    di.setName("ResultName");
                }
            });
        } else if ("ContentOutputName".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateContentOutputNameToResultName){

                protected void doExecute() {
                    di.setName("ResultName");
                }
            });
        } else if ("FaultWorkItemAction".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateFaultWorkItemActionToFaultAction){

                protected void doExecute() {
                    di.setName("FaultAction");
                }
            });
        } else if ("FaultResultName".equals(di.getName())) {
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateFaultResultNameToFaultName){

                protected void doExecute() {
                    di.setName("FaultName");
                }
            });
        }
    }

    private void migrateTaskName(final Task task) {
        List features = ModelUtil.getAnyAttributes((EObject)task);
        for (EStructuralFeature f : features) {
            if (!"taskName".equals(f.getName()) || !"SwitchYard Service".equals(task.getAnyAttribute().get(f, false))) continue;
            final EStructuralFeature taskNameFeature = f;
            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.label_updateSwitchYardServiceToSwitchYardServiceTask){

                protected void doExecute() {
                    task.getAnyAttribute().set(taskNameFeature, (Object)"SwitchYard Service Task");
                }
            });
        }
    }

    private <T extends EObject> T copyCreateModelObject(Class<T> clazz) {
        EObject object = null;
        EClass eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(clazz.getSimpleName());
        if (eClass != null) {
            object = (EObject)clazz.cast(Bpmn2Factory.eINSTANCE.create(eClass));
            ModelUtil.setID((EObject)object, (Resource)ModelUtil.getResource((EObject)this.businessObject));
        }
        return (T)object;
    }
}

