/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.switchyard.tools.ui.debug";
    private static Activator plugin;
    private static AtomicBoolean _formattersAdded;
    private IDebugEventSetListener _debugListener;

    static {
        _formattersAdded = new AtomicBoolean();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.addDebugEventListener();
    }

    public void stop(BundleContext context) throws Exception {
        this.removeDebugEventListener();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void addDebugEventListener() {
        if (this._debugListener == null) {
            this._debugListener = new SwitchYardDebugEventSetListener();
            DebugPlugin.getDefault().addDebugEventListener(this._debugListener);
        }
    }

    private void removeDebugEventListener() {
        if (this._debugListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this._debugListener);
            this._debugListener = null;
        }
    }

    private static final class AddDetailFormattersJob
    extends UIJob {
        private AddDetailFormattersJob() {
            super("Add SwitchYard detail formatters");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            HashSet<String> types = new HashSet<String>();
            String[] existingFormatters = JavaDebugOptionsManager.parseList((String)JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
            if (existingFormatters.length % 3 != 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, "Error adding SwitchYard detail formatters.  The preference format has changed!"));
                return Status.OK_STATUS;
            }
            int i = 0;
            int length = existingFormatters.length;
            while (i < length) {
                types.add(existingFormatters[i]);
                i += 3;
            }
            ArrayList<String> copy = new ArrayList<String>(Arrays.asList(existingFormatters));
            if (!types.contains("org.switchyard.ExchangePhase")) {
                copy.add("org.switchyard.ExchangePhase");
                copy.add("toString()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.ExchangeState")) {
                copy.add("org.switchyard.ExchangeState");
                copy.add("toString()");
                copy.add("1");
            }
            if (!types.contains("javax.xml.namespace.QName")) {
                copy.add("javax.xml.namespace.QName");
                copy.add("getLocalPart() + ( getNamespaceURI() == null || \"\".equals(getNamespaceURI()) ? \"\" : \" {\" + getNamespaceURI() + \"}\")");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.Property")) {
                copy.add("org.switchyard.Property");
                copy.add("getName() + \" = \" + getValue()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.extensions.wsdl.WSDLService")) {
                copy.add("org.switchyard.extensions.wsdl.WSDLService");
                copy.add("getPortType().getLocalPart()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.internal.ServiceImpl")) {
                copy.add("org.switchyard.internal.ServiceImpl");
                copy.add("getName().getLocalPart() + \" (\" + getClass().getSimpleName() + \")\"");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.metadata.ServiceOperation")) {
                copy.add("org.switchyard.metadata.ServiceOperation");
                copy.add("getName()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.metadata.BaseService")) {
                copy.add("org.switchyard.metadata.BaseService");
                copy.add("getType() + \" (\" + getClass().getSimpleName() + \")\"");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.Scope")) {
                copy.add("org.switchyard.Scope");
                copy.add("toString()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.extensions.java.JavaService")) {
                copy.add("org.switchyard.extensions.java.JavaService");
                copy.add("getJavaInterface()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.Service")) {
                copy.add("org.switchyard.Service");
                copy.add("getName().toString()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.bus.camel.CamelExchangeProperty")) {
                copy.add("org.switchyard.bus.camel.CamelExchangeProperty");
                copy.add("getName() + \" = \" + getValue() + \" (\" + getClass().getSimpleName() + \")\"");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.ExchangePattern")) {
                copy.add("org.switchyard.ExchangePattern");
                copy.add("toString()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.ServiceReference")) {
                copy.add("org.switchyard.ServiceReference");
                copy.add("getName().toString()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.metadata.ExchangeContract")) {
                copy.add("org.switchyard.metadata.ExchangeContract");
                copy.add("\"\" + getConsumerOperation().getName() + \" => \" + getProviderOperation().getName()");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.bus.camel.CamelMessageProperty")) {
                copy.add("org.switchyard.bus.camel.CamelMessageProperty");
                copy.add("getName() +\" = \" + getValue() + \" (\" + getClass().getSimpleName() + \")\"");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.metadata.BaseExchangeContract")) {
                copy.add("org.switchyard.metadata.BaseExchangeContract");
                copy.add("getConsumerOperation().getName() + \" => \" + (getProviderOperation() == null ? \"<null>\" : getProviderOperation().getName()) + \" (\" + getClass().getSimpleName() + \")\"");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.internal.ServiceReferenceImpl")) {
                copy.add("org.switchyard.internal.ServiceReferenceImpl");
                copy.add("getName().getLocalPart() + \" (\" + getClass().getSimpleName() + \")\"");
                copy.add("1");
            }
            if (!types.contains("org.switchyard.metadata.InOutOperation")) {
                copy.add("org.switchyard.metadata.InOutOperation");
                copy.add("getName() + \" (\" + getClass().getSimpleName() + \")\"");
                copy.add("1");
            }
            JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, JavaDebugOptionsManager.serializeList((String[])copy.toArray(new String[copy.size()])));
            return Status.OK_STATUS;
        }
    }

    private static final class SwitchYardDebugEventSetListener
    implements IDebugEventSetListener {
        private SwitchYardDebugEventSetListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint[] breakpoints;
                IJavaDebugTarget target;
                DebugEvent event = debugEventArray[n2];
                if (event.getKind() == 4 && event.getSource() instanceof IJavaDebugTarget && "debug".equals((target = (IJavaDebugTarget)event.getSource()).getLaunch().getLaunchMode()) && (breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(Activator.PLUGIN_ID)) != null && breakpoints.length != 0) {
                    int n3;
                    IResource[] resources = null;
                    try {
                        resources = target.getLaunch().getLaunchConfiguration().getMappedResources();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (resources == null) {
                        IBreakpoint[] iBreakpointArray = breakpoints;
                        n3 = breakpoints.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBreakpoint breakpoint = iBreakpointArray[n4];
                            try {
                                if (breakpoint.isEnabled()) {
                                    target.breakpointAdded(breakpoint);
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            ++n4;
                        }
                    } else {
                        HashSet<IProject> projectSet = new HashSet<IProject>();
                        IResource[] iResourceArray = resources;
                        int n5 = resources.length;
                        n3 = 0;
                        while (n3 < n5) {
                            IResource resource = iResourceArray[n3];
                            this.addProjectBreakpoints(resource.getProject(), breakpoints, target, projectSet);
                            ++n3;
                        }
                    }
                    if (_formattersAdded.compareAndSet(false, true)) {
                        new AddDetailFormattersJob().schedule();
                    }
                }
                ++n2;
            }
        }

        private void addProjectBreakpoints(IProject project, IBreakpoint[] breakpoints, IJavaDebugTarget target, Set<IProject> seen) {
            if (!seen.add(project)) {
                return;
            }
            if (!project.isAccessible()) {
                return;
            }
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IProject breakpointProject = breakpoint.getMarker().getResource().getProject();
                if (project.equals((Object)breakpointProject)) {
                    try {
                        if (breakpoint.isEnabled()) {
                            target.breakpointAdded(breakpoint);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            try {
                IProjectDescription description = project.getDescription();
                IProject[] iProjectArray = description.getDynamicReferences();
                int n3 = iProjectArray.length;
                n = 0;
                while (n < n3) {
                    IProject referenced = iProjectArray[n];
                    this.addProjectBreakpoints(referenced, breakpoints, target, seen);
                    ++n;
                }
                iProjectArray = description.getReferencedProjects();
                n3 = iProjectArray.length;
                n = 0;
                while (n < n3) {
                    IProject referenced = iProjectArray[n];
                    this.addProjectBreakpoints(referenced, breakpoints, target, seen);
                    ++n;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

