/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.switchyard.tools.ui.debug.ServiceInteractionBreakpointDetailPane;
import org.switchyard.tools.ui.debug.TransformBreakpointDetailPane;
import org.switchyard.tools.ui.debug.ValidateBreakpointDetailPane;

public class BreakpointDetailPaneFactory
implements IDetailPaneFactory {
    public Set getDetailPaneTypes(IStructuredSelection selection) {
        HashSet<String> set = new HashSet<String>();
        if (selection.size() == 1) {
            IBreakpoint b = (IBreakpoint)selection.getFirstElement();
            try {
                String type = b.getMarker().getType();
                if ("org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker".equals(type)) {
                    set.add(ServiceInteractionBreakpointDetailPane.ID);
                } else if ("org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker".equals(type)) {
                    set.add(TransformBreakpointDetailPane.ID);
                } else if ("org.switchyard.tools.ui.debug.switchYardValidatorBreakpointMarker".equals(type)) {
                    set.add(ValidateBreakpointDetailPane.ID);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return set;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IBreakpoint b = (IBreakpoint)selection.getFirstElement();
            try {
                String type = b.getMarker().getType();
                if ("org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker".equals(type)) {
                    return ServiceInteractionBreakpointDetailPane.ID;
                }
                if ("org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker".equals(type)) {
                    return TransformBreakpointDetailPane.ID;
                }
                if ("org.switchyard.tools.ui.debug.switchYardValidatorBreakpointMarker".equals(type)) {
                    return ValidateBreakpointDetailPane.ID;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IDetailPane createDetailPane(String paneID) {
        if (ServiceInteractionBreakpointDetailPane.ID.equals(paneID)) {
            return new ServiceInteractionBreakpointDetailPane();
        }
        if (TransformBreakpointDetailPane.ID.equals(paneID)) {
            return new TransformBreakpointDetailPane();
        }
        if (ValidateBreakpointDetailPane.ID.equals(paneID)) {
            return new ValidateBreakpointDetailPane();
        }
        return null;
    }

    public String getDetailPaneName(String paneID) {
        if (ServiceInteractionBreakpointDetailPane.ID.equals(paneID)) {
            return "SwitchYard Service Breakpoint Settings";
        }
        if ("org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker".equals(paneID)) {
            return "SwitchYard Transform Breakpoint Settings";
        }
        if ("org.switchyard.tools.ui.debug.switchYardValidatorBreakpointMarker".equals(paneID)) {
            return "SwitchYard Validate Breakpoint Settings";
        }
        return null;
    }

    public String getDetailPaneDescription(String paneID) {
        return this.getDetailPaneName(paneID);
    }
}

