/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.switchyard.tools.ui.debug.CamelExchangeConditionBuilder;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;

public abstract class CamelProcessorBreakpoint
extends DelegatingJavaBreakpoint<String> {
    private static final String DELEGATE_KEY = CamelProcessorBreakpoint.class.getCanonicalName();
    private static final String SIGNATURE = "(Lorg/apache/camel/Exchange;)V";
    private static final String METHOD = "process";
    private final String _type;
    private final String _exchangeVariable;

    protected CamelProcessorBreakpoint(String type, String exchangeVariable) {
        this._type = type;
        this._exchangeVariable = exchangeVariable;
    }

    public CamelProcessorBreakpoint(IResource resource, IInteractionConfiguration configuration, boolean register, String type, String exchangeVariable, String markerId) throws CoreException {
        super(resource, configuration, register, markerId);
        this._type = type;
        this._exchangeVariable = exchangeVariable;
    }

    @Override
    protected void createDelegates() throws CoreException {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(this.getMarker().getAttributes());
        attributes.put("org.eclipse.debug.core.persisted", false);
        attributes.put("transient", true);
        IJavaMethodBreakpoint delegate = JDIDebugModel.createMethodBreakpoint((IResource)this.getMarker().getResource(), (String)this._type, (String)METHOD, (String)SIGNATURE, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)false, attributes);
        String condition = this.createCondition();
        if (condition != null) {
            delegate.setCondition(condition);
            delegate.setConditionEnabled(true);
        }
        delegate.setEnabled(this.isEnabled());
        this.addDelegate(DELEGATE_KEY, (JavaBreakpoint)delegate);
    }

    protected IJavaMethodBreakpoint getDelegate() {
        return (IJavaMethodBreakpoint)this.getDelegate(DELEGATE_KEY);
    }

    @Override
    protected void configurationUpdated() throws CoreException {
        IJavaMethodBreakpoint delegate = this.getDelegate();
        String newCondition = this.createCondition();
        String oldCondition = delegate.getCondition();
        if (newCondition == null) {
            if (oldCondition == null) {
                return;
            }
            delegate.setConditionEnabled(false);
            delegate.setCondition(null);
        } else {
            if (newCondition.equals(oldCondition)) {
                return;
            }
            delegate.setCondition(newCondition);
            if (!delegate.isConditionEnabled()) {
                delegate.setConditionEnabled(true);
            }
        }
        super.configurationUpdated();
    }

    protected String createCondition() {
        IInteractionConfiguration config = this.getInteractionConfiguration();
        if (config == null) {
            return null;
        }
        CamelExchangeConditionBuilder builder = new CamelExchangeConditionBuilder(this._exchangeVariable);
        Set<IInteractionConfiguration.TriggerType> triggers = config.getTriggers();
        String triggerCondition = builder.exchangePhase(triggers == null || triggers.isEmpty() ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : triggers);
        String providerCondition = builder.provider(config.getProviderName());
        String consumerCondition = builder.consumer(config.getConsumerName());
        StringBuffer buffer = new StringBuffer();
        if (triggerCondition != null) {
            buffer.append(triggerCondition);
        }
        if (providerCondition != null) {
            if (buffer.length() > 0) {
                buffer.append("\n        && ");
            }
            buffer.append(providerCondition);
        }
        if (consumerCondition != null) {
            if (buffer.length() > 0) {
                buffer.append("\n        && ");
            }
            buffer.append(consumerCondition);
        }
        if (buffer.length() == 0) {
            return null;
        }
        buffer.insert(0, '(');
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    protected void updateEnabled(boolean enabled) throws CoreException {
        this.getDelegate().setEnabled(enabled);
    }
}

