/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequest;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.ISwitchYardBreakpoint;
import org.switchyard.tools.ui.debug.InteractionConfigurationBuilder;

public abstract class DelegatingJavaBreakpoint<T>
extends JavaBreakpoint
implements ISwitchYardBreakpoint {
    private IInteractionConfiguration _interactionConfiguration;
    private Map<T, JavaBreakpoint> _delegates = new HashMap<T, JavaBreakpoint>();
    private boolean _creating;
    private String _markerId;

    protected DelegatingJavaBreakpoint() {
    }

    protected DelegatingJavaBreakpoint(final IResource resource, final IInteractionConfiguration configuration, final boolean register, final String markerId) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                DelegatingJavaBreakpoint.super.setMarker(resource.createMarker(markerId));
                Map<Object, Object> attributes = configuration == null ? new HashMap() : configuration.toAttributesMap();
                attributes.put("org.eclipse.debug.core.id", DelegatingJavaBreakpoint.this.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", true);
                if (!register) {
                    attributes.put("org.eclipse.debug.core.persisted", false);
                    attributes.put("transient", true);
                }
                DelegatingJavaBreakpoint.this.ensureMarker().setAttributes(attributes);
                DelegatingJavaBreakpoint.this.register(register);
            }
        };
        this._markerId = markerId;
        this.run(this.getMarkerRule(resource), wr);
        this._interactionConfiguration = configuration;
    }

    public String getMarkerId() {
        return this._markerId;
    }

    public void setMarker(IMarker marker) throws CoreException {
        this._markerId = marker.getType();
        super.setMarker(marker);
    }

    public synchronized IInteractionConfiguration getInteractionConfiguration() {
        if (this._interactionConfiguration == null) {
            this._interactionConfiguration = this.readInteractionConfiguration();
        }
        return this._interactionConfiguration;
    }

    public synchronized void setInteractionConfiguration(IInteractionConfiguration configuration) throws CoreException {
        if (configuration.equals(this._interactionConfiguration)) {
            return;
        }
        Map attributes = this.getMarker().getAttributes();
        attributes.putAll(configuration.toAttributesMap());
        this.setAttributes(attributes);
        this._interactionConfiguration = configuration;
        if (this._delegates.size() > 0) {
            this.configurationUpdated();
        }
    }

    protected IInteractionConfiguration readInteractionConfiguration() {
        try {
            return InteractionConfigurationBuilder.create().updateFrom(this.getMarker().getAttributes()).build();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected synchronized Map<T, JavaBreakpoint> getDelegates() {
        return this._delegates;
    }

    protected synchronized JavaBreakpoint getDelegate(T key) {
        return this._delegates.containsKey(key) ? this._delegates.get(key) : null;
    }

    protected synchronized void addDelegate(T key, JavaBreakpoint delegate) {
        this._delegates.put(key, delegate);
        if (this.fInstalledTargets != null && !this._creating) {
            for (IJavaDebugTarget target : this.fInstalledTargets) {
                try {
                    delegate.addToTarget((JDIDebugTarget)target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected abstract void createDelegates() throws CoreException;

    protected void configurationUpdated() throws CoreException {
        if (this.fInstalledTargets != null && !this._creating) {
            for (IJavaDebugTarget target : this.fInstalledTargets) {
                for (JavaBreakpoint delegate : this._delegates.values()) {
                    try {
                        if (delegate == null) continue;
                        delegate.removeFromTarget((JDIDebugTarget)target);
                        delegate.addToTarget((JDIDebugTarget)target);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected synchronized void clearDelegates() {
        for (JavaBreakpoint delegate : this._delegates.values()) {
            try {
                if (delegate == null) continue;
                if (this.fInstalledTargets != null) {
                    for (IJavaDebugTarget target : this.fInstalledTargets) {
                        try {
                            delegate.removeFromTarget((JDIDebugTarget)target);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                delegate.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this._delegates.clear();
    }

    protected abstract void updateEnabled(boolean var1) throws CoreException;

    public String getModelIdentifier() {
        return "org.switchyard.tools.ui.debug";
    }

    public void delete() throws CoreException {
        for (IJavaBreakpoint iJavaBreakpoint : this._delegates.values()) {
            try {
                if (iJavaBreakpoint == null) continue;
                iJavaBreakpoint.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.delete();
    }

    public void setEnabled(boolean enabled) throws CoreException {
        if (this._delegates.size() > 0 && enabled != this.isEnabled()) {
            this.updateEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public String getTypeName() throws CoreException {
        return null;
    }

    public int getHitCount() throws CoreException {
        return 0;
    }

    public void setHitCount(int count) throws CoreException {
    }

    public void setSuspendPolicy(int suspendPolicy) throws CoreException {
        for (IJavaBreakpoint iJavaBreakpoint : this._delegates.values()) {
            try {
                if (iJavaBreakpoint == null) continue;
                iJavaBreakpoint.setSuspendPolicy(suspendPolicy);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.setSuspendPolicy(suspendPolicy);
    }

    public void setThreadFilter(IJavaThread thread) throws CoreException {
        for (IJavaBreakpoint iJavaBreakpoint : this._delegates.values()) {
            try {
                if (iJavaBreakpoint == null) continue;
                iJavaBreakpoint.setThreadFilter(thread);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.setThreadFilter(thread);
    }

    public void removeThreadFilter(IJavaDebugTarget target) throws CoreException {
        for (IJavaBreakpoint iJavaBreakpoint : this._delegates.values()) {
            try {
                if (iJavaBreakpoint == null) continue;
                iJavaBreakpoint.removeThreadFilter(target);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.removeThreadFilter(target);
    }

    public void addInstanceFilter(IJavaObject object) throws CoreException {
    }

    public void removeInstanceFilter(IJavaObject object) throws CoreException {
    }

    public boolean supportsInstanceFilters() {
        return false;
    }

    public IJavaObject[] getInstanceFilters() {
        return new IJavaObject[0];
    }

    public boolean supportsThreadFilters() {
        return true;
    }

    public synchronized void addToTarget(JDIDebugTarget target) throws CoreException {
        if (this._delegates.size() == 0) {
            this._creating = true;
            try {
                this.createDelegates();
            }
            finally {
                this._creating = false;
            }
        }
        for (JavaBreakpoint delegate : this._delegates.values()) {
            try {
                if (delegate == null) continue;
                delegate.addToTarget(target);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.addToTarget(target);
        this.incrementInstallCount();
        this.fireInstalled((IJavaDebugTarget)target);
    }

    protected void createRequests(JDIDebugTarget target) throws CoreException {
    }

    public synchronized void removeFromTarget(JDIDebugTarget target) throws CoreException {
        for (JavaBreakpoint delegate : this._delegates.values()) {
            try {
                if (delegate == null) continue;
                delegate.removeFromTarget(target);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.removeFromTarget(target);
        if (this.markerExists()) {
            this.decrementInstallCount();
        }
        if (!this.isInstalled()) {
            this.clearDelegates();
        }
    }

    public void setExpired(boolean expired) throws CoreException {
        for (JavaBreakpoint delegate : this._delegates.values()) {
            try {
                if (delegate == null) continue;
                delegate.setExpired(expired);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.setExpired(expired);
    }

    protected void addInstanceFilter(EventRequest request, ObjectReference object) {
    }

    protected EventRequest[] newRequests(JDIDebugTarget target, ReferenceType type) throws CoreException {
        return new EventRequest[0];
    }

    protected void setRequestThreadFilter(EventRequest request, ThreadReference thread) {
    }
}

