/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.SwitchYardExchangeConditionBuilder;

public abstract class ServiceHandlerBreakpoint
extends DelegatingJavaBreakpoint<String> {
    private static final String SIGNATURE = "(Lorg/switchyard/Exchange;)V";
    protected static final String HANDLE_MESSAGE = "handleMessage";
    protected static final String HANDLE_FAULT = "handleFault";
    private final String _type;
    private final String _exchangeVariable;

    protected ServiceHandlerBreakpoint(String type, String exchangeVariable) {
        this._type = type;
        this._exchangeVariable = exchangeVariable;
    }

    public ServiceHandlerBreakpoint(IResource resource, IInteractionConfiguration configuration, boolean register, String type, String exchangeVariable, String markerId) throws CoreException {
        super(resource, configuration, register, markerId);
        this._type = type;
        this._exchangeVariable = exchangeVariable;
    }

    @Override
    protected void createDelegates() throws CoreException {
        HashMap<String, Object> messageAttributes = new HashMap<String, Object>(this.getMarker().getAttributes());
        messageAttributes.put("org.eclipse.debug.core.persisted", false);
        messageAttributes.put("transient", true);
        HashMap<String, Object> faultAttributes = new HashMap<String, Object>(messageAttributes);
        faultAttributes.put("org.eclipse.debug.core.enabled", this.isEnabled() && this.triggersOnFault());
        IJavaMethodBreakpoint handleMessageDelegate = this.createHandleMessageDelegate(messageAttributes);
        IJavaMethodBreakpoint handleFaultDelegate = this.createHandleFaultDelegate(faultAttributes);
        this.setMessageCondition(handleMessageDelegate);
        this.setFaultCondition(handleFaultDelegate);
        this.addDelegate(HANDLE_MESSAGE, (JavaBreakpoint)handleMessageDelegate);
        this.addDelegate(HANDLE_FAULT, (JavaBreakpoint)handleFaultDelegate);
        this.updateEnabled(this.isEnabled());
    }

    protected IJavaMethodBreakpoint createHandleMessageDelegate(Map<String, Object> attributes) throws CoreException {
        return JDIDebugModel.createMethodBreakpoint((IResource)this.getMarker().getResource(), (String)this._type, (String)HANDLE_MESSAGE, (String)SIGNATURE, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)false, attributes);
    }

    protected IJavaMethodBreakpoint createHandleFaultDelegate(Map<String, Object> attributes) throws CoreException {
        return JDIDebugModel.createMethodBreakpoint((IResource)this.getMarker().getResource(), (String)this._type, (String)HANDLE_FAULT, (String)SIGNATURE, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)false, attributes);
    }

    protected IJavaMethodBreakpoint getHandleMessageDelegate() {
        return (IJavaMethodBreakpoint)this.getDelegate(HANDLE_MESSAGE);
    }

    protected IJavaMethodBreakpoint getHandleFaultDelegate() {
        return (IJavaMethodBreakpoint)this.getDelegate(HANDLE_FAULT);
    }

    @Override
    protected void configurationUpdated() throws CoreException {
        this.setMessageCondition(this.getHandleMessageDelegate());
        this.setFaultCondition(this.getHandleFaultDelegate());
        super.configurationUpdated();
    }

    @Override
    protected void updateEnabled(boolean enabled) throws CoreException {
        IJavaMethodBreakpoint handleMessageDelegate = this.getHandleMessageDelegate();
        IJavaMethodBreakpoint handleFaultDelegate = this.getHandleFaultDelegate();
        if (enabled) {
            if (handleMessageDelegate != null) {
                handleMessageDelegate.setEnabled(true);
            }
            if (handleFaultDelegate != null) {
                if (this.triggersOnFault()) {
                    handleFaultDelegate.setEnabled(true);
                } else {
                    handleFaultDelegate.setEnabled(false);
                }
            }
        } else {
            if (handleMessageDelegate != null) {
                handleMessageDelegate.setEnabled(false);
            }
            if (handleFaultDelegate != null) {
                handleFaultDelegate.setEnabled(false);
            }
        }
    }

    protected boolean triggersOnFault() {
        Set<IInteractionConfiguration.TriggerType> triggers = this.getInteractionConfiguration().getTriggers();
        return triggers == null || triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT) || triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT);
    }

    protected String createMessageCondition() {
        IInteractionConfiguration config = this.getInteractionConfiguration();
        if (config == null) {
            return null;
        }
        SwitchYardExchangeConditionBuilder builder = new SwitchYardExchangeConditionBuilder(this._exchangeVariable);
        Set<IInteractionConfiguration.TriggerType> triggers = config.getTriggers();
        String triggerCondition = builder.exchangePhase(triggers == null || triggers.isEmpty() ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : triggers);
        String providerCondition = builder.provider(config.getProviderName());
        String consumerCondition = builder.consumer(config.getConsumerName());
        StringBuffer buffer = new StringBuffer();
        if (triggerCondition != null) {
            buffer.append(triggerCondition);
        }
        if (providerCondition != null) {
            if (buffer.length() > 0) {
                buffer.append("\n        && ");
            }
            buffer.append(providerCondition);
        }
        if (consumerCondition != null) {
            if (buffer.length() > 0) {
                buffer.append("\n        && ");
            }
            buffer.append(consumerCondition);
        }
        if (buffer.length() == 0) {
            return null;
        }
        buffer.insert(0, '(');
        buffer.append(")");
        return buffer.toString();
    }

    protected String createFaultCondition() {
        IInteractionConfiguration config = this.getInteractionConfiguration();
        if (config == null) {
            return null;
        }
        SwitchYardExchangeConditionBuilder builder = new SwitchYardExchangeConditionBuilder(this._exchangeVariable);
        String providerCondition = builder.provider(config.getProviderName());
        String consumerCondition = builder.consumer(config.getConsumerName());
        StringBuffer buffer = new StringBuffer();
        if (providerCondition != null) {
            buffer.append(providerCondition);
        }
        if (consumerCondition != null) {
            if (buffer.length() > 0) {
                buffer.append("\n        && ");
            }
            buffer.append(consumerCondition);
        }
        if (buffer.length() == 0) {
            return null;
        }
        buffer.insert(0, '(');
        buffer.append(")");
        return buffer.toString();
    }

    private void setMessageCondition(IJavaMethodBreakpoint delegate) throws CoreException {
        this.updateCondition(this.createMessageCondition(), delegate);
    }

    private void setFaultCondition(IJavaMethodBreakpoint delegate) throws CoreException {
        this.updateCondition(this.createFaultCondition(), delegate);
    }

    private void updateCondition(String newCondition, IJavaMethodBreakpoint delegate) throws CoreException {
        if (delegate == null) {
            return;
        }
        String oldCondition = delegate.getCondition();
        if (newCondition == null) {
            if (oldCondition == null) {
                return;
            }
            delegate.setConditionEnabled(false);
            delegate.setCondition(null);
        } else {
            if (newCondition.equals(oldCondition)) {
                return;
            }
            delegate.setCondition(newCondition);
            if (!delegate.isConditionEnabled()) {
                delegate.setConditionEnabled(true);
            }
        }
    }
}

